/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.compiler.grammar;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeElementDeclaration;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.MemberDeclaration;
import com.sun.mirror.type.ArrayType;
import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.type.ReferenceType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.type.VoidType;
import org.apache.beehive.netui.compiler.AnnotationGrammar;
import org.apache.beehive.netui.compiler.AnnotationMemberType;
import org.apache.beehive.netui.compiler.CompilerUtils;

public class TypeNameType
extends AnnotationMemberType {
    private String _requiredSuperclassName;
    private boolean _allowArrayType;

    public TypeNameType(String requiredSuperclassName, boolean allowArrayType, String requiredRuntimeVersion, AnnotationGrammar parentGrammar) {
        super(requiredRuntimeVersion, parentGrammar);
        this._requiredSuperclassName = requiredSuperclassName;
        this._allowArrayType = allowArrayType;
    }

    public Object onCheck(AnnotationTypeElementDeclaration valueDecl, AnnotationValue value, AnnotationMirror[] parentAnnotations, MemberDeclaration classMember) {
        Object val = value.getValue();
        if (val instanceof PrimitiveType) {
            this.addError(value, "error.primitive-type-not-allowed", new Object[0]);
            return null;
        }
        if (val instanceof VoidType) {
            this.addError(value, "error.void-type-not-allowed", new Object[0]);
            return null;
        }
        assert (val instanceof ReferenceType) : val.getClass().getName();
        ReferenceType type = (ReferenceType)val;
        if (!this._allowArrayType && type instanceof ArrayType) {
            this.addError(value, "error.array-type-not-allowed", new Object[0]);
            return null;
        }
        if (this._requiredSuperclassName != null && !CompilerUtils.isAssignableFrom(this._requiredSuperclassName, (TypeMirror)type, this.getEnv())) {
            this.addError(value, "error.does-not-extend-base", this._requiredSuperclassName);
            return null;
        }
        this.checkType(type, value);
        return type;
    }

    protected void checkType(ReferenceType type, AnnotationValue member) {
    }
}

