/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.compiler.grammar;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeElementDeclaration;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.MemberDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import java.util.Collection;
import org.apache.beehive.netui.compiler.AnnotationMemberType;
import org.apache.beehive.netui.compiler.CompilerUtils;
import org.apache.beehive.netui.compiler.Diagnostics;
import org.apache.beehive.netui.compiler.FlowControllerInfo;
import org.apache.beehive.netui.compiler.RuntimeVersionChecker;
import org.apache.beehive.netui.compiler.grammar.ActionGrammar;
import org.apache.beehive.netui.compiler.grammar.ForwardGrammar;
import org.apache.beehive.netui.compiler.grammar.WebappPathOrActionType;

public class SimpleActionGrammar
extends ActionGrammar {
    private static String[][] REQUIRED_ATTRS = new String[][]{{"name"}, {"path", "tilesDefinition", "returnAction", "navigateTo", "forwardRef"}};
    private static String[][] MUTUALLY_EXCLUSIVE_ATTRS = new String[][]{{"path", "tilesDefinition", "returnAction", "navigateTo", "forwardRef"}, {"forwardRef", "outputFormBeanType", "outputFormBean"}, {"forwardRef", "redirect", "externalRedirect"}, {"forwardRef", "actionOutputs"}};
    private ForwardGrammar _forwardGrammar;

    public SimpleActionGrammar(AnnotationProcessorEnvironment env, Diagnostics diags, RuntimeVersionChecker rvc, FlowControllerInfo fcInfo) {
        super(env, diags, rvc, fcInfo);
        this.addMemberType("forwardRef", new ForwardRefType());
        this.addMemberArrayGrammar("conditionalForwards", new SimpleActionForwardGrammar(env, diags, null, rvc, fcInfo));
        this._forwardGrammar = new SimpleActionGrammarPart2();
    }

    protected boolean onBeginCheck(AnnotationMirror annotation, AnnotationMirror[] parentAnnotations, MemberDeclaration classMember) {
        TypeDeclaration outerClass;
        String name = CompilerUtils.getString(annotation, "name", false);
        if (WebappPathOrActionType.actionExists(name, outerClass = CompilerUtils.getOuterClass(classMember), annotation, this.getEnv(), this.getFlowControllerInfo(), false)) {
            this.addError(annotation, "error.duplicate-action", name);
        }
        this._forwardGrammar.check(annotation, parentAnnotations, classMember);
        return true;
    }

    private class SimpleActionGrammarPart2
    extends ForwardGrammar {
        public SimpleActionGrammarPart2() {
            super(SimpleActionGrammar.this.getEnv(), SimpleActionGrammar.this.getDiagnostics(), null, SimpleActionGrammar.this.getRuntimeVersionChecker(), SimpleActionGrammar.this.getFlowControllerInfo());
        }

        public String[][] getRequiredAttrs() {
            return REQUIRED_ATTRS;
        }
    }

    private class ForwardRefType
    extends AnnotationMemberType {
        public ForwardRefType() {
            super(null, SimpleActionGrammar.this);
        }

        public Object onCheck(AnnotationTypeElementDeclaration valueDecl, AnnotationValue member, AnnotationMirror[] parentAnnotations, MemberDeclaration classMember) {
            Collection<AnnotationMirror> forwards = SimpleActionGrammar.this.getFlowControllerInfo().getMergedControllerAnnotation().getForwards();
            String forwardName = (String)member.getValue();
            for (AnnotationMirror forwardAnn : forwards) {
                if (!forwardName.equals(CompilerUtils.getString(forwardAnn, "name", true))) continue;
                return null;
            }
            this.addError(member, "error.unresolvable-global-forward", forwardName);
            return null;
        }
    }

    private static class SimpleActionForwardGrammar
    extends ForwardGrammar {
        private static String[][] REQUIRED_ATTRS = new String[][]{{"path", "tilesDefinition", "returnAction", "navigateTo"}};

        public SimpleActionForwardGrammar(AnnotationProcessorEnvironment env, Diagnostics diags, String requiredRuntimeVersion, RuntimeVersionChecker runtimeVersionChecker, FlowControllerInfo fcInfo) {
            super(env, diags, requiredRuntimeVersion, runtimeVersionChecker, fcInfo);
        }

        public String[][] getRequiredAttrs() {
            return REQUIRED_ATTRS;
        }

        protected AnnotationMemberType getNameType() {
            return new SimpleActionForwardNameType();
        }

        private class SimpleActionForwardNameType
        extends ForwardGrammar.ForwardNameType {
            public SimpleActionForwardNameType() {
                super("conditionalForwards");
            }
        }
    }
}

