/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.compiler.grammar;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeElementDeclaration;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.MemberDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import java.util.Collection;
import org.apache.beehive.netui.compiler.AnnotationGrammar;
import org.apache.beehive.netui.compiler.AnnotationMemberType;
import org.apache.beehive.netui.compiler.CompilerUtils;

public class MemberMethodType
extends AnnotationMemberType {
    private String _requiredMethodAnnotation;
    private String _errorCode;

    public MemberMethodType(String requiredMethodAnnotation, String errorCode, String requiredRuntimeVersion, AnnotationGrammar parentGrammar) {
        super(requiredRuntimeVersion, parentGrammar);
        this._requiredMethodAnnotation = requiredMethodAnnotation;
        this._errorCode = errorCode;
    }

    public Object onCheck(AnnotationTypeElementDeclaration valueDecl, AnnotationValue value, AnnotationMirror[] parentAnnotations, MemberDeclaration classMember) {
        TypeDeclaration outerType = CompilerUtils.getOuterClass(classMember);
        Collection<MethodDeclaration> methods = CompilerUtils.getClassMethods(outerType, null);
        String methodName = (String)value.getValue();
        for (MethodDeclaration method : methods) {
            if (!method.getSimpleName().equals(methodName) || this._requiredMethodAnnotation != null && CompilerUtils.getAnnotation((Declaration)method, this._requiredMethodAnnotation) == null) continue;
            this.checkMethod(method, value, parentAnnotations, classMember);
            return method;
        }
        this.addError(value, this._errorCode, methodName);
        return null;
    }

    protected MethodDeclaration findMethod(String methodName, TypeDeclaration outerType) {
        Collection<MethodDeclaration> methods = CompilerUtils.getClassMethods(outerType, null);
        for (MethodDeclaration method : methods) {
            if (!method.getSimpleName().equals(methodName) || this._requiredMethodAnnotation != null && CompilerUtils.getAnnotation((Declaration)method, this._requiredMethodAnnotation) == null) continue;
            return method;
        }
        return null;
    }

    protected void checkMethod(MethodDeclaration method, AnnotationValue member, AnnotationMirror[] parentAnnotations, MemberDeclaration classMember) {
    }
}

