/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.compiler.grammar;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeElementDeclaration;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.MemberDeclaration;
import java.util.Collection;
import org.apache.beehive.netui.compiler.AnnotationGrammar;
import org.apache.beehive.netui.compiler.AnnotationMemberType;
import org.apache.beehive.netui.compiler.CompilerUtils;

public class MemberFieldType
extends AnnotationMemberType {
    private String _requiredSuperclassName;

    public MemberFieldType(String requiredSuperclassName, String requiredRuntimeVersion, AnnotationGrammar parentGrammar) {
        super(requiredRuntimeVersion, parentGrammar);
        this._requiredSuperclassName = requiredSuperclassName;
    }

    public Object onCheck(AnnotationTypeElementDeclaration valueDecl, AnnotationValue member, AnnotationMirror[] parentAnnotations, MemberDeclaration classMember) {
        String fieldName = (String)member.getValue();
        Collection<FieldDeclaration> fields = CompilerUtils.getClassFields(CompilerUtils.getOuterClass(classMember));
        for (FieldDeclaration field : fields) {
            if (!field.getSimpleName().equals(fieldName)) continue;
            if (this._requiredSuperclassName != null && !CompilerUtils.isAssignableFrom(this._requiredSuperclassName, field.getType(), this.getEnv())) {
                this.addError(member, "error.wrong-field-type", fieldName, this._requiredSuperclassName);
                return null;
            }
            return field;
        }
        this.addError(member, "error.unresolved-field", fieldName);
        return null;
    }
}

