/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.compiler.grammar;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeElementDeclaration;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.MemberDeclaration;
import org.apache.beehive.netui.compiler.AnnotationGrammar;
import org.apache.beehive.netui.compiler.AnnotationMemberType;
import org.apache.beehive.netui.compiler.CompilerUtils;
import org.apache.beehive.netui.compiler.Diagnostics;
import org.apache.beehive.netui.compiler.RuntimeVersionChecker;
import org.apache.beehive.netui.compiler.grammar.BaseValidationRuleGrammar;
import org.apache.beehive.netui.compiler.grammar.ValidateCustomGrammar;
import org.apache.beehive.netui.compiler.grammar.ValidateRangeGrammar;
import org.apache.beehive.netui.compiler.grammar.ValidateTypeGrammar;
import org.apache.beehive.netui.compiler.grammar.ValidateValidWhenGrammar;

public class LocaleRulesGrammar
extends AnnotationGrammar {
    private static final String[][] REQUIRED_ATTRS = new String[][]{{"applyToUnhandledLocales", "language"}};
    private static final String[][] ATTR_DEPENDENCIES = new String[][]{{"country", "language"}, {"variant", "language"}};

    public LocaleRulesGrammar(AnnotationProcessorEnvironment env, Diagnostics diags, RuntimeVersionChecker rvc) {
        super(env, diags, "3", rvc);
        this.addMemberGrammar("validateRequired", new BaseValidationRuleGrammar(env, diags, rvc));
        this.addMemberGrammar("validateRange", new ValidateRangeGrammar(env, diags, rvc));
        this.addMemberGrammar("validateMinLength", new BaseValidationRuleGrammar(env, diags, rvc));
        this.addMemberGrammar("validateMaxLength", new BaseValidationRuleGrammar(env, diags, rvc));
        this.addMemberGrammar("validateCreditCard", new BaseValidationRuleGrammar(env, diags, rvc));
        this.addMemberGrammar("validateEmail", new BaseValidationRuleGrammar(env, diags, rvc));
        this.addMemberGrammar("validateMask", new BaseValidationRuleGrammar(env, diags, rvc));
        this.addMemberGrammar("validateDate", new BaseValidationRuleGrammar(env, diags, rvc));
        this.addMemberGrammar("validateType", new ValidateTypeGrammar(env, diags, rvc));
        this.addMemberGrammar("validateCustom", new ValidateCustomGrammar(env, diags, rvc));
        this.addMemberGrammar("validateValidWhen", new ValidateValidWhenGrammar(env, diags, rvc));
        this.addMemberType("language", new AnnotationMemberType(null, this));
        this.addMemberType("country", new AnnotationMemberType(null, this));
        this.addMemberType("variant", new AnnotationMemberType(null, this));
        this.addMemberType("applyToUnhandledLocales", new ApplyToUnhandledLocalesType());
    }

    public String[][] getRequiredAttrs() {
        return REQUIRED_ATTRS;
    }

    public String[][] getAttrDependencies() {
        return ATTR_DEPENDENCIES;
    }

    private class ApplyToUnhandledLocalesType
    extends AnnotationMemberType {
        public ApplyToUnhandledLocalesType() {
            super(null, LocaleRulesGrammar.this);
        }

        public Object onCheck(AnnotationTypeElementDeclaration valueDecl, AnnotationValue member, AnnotationMirror[] parentAnnotations, MemberDeclaration classMember) {
            AnnotationMirror parentAnnotation = parentAnnotations[parentAnnotations.length - 1];
            String language = CompilerUtils.getString(parentAnnotation, "language", true);
            if (((Boolean)member.getValue()).booleanValue()) {
                if (language != null) {
                    this.addError(member, "error.incompatible-locale-annotations", "language", "applyToUnhandledLocales");
                }
            } else if (language == null || language.length() == 0) {
                this.addError(member, "error.missing-locale-annotations", "language", "applyToUnhandledLocales");
            }
            return null;
        }
    }
}

