/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.compiler.grammar;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeElementDeclaration;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.MemberDeclaration;
import org.apache.beehive.netui.compiler.AnnotationGrammar;
import org.apache.beehive.netui.compiler.AnnotationMemberType;

public class JavaIdentifierType
extends AnnotationMemberType {
    private char[] _validChars;

    public JavaIdentifierType(String requiredRuntimeVersion, AnnotationGrammar parentGrammar, char ... validChars) {
        super(requiredRuntimeVersion, parentGrammar);
        this._validChars = validChars;
    }

    public Object onCheck(AnnotationTypeElementDeclaration valueDecl, AnnotationValue value, AnnotationMirror[] parentAnnotations, MemberDeclaration classMember) {
        String val = (String)value.getValue();
        if (val.length() > 0) {
            char firstChar = val.charAt(0);
            if (!Character.isJavaIdentifierStart(firstChar)) {
                Object[] args = new Object[]{new Character(firstChar)};
                this.addError(value, "error.invalid-java-identifier-start", args);
            }
            for (int i = 1; i < val.length(); ++i) {
                char c = val.charAt(i);
                if (Character.isJavaIdentifierPart(val.charAt(i)) || this.isValid(c)) continue;
                Object[] args = new Object[]{Character.valueOf(c)};
                this.addError(value, "error.invalid-java-identifier-part", args);
            }
        }
        return null;
    }

    private boolean isValid(char c) {
        if (this._validChars != null) {
            for (int i = 0; i < this._validChars.length; ++i) {
                if (c != this._validChars[i]) continue;
                return true;
            }
        }
        return false;
    }
}

