/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.compiler.grammar;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeElementDeclaration;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.MemberDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.TypeMirror;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.beehive.netui.compiler.AnnotationMemberType;
import org.apache.beehive.netui.compiler.CompilerUtils;
import org.apache.beehive.netui.compiler.Diagnostics;
import org.apache.beehive.netui.compiler.FlowControllerInfo;
import org.apache.beehive.netui.compiler.RuntimeVersionChecker;
import org.apache.beehive.netui.compiler.grammar.AbsolutePathType;
import org.apache.beehive.netui.compiler.grammar.ActionOutputGrammar;
import org.apache.beehive.netui.compiler.grammar.BaseFlowControllerGrammar;
import org.apache.beehive.netui.compiler.grammar.EnumType;
import org.apache.beehive.netui.compiler.grammar.ExternalPathOrActionType;
import org.apache.beehive.netui.compiler.grammar.JavaIdentifierType;
import org.apache.beehive.netui.compiler.grammar.MemberFieldType;
import org.apache.beehive.netui.compiler.grammar.TypeNameType;
import org.apache.beehive.netui.compiler.grammar.UniqueValueType;

public class ForwardGrammar
extends BaseFlowControllerGrammar {
    private static final String[][] NAVIGATE_TO_VALS = new String[][]{{"currentPage", "2"}, {"previousPage", "2"}, {"page", null}, {"previousAction", "2"}};
    private static final String[][] DEPRECATED_NAVIGATE_TO_VALS = new String[][]{{"page", "warning.return-to-page-deprecated"}};
    private static String[][] MUTUALLY_EXCLUSIVE_ATTRS = new String[][]{{"path", "tilesDefinition", "returnAction", "navigateTo"}, {"outputFormBeanType", "outputFormBean"}, {"redirect", "externalRedirect"}};
    private static String[][] REQUIRED_ATTRS = new String[][]{{"name"}, {"path", "tilesDefinition", "returnAction", "navigateTo"}};
    private static String[][] ATTR_DEPENDENCIES = new String[][]{{"redirect", "path", "navigateTo"}, {"externalRedirect", "path"}, {"restoreQueryString", "navigateTo"}};

    public ForwardGrammar(AnnotationProcessorEnvironment env, Diagnostics diags, String requiredRuntimeVersion, RuntimeVersionChecker runtimeVersionChecker, FlowControllerInfo fcInfo) {
        super(env, diags, requiredRuntimeVersion, runtimeVersionChecker, fcInfo);
        this.addMemberType("name", this.getNameType());
        this.addMemberType("outputFormBeanType", new TypeNameType(null, false, null, this));
        this.addMemberType("outputFormBean", new MemberFieldType(null, null, this));
        this.addMemberType("returnAction", new JavaIdentifierType(null, this, '.'));
        this.addMemberType("path", new ExternalPathOrActionType(false, null, this, fcInfo));
        this.addMemberType("tilesDefinition", new AnnotationMemberType(null, this));
        this.addMemberType("redirect", new AnnotationMemberType(null, this));
        this.addMemberType("externalRedirect", new AbsolutePathType(null, this));
        this.addMemberType("navigateTo", new EnumType(NAVIGATE_TO_VALS, DEPRECATED_NAVIGATE_TO_VALS, null, this));
        this.addMemberType("restoreQueryString", new AnnotationMemberType("3", this));
        this.addMemberArrayGrammar("actionOutputs", new ActionOutputGrammar(env, diags, runtimeVersionChecker));
    }

    protected AnnotationMemberType getNameType() {
        return new ForwardNameType();
    }

    public String[][] getMutuallyExclusiveAttrs() {
        return MUTUALLY_EXCLUSIVE_ATTRS;
    }

    public String[][] getRequiredAttrs() {
        return REQUIRED_ATTRS;
    }

    public String[][] getAttrDependencies() {
        return ATTR_DEPENDENCIES;
    }

    protected void onCheckMember(AnnotationTypeElementDeclaration memberDecl, AnnotationValue value, AnnotationMirror annotation, AnnotationMirror[] parentAnnotations, MemberDeclaration classMember) {
        String valueName = memberDecl.getSimpleName();
        boolean isReturnAction = valueName.equals("returnAction");
        if (isReturnAction && !this.getFlowControllerInfo().isNested()) {
            this.addError(value, "error.only-valid-in-nested", valueName);
        }
        if (valueName.equals("actionOutputs") && ((List)value.getValue()).size() > 0) {
            String path;
            if (CompilerUtils.getBoolean(annotation, "redirect", false).booleanValue()) {
                this.addError(value, "error.action-outputs-with-redirect", "redirect");
            }
            if ((path = CompilerUtils.getString(annotation, "path", true)) != null && CompilerUtils.isAbsoluteURI(path)) {
                this.addError(value, "error.action-outputs-with-absolute-uri", "path");
            }
        }
        if (isReturnAction) {
            FieldDeclaration field;
            String memberFieldName;
            DeclaredType formBeanType = CompilerUtils.getDeclaredType(annotation, "outputFormBeanType", true);
            if (formBeanType == null && (memberFieldName = CompilerUtils.getString(annotation, "outputFormBean", true)) != null && (field = CompilerUtils.findField(CompilerUtils.getOuterClass(classMember), memberFieldName)) != null) {
                TypeMirror fieldType = field.getType();
                if (!(fieldType instanceof DeclaredType)) {
                    this.addError(annotation, "error.invalid-form-member-type", field.getSimpleName());
                } else {
                    formBeanType = (DeclaredType)fieldType;
                }
            }
            String actionName = (String)value.getValue();
            String formTypeName = formBeanType != null ? CompilerUtils.getDeclaration(formBeanType).getQualifiedName() : null;
            this.getFlowControllerInfo().addReturnAction(actionName, formTypeName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ForwardNameType
    extends UniqueValueType {
        public ForwardNameType() {
            this("forwards");
        }

        protected ForwardNameType(String memberGroupName) {
            super(memberGroupName, false, false, null, ForwardGrammar.this);
        }

        @Override
        protected List<AnnotationMirror> getAdditionalAnnotationsToCheck(MemberDeclaration classMember) {
            ArrayList<AnnotationMirror> additionalEntities = new ArrayList<AnnotationMirror>();
            TypeDeclaration outerType = CompilerUtils.getOuterClass(classMember);
            Collection<AnnotationMirror> classLevelCatches = ForwardGrammar.this.getFlowControllerInfo().getMergedControllerAnnotation().getCatches();
            this.addAdditionalAnnotationsToCheck(classLevelCatches, outerType, additionalEntities);
            if (classMember instanceof MethodDeclaration) {
                List<AnnotationMirror> methodLevelCatches = CompilerUtils.getAnnotationArrayValue((Declaration)classMember, "Action", "catches", true);
                this.addAdditionalAnnotationsToCheck(methodLevelCatches, outerType, additionalEntities);
            }
            return additionalEntities;
        }

        private void addAdditionalAnnotationsToCheck(Collection<AnnotationMirror> catches, TypeDeclaration outerType, List additionalEntities) {
            if (catches != null) {
                for (AnnotationMirror catchAnnotation : catches) {
                    String methodName = CompilerUtils.getString(catchAnnotation, "method", false);
                    if (methodName.length() <= 0) continue;
                    Collection<MethodDeclaration> allMethods = CompilerUtils.getClassMethods(outerType, null);
                    for (MethodDeclaration method : allMethods) {
                        AnnotationMirror exHandlerAnnotation = CompilerUtils.getAnnotation((Declaration)method, "ExceptionHandler");
                        if (exHandlerAnnotation == null || !method.getSimpleName().equals(methodName)) continue;
                        List<AnnotationMirror> forwardAnnotations = CompilerUtils.getAnnotationArray(exHandlerAnnotation, "forwards", false);
                        for (AnnotationMirror forwardAnnotation : forwardAnnotations) {
                            additionalEntities.add(forwardAnnotation);
                        }
                    }
                }
            }
        }

        @Override
        protected String getErrorMessageExtraInfo() {
            return "Catch";
        }

        @Override
        protected boolean allowExactDuplicates() {
            return true;
        }
    }
}

