/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.compiler.grammar;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.MemberDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.Modifier;
import com.sun.mirror.declaration.TypeDeclaration;
import java.util.Collection;
import org.apache.beehive.netui.compiler.AnnotationMemberType;
import org.apache.beehive.netui.compiler.CompilerUtils;
import org.apache.beehive.netui.compiler.Diagnostics;
import org.apache.beehive.netui.compiler.FlowControllerInfo;
import org.apache.beehive.netui.compiler.RuntimeVersionChecker;
import org.apache.beehive.netui.compiler.grammar.BaseFlowControllerGrammar;
import org.apache.beehive.netui.compiler.grammar.ExternalPathOrActionType;
import org.apache.beehive.netui.compiler.grammar.ForwardGrammar;
import org.apache.beehive.netui.compiler.grammar.ForwardToExternalPathType;
import org.apache.beehive.netui.compiler.grammar.UniqueValueType;

public class ExceptionHandlerGrammar
extends BaseFlowControllerGrammar {
    public ExceptionHandlerGrammar(AnnotationProcessorEnvironment env, Diagnostics diags, RuntimeVersionChecker runtimeVersionChecker, FlowControllerInfo fcInfo) {
        super(env, diags, null, runtimeVersionChecker, fcInfo);
        this.addMemberType("readOnly", new AnnotationMemberType("2", this));
        this.addMemberArrayGrammar("forwards", new ExceptionHandlerForwardGrammar(fcInfo));
    }

    protected boolean onBeginCheck(AnnotationMirror annotation, AnnotationMirror[] parentAnnotations, MemberDeclaration classMember) {
        if (CompilerUtils.hasModifier((Declaration)classMember, Modifier.ABSTRACT)) {
            this.addWarning(annotation, "warning.annotated-abstract-method", new Object[0]);
            return false;
        }
        TypeDeclaration outerType = CompilerUtils.getOuterClass(classMember);
        String thisMethodName = classMember.getSimpleName();
        Collection<MethodDeclaration> classMethods = CompilerUtils.getClassMethods(outerType, "ExceptionHandler");
        for (MethodDeclaration method : classMethods) {
            if (method.equals(classMember) || !method.getSimpleName().equals(thisMethodName)) continue;
            this.addError(annotation, "error.duplicate-exception-handler", new Object[0]);
        }
        return super.onBeginCheck(annotation, parentAnnotations, classMember);
    }

    private class ExceptionHandlerForwardGrammar
    extends ForwardGrammar {
        public ExceptionHandlerForwardGrammar(FlowControllerInfo fcInfo) {
            super(ExceptionHandlerGrammar.this.getEnv(), ExceptionHandlerGrammar.this.getDiagnostics(), ExceptionHandlerGrammar.this.getRequiredRuntimeVersion(), ExceptionHandlerGrammar.this.getRuntimeVersionChecker(), fcInfo);
            ExternalPathOrActionType baseType = new ExternalPathOrActionType(false, null, this, fcInfo);
            this.addMemberType("path", new ForwardToExternalPathType(baseType, null, ExceptionHandlerGrammar.this));
        }

        protected AnnotationMemberType getNameType() {
            return new UniqueValueType("forwards", false, false, null, this);
        }
    }
}

