/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.compiler.grammar;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeElementDeclaration;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.MemberDeclaration;
import java.util.HashMap;
import java.util.Map;
import org.apache.beehive.netui.compiler.AnnotationGrammar;
import org.apache.beehive.netui.compiler.AnnotationMemberType;
import org.apache.beehive.netui.compiler.CompilerUtils;

public class EnumType
extends AnnotationMemberType {
    private Map _enumRequiredRuntimeVersions = null;
    private Map _deprecatedValues;

    public EnumType(String[][] enumValues, String[][] deprecatedValues, String requiredRuntimeVersion, AnnotationGrammar parentGrammar) {
        super(requiredRuntimeVersion, parentGrammar);
        int i;
        if (deprecatedValues != null) {
            this._deprecatedValues = new HashMap();
            for (i = 0; i < deprecatedValues.length; ++i) {
                String[] valueAndDiagnostic = deprecatedValues[i];
                assert (valueAndDiagnostic.length == 2);
                this._deprecatedValues.put(valueAndDiagnostic[0], valueAndDiagnostic[1]);
            }
        }
        if (enumValues != null) {
            this._enumRequiredRuntimeVersions = new HashMap();
            for (i = 0; i < enumValues.length; ++i) {
                String[] valueAndRequiredRuntimeVersion = enumValues[i];
                assert (valueAndRequiredRuntimeVersion.length == 2);
                String enumValue = valueAndRequiredRuntimeVersion[0];
                String enumValRequiredRuntimeVersion = valueAndRequiredRuntimeVersion[1];
                if (enumValRequiredRuntimeVersion == null) continue;
                this._enumRequiredRuntimeVersions.put(enumValue, enumValRequiredRuntimeVersion);
            }
        }
    }

    public Object onCheck(AnnotationTypeElementDeclaration valueDecl, AnnotationValue member, AnnotationMirror[] parentAnnotations, MemberDeclaration classMember) {
        String ver;
        String errorKey;
        String val = CompilerUtils.getEnumFieldName(member);
        String string = errorKey = this._deprecatedValues != null ? (String)this._deprecatedValues.get(val) : null;
        if (errorKey != null) {
            this.addWarning(member, errorKey, val);
        }
        String string2 = ver = this._enumRequiredRuntimeVersions != null ? (String)this._enumRequiredRuntimeVersions.get(val) : null;
        if (ver != null) {
            this.getParentGrammar().getRuntimeVersionChecker().checkRuntimeVersion(ver, member, this.getParentGrammar().getDiagnostics(), "error.required-runtime-version-enumval", val, "/WEB-INF/lib/beehive-netui-pageflow.jar");
        }
        return super.onCheck(valueDecl, member, parentAnnotations, classMember);
    }
}

