/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.compiler.grammar;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.MemberDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.TypeMirror;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.beehive.netui.compiler.AnnotationMemberType;
import org.apache.beehive.netui.compiler.CompilerUtils;
import org.apache.beehive.netui.compiler.Diagnostics;
import org.apache.beehive.netui.compiler.FlowControllerInfo;
import org.apache.beehive.netui.compiler.JpfLanguageConstants;
import org.apache.beehive.netui.compiler.RuntimeVersionChecker;
import org.apache.beehive.netui.compiler.grammar.BaseFlowControllerGrammar;
import org.apache.beehive.netui.compiler.grammar.ForwardToExternalPathType;
import org.apache.beehive.netui.compiler.grammar.MemberMethodType;
import org.apache.beehive.netui.compiler.grammar.TypeNameType;
import org.apache.beehive.netui.compiler.grammar.WebappPathOrActionType;

public class CatchGrammar
extends BaseFlowControllerGrammar {
    private static String[][] MUTUALLY_EXCLUSIVE_ATTRS = new String[][]{{"path", "method"}};
    private static String[][] REQUIRED_ATTRS = new String[][]{{"type"}, {"path", "method"}};
    private String _annotationRootName;

    public CatchGrammar(AnnotationProcessorEnvironment env, Diagnostics diags, String requiredRuntimeVersion, RuntimeVersionChecker runtimeVersionChecker, String annotationRootName, FlowControllerInfo fcInfo) {
        super(env, diags, requiredRuntimeVersion, runtimeVersionChecker, fcInfo);
        this._annotationRootName = annotationRootName;
        this.addMemberType("method", new CatchTagMethodType());
        this.addMemberType("type", new TypeNameType(JpfLanguageConstants.THROWABLE_CLASS_NAME, false, null, this));
        this.addMemberType("path", new ForwardToExternalPathType(new WebappPathOrActionType(false, null, this, fcInfo), null, this));
        this.addMemberType("message", new AnnotationMemberType(null, this));
        this.addMemberType("messageKey", new AnnotationMemberType(null, this));
    }

    public String[][] getMutuallyExclusiveAttrs() {
        return MUTUALLY_EXCLUSIVE_ATTRS;
    }

    public String[][] getRequiredAttrs() {
        return REQUIRED_ATTRS;
    }

    protected Object onEndCheck(AnnotationMirror annotation, AnnotationMirror[] parentAnnotations, MemberDeclaration classMember, Map checkResults) {
        TypeMirror handledExceptionType;
        MethodDeclaration handlerMethod = (MethodDeclaration)checkResults.get("method");
        DeclaredType exceptionType = (DeclaredType)checkResults.get("type");
        if (handlerMethod == null || exceptionType == null) {
            return null;
        }
        Collection parameters = handlerMethod.getParameters();
        if (parameters.size() > 0 && !CompilerUtils.isAssignableFrom(handledExceptionType = ((ParameterDeclaration)parameters.iterator().next()).getType(), CompilerUtils.getDeclaration(exceptionType))) {
            this.addError(annotation, "error.incompatible-exception-handler", handlerMethod.getSimpleName(), CompilerUtils.getDeclaration(exceptionType).getQualifiedName());
        }
        return null;
    }

    private class CatchTagMethodType
    extends MemberMethodType {
        public CatchTagMethodType() {
            super("ExceptionHandler", "error.unresolved-exception-handler", null, CatchGrammar.this);
        }

        protected void checkMethod(MethodDeclaration methodBeingChecked, AnnotationValue value, AnnotationMirror[] parentAnnotations, MemberDeclaration classMember) {
            List<AnnotationMirror> catches = CompilerUtils.getAnnotationArrayValue((Declaration)classMember, CatchGrammar.this._annotationRootName, "catches", true);
            TypeDeclaration outerType = CompilerUtils.getOuterClass(classMember);
            if (catches == null) {
                return;
            }
            for (AnnotationMirror catchAnnotation : catches) {
                MethodDeclaration otherMethod;
                String methodName = CompilerUtils.getString(catchAnnotation, "method", false);
                if (methodName.length() <= 0 || methodName.equals(methodBeingChecked.getSimpleName()) || (otherMethod = this.findMethod(methodName, outerType)) == null) continue;
                List<AnnotationMirror> otherForwards = CompilerUtils.getAnnotationArrayValue((Declaration)otherMethod, "ExceptionHandler", "forwards", false);
                for (AnnotationMirror otherForward : otherForwards) {
                    String otherForwardName = CompilerUtils.getString(otherForward, "name", true);
                    String otherForwardPath = CompilerUtils.getString(otherForward, "path", true);
                    String otherFwdNavigateTo = CompilerUtils.getEnumFieldName(otherForward, "navigateTo", true);
                    List<AnnotationMirror> forwards = CompilerUtils.getAnnotationArrayValue((Declaration)methodBeingChecked, "ExceptionHandler", "forwards", false);
                    for (AnnotationMirror forward : forwards) {
                        String forwardName = CompilerUtils.getString(forward, "name", true);
                        String forwardPath = CompilerUtils.getString(forward, "path", true);
                        String fwdNavigateTo = CompilerUtils.getEnumFieldName(forward, "navigateTo", true);
                        if (forwardName == null || !forwardName.equals(otherForwardName) || forwardPath != null && forwardPath.equals(otherForwardPath) || fwdNavigateTo != null && fwdNavigateTo.equals(otherFwdNavigateTo)) continue;
                        this.addError(value, "error.duplicate-exception-handler-forwards", methodBeingChecked.getSimpleName(), methodName, forwardName);
                    }
                }
            }
        }
    }
}

