/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.compiler.genmodel;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.Modifier;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.DeclaredType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.beehive.netui.compiler.CompilerUtils;
import org.apache.beehive.netui.compiler.JpfLanguageConstants;
import org.apache.beehive.netui.compiler.MergedControllerAnnotation;
import org.apache.beehive.netui.compiler.genmodel.DefaultValidatorRuleFactory;
import org.apache.beehive.netui.compiler.genmodel.GenStrutsApp;
import org.apache.beehive.netui.compiler.genmodel.ValidatorRuleFactory;
import org.apache.beehive.netui.compiler.model.FormBeanModel;
import org.apache.beehive.netui.compiler.model.NoWebInfDirectoryException;
import org.apache.beehive.netui.compiler.model.validation.ValidationModel;
import org.apache.beehive.netui.compiler.model.validation.ValidatorConstants;
import org.apache.beehive.netui.compiler.model.validation.ValidatorRule;
import org.apache.xmlbeans.XmlException;

public class GenValidationModel
extends ValidationModel
implements JpfLanguageConstants,
ValidatorConstants {
    private static final String STRUTS_VALIDATION_PREFIX = "jpf-validation";
    private static final ValidatorRuleFactory VALIDATOR_RULE_FACTORY = new DefaultValidatorRuleFactory();
    private GenStrutsApp _strutsApp;
    private File _mergeFile;

    public GenValidationModel(ClassDeclaration jclass, GenStrutsApp strutsApp) throws NoWebInfDirectoryException {
        MergedControllerAnnotation mca = strutsApp.getFlowControllerInfo().getMergedControllerAnnotation();
        this._strutsApp = strutsApp;
        this.addRulesFromBeans(jclass);
        this.addRulesFromActions(jclass);
        this.addRulesFromClass(jclass, mca);
        String mergeFileName = mca.getValidatorMerge();
        this._mergeFile = strutsApp.getMergeFile(mergeFileName);
    }

    private void addRulesFromBeans(ClassDeclaration jclass) {
        Collection<TypeDeclaration> innerTypes = CompilerUtils.getClassNestedTypes((TypeDeclaration)jclass);
        for (TypeDeclaration innerType : innerTypes) {
            if (!(innerType instanceof ClassDeclaration) || !CompilerUtils.hasModifier((Declaration)innerType, Modifier.PUBLIC) || !CompilerUtils.hasModifier((Declaration)innerType, Modifier.STATIC)) continue;
            this.addRulesFromBeanClass((ClassDeclaration)innerType);
        }
    }

    private void addRulesFromBeanClass(ClassDeclaration beanClass) {
        Collection<CompilerUtils.BeanPropertyDeclaration> properties = CompilerUtils.getBeanProperties(beanClass, true);
        for (CompilerUtils.BeanPropertyDeclaration property : properties) {
            Collection annotations;
            MethodDeclaration getter = property.getGetter();
            String propertyName = property.getPropertyName();
            String formName = this.getFormBeanName((TypeDeclaration)beanClass);
            if (getter == null || (annotations = getter.getAnnotationMirrors()) == null) continue;
            for (AnnotationMirror ann : annotations) {
                if (!CompilerUtils.isJpfAnnotation(ann, "ValidatableProperty")) continue;
                this.addRulesFromAnnotation(ann, formName, propertyName);
            }
        }
    }

    private void addRulesFromAnnotation(AnnotationMirror validationFieldAnn, String entityName, String propertyName) {
        List<AnnotationMirror> localeRulesAnnotations = CompilerUtils.getAnnotationArray(validationFieldAnn, "localeRules", false);
        String displayName = CompilerUtils.getString(validationFieldAnn, "displayName", true);
        String displayNameKey = CompilerUtils.getString(validationFieldAnn, "displayNameKey", true);
        ValidationModel.RuleInfo ruleInfo = new ValidationModel.RuleInfo(entityName, propertyName, displayName, displayNameKey);
        for (AnnotationMirror ann : localeRulesAnnotations) {
            this.addFieldRules(ann, ruleInfo, false);
        }
        this.addFieldRules(validationFieldAnn, ruleInfo, true);
    }

    private void addRulesFromActions(ClassDeclaration jclass) {
        Collection<MethodDeclaration> methods = CompilerUtils.getClassMethods((TypeDeclaration)jclass, "Action");
        for (MethodDeclaration method : methods) {
            AnnotationMirror actionAnnotation = CompilerUtils.getAnnotation((Declaration)method, "Action");
            assert (actionAnnotation != null);
            List<AnnotationMirror> validationFieldAnnotations = CompilerUtils.getAnnotationArray(actionAnnotation, "validatableProperties", false);
            String actionPath = "/" + method.getSimpleName();
            for (AnnotationMirror validationFieldAnnotation : validationFieldAnnotations) {
                String propertyName = CompilerUtils.getString(validationFieldAnnotation, "propertyName", true);
                assert (propertyName != null);
                assert (!propertyName.equals(""));
                this.addRulesFromAnnotation(validationFieldAnnotation, actionPath, propertyName);
            }
        }
    }

    private String getFormBeanName(TypeDeclaration beanType) {
        String actualType = CompilerUtils.getLoadableName(beanType);
        FormBeanModel formBean = this._strutsApp.getFormBeanByActualType(actualType);
        if (formBean == null) {
            String beanClassName = CompilerUtils.getFormClassName(beanType, this._strutsApp.getEnv());
            String formName = this._strutsApp.getFormNameForType(actualType);
            formBean = new FormBeanModel(formName, beanClassName, actualType, this._strutsApp);
            this._strutsApp.addFormBean(formBean);
        }
        return formBean.getName();
    }

    private void addRulesFromClass(ClassDeclaration jclass, MergedControllerAnnotation mca) {
        Collection<AnnotationMirror> validationBeanAnnotations = mca.getValidatableBeans();
        for (AnnotationMirror validationBeanAnnotation : validationBeanAnnotations) {
            DeclaredType beanType = CompilerUtils.getDeclaredType(validationBeanAnnotation, "type", true);
            assert (beanType != null);
            List<AnnotationMirror> validationFieldAnnotations = CompilerUtils.getAnnotationArray(validationBeanAnnotation, "validatableProperties", false);
            for (AnnotationMirror validationFieldAnnotation : validationFieldAnnotations) {
                String propName = CompilerUtils.getString(validationFieldAnnotation, "propertyName", true);
                assert (propName != null);
                assert (!propName.equals(""));
                String formName = this.getFormBeanName(CompilerUtils.getDeclaration(beanType));
                this.addRulesFromAnnotation(validationFieldAnnotation, formName, propName);
            }
        }
    }

    private void addFieldRules(AnnotationMirror rulesContainerAnnotation, ValidationModel.RuleInfo ruleInfo, boolean applyToAllLocales) {
        String language;
        Locale locale = null;
        if (!applyToAllLocales && (language = CompilerUtils.getString(rulesContainerAnnotation, "language", true)) != null) {
            String country = CompilerUtils.getString(rulesContainerAnnotation, "country", true);
            String variant = CompilerUtils.getString(rulesContainerAnnotation, "variant", true);
            language = language.trim();
            if (country != null) {
                country = country.trim();
            }
            if (variant != null) {
                variant = variant.trim();
            }
            locale = country != null && variant != null ? new Locale(language, country, variant) : (country != null ? new Locale(language, country) : new Locale(language));
        }
        Map valuesPresent = rulesContainerAnnotation.getElementValues();
        for (Map.Entry entry : valuesPresent.entrySet()) {
            Object val = ((AnnotationValue)entry.getValue()).getValue();
            if (!(val instanceof AnnotationMirror)) continue;
            AnnotationMirror annotationVal = (AnnotationMirror)val;
            ValidatorRule rule = this.getFieldRule(ruleInfo.getEntityName(), ruleInfo.getFieldName(), annotationVal);
            if (rule == null) continue;
            if (applyToAllLocales) {
                this.addFieldRuleForAllLocales(ruleInfo, rule);
                continue;
            }
            this.addFieldRule(ruleInfo, rule, locale);
        }
        this.setEmpty(false);
    }

    private ValidatorRule getFieldRule(String entityName, String propertyName, AnnotationMirror ruleAnnotation) {
        ValidatorRule rule = VALIDATOR_RULE_FACTORY.getFieldRule(entityName, propertyName, ruleAnnotation);
        if (rule != null) {
            rule.setMessage(CompilerUtils.getString(ruleAnnotation, "message", true));
            rule.setMessageKey(CompilerUtils.getString(ruleAnnotation, "messageKey", true));
            if (rule.getMessage() != null) assert (rule.getMessageKey() == null);
            String arg0 = CompilerUtils.getString(ruleAnnotation, "arg0", true);
            if (arg0 != null) {
                rule.setArg0(arg0, false);
            } else {
                String arg0Key = CompilerUtils.getString(ruleAnnotation, "arg0Key", true);
                if (arg0Key != null) {
                    rule.setArg0(arg0Key, true);
                }
            }
            String arg1 = CompilerUtils.getString(ruleAnnotation, "arg1", true);
            if (arg1 != null) {
                rule.setArg1(arg1, false);
            } else {
                String arg1Key = CompilerUtils.getString(ruleAnnotation, "arg1Key", true);
                if (arg1Key != null) {
                    rule.setArg1(arg1Key, true);
                }
            }
            String arg2 = CompilerUtils.getString(ruleAnnotation, "arg2", true);
            if (arg2 != null) {
                rule.setArg2(arg2, false);
            } else {
                String arg2Key = CompilerUtils.getString(ruleAnnotation, "arg2Key", true);
                if (arg2Key != null) {
                    rule.setArg2(arg2Key, true);
                }
            }
            String arg3 = CompilerUtils.getString(ruleAnnotation, "arg3", true);
            if (arg3 != null) {
                rule.setArg3(arg3, false);
            } else {
                String arg3Key = CompilerUtils.getString(ruleAnnotation, "arg3Key", true);
                if (arg3Key != null) {
                    rule.setArg3(arg3Key, true);
                }
            }
        }
        return rule;
    }

    protected String getHeaderComment(File mergeFile) {
        return this._strutsApp.getHeaderComment(mergeFile);
    }

    public void writeToFile() throws FileNotFoundException, XmlException, IOException {
        String outputFile = this._strutsApp.getWebappRoot() + this._strutsApp.getOutputFileURI(STRUTS_VALIDATION_PREFIX);
        PrintStream printStream = new PrintStream(new FileOutputStream(outputFile));
        this.writeXml(printStream, this._mergeFile);
        printStream.close();
    }

    public String getOutputFileURI() {
        return this._strutsApp.getOutputFileURI(STRUTS_VALIDATION_PREFIX);
    }
}

