/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.compiler.genmodel;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.Modifier;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.TypeMirror;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.beehive.netui.compiler.CompilerUtils;
import org.apache.beehive.netui.compiler.FlowControllerInfo;
import org.apache.beehive.netui.compiler.MergedControllerAnnotation;
import org.apache.beehive.netui.compiler.genmodel.GenActionModel;
import org.apache.beehive.netui.compiler.genmodel.GenExceptionModel;
import org.apache.beehive.netui.compiler.genmodel.GenForwardModel;
import org.apache.beehive.netui.compiler.genmodel.GenMessageResourcesModel;
import org.apache.beehive.netui.compiler.genmodel.GenSimpleActionModel;
import org.apache.beehive.netui.compiler.model.ActionModel;
import org.apache.beehive.netui.compiler.model.ExceptionContainer;
import org.apache.beehive.netui.compiler.model.FormBeanModel;
import org.apache.beehive.netui.compiler.model.ForwardContainer;
import org.apache.beehive.netui.compiler.model.MessageResourcesModel;
import org.apache.beehive.netui.compiler.model.NoWebInfDirectoryException;
import org.apache.beehive.netui.compiler.model.StrutsApp;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenStrutsApp
extends StrutsApp {
    private ClassDeclaration _jclass;
    private String _containingPackage;
    private File _strutsConfigFile;
    private File _sourceFile;
    private File _webappRoot;
    private AnnotationProcessorEnvironment _env;
    private FlowControllerInfo _fcInfo;

    protected void recalculateStrutsConfigFile() throws XmlException, IOException {
        this._strutsConfigFile = this.calculateStrutsConfigFile();
    }

    FlowControllerInfo getFlowControllerInfo() {
        return this._fcInfo;
    }

    public GenStrutsApp(File sourceFile, ClassDeclaration jclass, AnnotationProcessorEnvironment env, FlowControllerInfo fcInfo, boolean checkOnly) throws NoWebInfDirectoryException, XmlException, IOException {
        super(jclass.getQualifiedName());
        this._jclass = jclass;
        this._containingPackage = jclass.getPackage().getQualifiedName();
        this._sourceFile = sourceFile;
        this._webappRoot = GenStrutsApp.getWebappRootFromJpf(sourceFile).getAbsoluteFile();
        this._env = env;
        assert (fcInfo != null);
        this._fcInfo = fcInfo;
        this.recalculateStrutsConfigFile();
        if (checkOnly) {
            return;
        }
        if (this._jclass != null) {
            MergedControllerAnnotation mca = fcInfo.getMergedControllerAnnotation();
            this.setNestedPageFlow(mca.isNested());
            this.setLongLivedPageFlow(mca.isLongLived());
            this.addMessageResources(mca.getMessageResources());
            this.addSimpleActions(mca.getSimpleActions());
            this.setMultipartHandler(mca.getMultipartHandler());
            GenForwardModel.addForwards(mca.getForwards(), (ForwardContainer)this, this._jclass, this, null);
            GenExceptionModel.addCatches(mca.getCatches(), (ExceptionContainer)this, this._jclass, this, (ForwardContainer)this);
            this.addTilesDefinitionsConfigs(mca.getTilesDefinitionsConfigs());
            this.addActionMethods();
            this.addFormBeans(this._jclass);
        }
        if (fcInfo != null) {
            this.setSharedFlows(fcInfo.getSharedFlowTypeNames());
            this.setReturnToActionDisabled(!fcInfo.isNavigateToActionEnabled());
            this.setReturnToPageDisabled(!fcInfo.isNavigateToPageEnabled());
        }
    }

    private void addFormBeans(ClassDeclaration jclass) {
        Collection<TypeDeclaration> innerTypes = CompilerUtils.getClassNestedTypes((TypeDeclaration)jclass);
        for (TypeDeclaration innerType : innerTypes) {
            if (!(innerType instanceof ClassDeclaration)) continue;
            ClassDeclaration innerClass = (ClassDeclaration)innerType;
            if (!CompilerUtils.hasModifier((Declaration)innerType, Modifier.PUBLIC) || !CompilerUtils.isAssignableFrom("org.apache.struts.action.ActionForm", (TypeDeclaration)innerClass, this._env)) continue;
            this.addFormBean((TypeDeclaration)innerClass, null);
        }
    }

    String addFormBean(TypeDeclaration formType, ActionModel usedByAction) {
        String formBeanName;
        String formClass = CompilerUtils.getFormClassName(formType, this._env);
        String actualType = CompilerUtils.getLoadableName(formType);
        FormBeanModel existingBean = this.getFormBeanByActualType(actualType);
        if (existingBean != null) {
            formBeanName = existingBean.getName();
        } else {
            formBeanName = this.getFormNameForType(actualType);
            this.addFormBean(new FormBeanModel(formBeanName, formClass, actualType, this));
            this.getMessageResourcesFromForm(formType, usedByAction);
        }
        return formBeanName;
    }

    private void addMessageResources(Collection<AnnotationMirror> messageResources) {
        if (messageResources != null) {
            for (AnnotationMirror ann : messageResources) {
                this.addMessageResources(new GenMessageResourcesModel(this, ann));
            }
        }
    }

    private void addValidationMessages(Collection<AnnotationMirror> validationMessages) {
        String packagePrefix;
        if (validationMessages != null && (packagePrefix = this._jclass.getPackage().getQualifiedName()) != null) {
            String string = packagePrefix + '.';
        }
    }

    private void addSimpleActions(Collection<AnnotationMirror> simpleActionAnnotations) {
        if (simpleActionAnnotations != null) {
            for (AnnotationMirror ann : simpleActionAnnotations) {
                this.addActionMapping(new GenSimpleActionModel(ann, this, this._jclass));
            }
        }
    }

    private void setMultipartHandler(String mpHandler) {
        if (mpHandler != null) {
            if (mpHandler.equals("memory")) {
                this.setMultipartHandlerClassName("org.apache.struts.upload.CommonsMultipartRequestHandler");
            } else if (mpHandler.equals("disk")) {
                this.setMultipartHandlerClassName("org.apache.struts.upload.DiskMultipartRequestHandler");
            } else {
                assert (mpHandler.equals("disabled"));
                this.setMultipartHandlerClassName("none");
            }
        }
    }

    private void addTilesDefinitionsConfigs(List<String> tilesDefinitionsConfigs) {
        if (tilesDefinitionsConfigs == null || tilesDefinitionsConfigs.isEmpty()) {
            return;
        }
        ArrayList<String> paths = new ArrayList<String>();
        for (String definitionsConfig : tilesDefinitionsConfigs) {
            if (definitionsConfig != null && definitionsConfig.startsWith("/")) {
                paths.add(definitionsConfig);
                continue;
            }
            String prefix = this._sourceFile.getParentFile().toString().substring(this._webappRoot.toString().length());
            paths.add(prefix + '/' + definitionsConfig);
        }
        this.setTilesDefinitionsConfigs(paths);
    }

    private void addActionMethods() {
        Collection<MethodDeclaration> actionMethods = CompilerUtils.getClassMethods((TypeDeclaration)this._jclass, "Action");
        for (MethodDeclaration actionMethod : actionMethods) {
            ParameterDeclaration param1;
            TypeMirror paramType;
            GenActionModel actionModel = new GenActionModel((Declaration)actionMethod, this, this._jclass);
            this.addActionMapping(actionModel);
            Collection params = actionMethod.getParameters();
            if (params.size() <= 0 || !((paramType = (param1 = (ParameterDeclaration)params.iterator().next()).getType()) instanceof DeclaredType)) continue;
            this.getMessageResourcesFromForm(CompilerUtils.getDeclaration((DeclaredType)paramType), actionModel);
        }
    }

    private void getMessageResourcesFromForm(TypeDeclaration formClassType, ActionModel actionModel) {
        String defaultMessageResources;
        AnnotationMirror ann = CompilerUtils.getAnnotation((Declaration)formClassType, "FormBean");
        if (ann != null && (defaultMessageResources = CompilerUtils.getString(ann, "messageBundle", true)) != null) {
            for (MessageResourcesModel i : this.getMessageResourcesList()) {
                if (!i.getParameter().equals(defaultMessageResources)) continue;
                return;
            }
            MessageResourcesModel mrm = new MessageResourcesModel(this);
            String key = "formMessages:" + CompilerUtils.getLoadableName(formClassType);
            mrm.setKey(key);
            mrm.setParameter(defaultMessageResources);
            mrm.setReturnNull(true);
            this.addMessageResources(mrm);
            if (actionModel != null) {
                actionModel.setFormBeanMessageResourcesKey(key);
            }
        }
    }

    protected String getMergeFileName() {
        return CompilerUtils.getStringValue((Declaration)this._jclass, "Controller", "strutsMerge", true);
    }

    public void writeToFile() throws NoWebInfDirectoryException, FileNotFoundException, IOException, XmlException {
        this.writeToFile(this.getMergeFile(this.getMergeFileName()));
    }

    public boolean isStale() throws NoWebInfDirectoryException {
        return this.isStale(this.getMergeFile(this.getMergeFileName()));
    }

    protected boolean isModuleDeclaredInWebXml() {
        String webappRelativeSourceFile = this.getWebappRelativeSourceFile();
        return webappRelativeSourceFile.lastIndexOf(47) == 0;
    }

    String getOutputFileURI(String filePrefix) {
        return GenStrutsApp.getOutputFileURI(filePrefix, this._containingPackage, false);
    }

    String getStrutsConfigURI() {
        return GenStrutsApp.getStrutsConfigURI(this._containingPackage, false);
    }

    protected String getContainingPackage() {
        return this._containingPackage;
    }

    private File calculateStrutsConfigFile() throws XmlException, IOException {
        String alternateLocation;
        File strutsConfigFile = new File(this._webappRoot.getPath() + this.getStrutsConfigURI());
        if (this.isModuleDeclaredInWebXml() && (alternateLocation = GenStrutsApp.getAlternateLocation(strutsConfigFile, this._webappRoot)) != null) {
            return new File(this._webappRoot.getPath() + alternateLocation);
        }
        return strutsConfigFile;
    }

    public boolean isStale(File mergeFile) throws NoWebInfDirectoryException {
        if (this.isModuleDeclaredInWebXml()) {
            return true;
        }
        if (!this._strutsConfigFile.exists()) {
            return true;
        }
        long lastWrite = this._strutsConfigFile.lastModified();
        if (mergeFile != null && mergeFile.exists() && mergeFile.lastModified() > lastWrite) {
            return true;
        }
        return this._sourceFile.lastModified() > lastWrite;
    }

    public boolean canWrite() {
        if (!this._strutsConfigFile.canWrite()) {
            return false;
        }
        try {
            new FileOutputStream(this._strutsConfigFile, true).close();
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public void writeToFile(File strutsMergeFile) throws FileNotFoundException, IOException, XmlException, NoWebInfDirectoryException {
        this._strutsConfigFile.getParentFile().mkdirs();
        PrintStream out = new PrintStream(new FileOutputStream(this._strutsConfigFile));
        this.writeXml(out, strutsMergeFile, this._webappRoot);
        out.close();
    }

    public File getStrutsConfigFile() {
        return this._strutsConfigFile;
    }

    private static boolean isAtElement(XmlCursor curs, String localName) {
        return curs.getName().getLocalPart().equals(localName);
    }

    private static String getAlternateLocation(File strutsConfigFile, File webappRoot) throws XmlException, IOException {
        File webXmlFile = new File(webappRoot.getPath() + '/' + "WEB-INF" + "/web.xml");
        if (!webXmlFile.canRead()) {
            return null;
        }
        String strutsConfigFileName = strutsConfigFile.getName();
        XmlObject webXmlDoc = XmlObject.Factory.parse((File)webXmlFile);
        XmlCursor curs = webXmlDoc.newCursor();
        if (curs.toFirstChild() && curs.toFirstChild()) {
            do {
                if (!GenStrutsApp.isAtElement(curs, "servlet")) continue;
                XmlCursor i = curs.newCursor();
                i.toFirstChild();
                do {
                    if (!GenStrutsApp.isAtElement(i, "servlet-name") || !i.getTextValue().equals("action")) continue;
                    XmlCursor j = curs.newCursor();
                    j.toFirstChild();
                    do {
                        if (!GenStrutsApp.isAtElement(j, "init-param")) continue;
                        XmlCursor k = j.newCursor();
                        k.toFirstChild();
                        boolean isConfig = false;
                        String alternateLocation = null;
                        do {
                            if (GenStrutsApp.isAtElement(k, "param-name") && k.getTextValue().startsWith("config")) {
                                isConfig = true;
                                continue;
                            }
                            if (!GenStrutsApp.isAtElement(k, "param-value")) continue;
                            alternateLocation = GenStrutsApp.parseAlternateLocation(k.getTextValue(), strutsConfigFileName);
                        } while (k.toNextSibling());
                        if (!isConfig || alternateLocation == null) continue;
                        return alternateLocation;
                    } while (j.toNextSibling());
                    return null;
                } while (i.toNextSibling());
            } while (curs.toNextSibling());
        }
        return null;
    }

    private static String parseAlternateLocation(String paramValue, String strutsConfigFileName) {
        if (paramValue.indexOf(strutsConfigFileName) != -1) {
            if (paramValue.indexOf(",") != -1) {
                String[] files = paramValue.split(",");
                for (int k = 0; k < files.length; ++k) {
                    if (files[k].indexOf(strutsConfigFileName) == -1) continue;
                    return files[k].trim();
                }
            } else {
                return paramValue;
            }
        }
        return null;
    }

    public File getMergeFile(String mergeFileName) throws NoWebInfDirectoryException {
        if (mergeFileName != null) {
            if (mergeFileName.startsWith("/")) {
                return new File(this._webappRoot.getPath() + mergeFileName);
            }
            return new File(this._sourceFile.getParentFile() + File.separator + mergeFileName);
        }
        return null;
    }

    public String getWebappRelativeSourceFile() {
        return this.getWebappRelativePath(this._sourceFile);
    }

    public File getSourceFile() {
        return this._sourceFile;
    }

    @Override
    protected String getHeaderComment(File mergeFile) {
        StringBuffer comment = new StringBuffer(" Generated from ");
        comment.append(this.getWebappRelativeSourceFile());
        if (mergeFile != null) {
            comment.append(" and ").append(this.getWebappRelativePath(mergeFile));
        }
        comment.append(" on ").append(new Date().toString()).append(' ');
        return comment.toString();
    }

    private String getWebappRelativePath(File file) {
        String webappRoot = this._webappRoot.toString();
        if ((file = file.getAbsoluteFile()).toString().startsWith(webappRoot)) {
            return file.toString().substring(webappRoot.length()).replace('\\', '/');
        }
        return file.toString();
    }

    AnnotationProcessorEnvironment getEnv() {
        return this._env;
    }

    public File getWebappRoot() {
        return this._webappRoot;
    }
}

