/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.compiler.genmodel;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import java.util.List;
import org.apache.beehive.netui.compiler.CompilerUtils;
import org.apache.beehive.netui.compiler.JpfLanguageConstants;
import org.apache.beehive.netui.compiler.genmodel.GenActionModel;
import org.apache.beehive.netui.compiler.genmodel.GenForwardModel;
import org.apache.beehive.netui.compiler.genmodel.GenStrutsApp;

public class GenSimpleActionModel
extends GenActionModel
implements JpfLanguageConstants {
    public GenSimpleActionModel(AnnotationMirror annotation, GenStrutsApp parentApp, ClassDeclaration jclass) {
        super(CompilerUtils.getString(annotation, "name", true), annotation, parentApp, jclass);
        this.setSimpleAction(true);
        this.addForwards(annotation, parentApp, jclass);
        String formMember = this.getFormMember();
        if (formMember != null) {
            FieldDeclaration field = CompilerUtils.findField((TypeDeclaration)jclass, formMember);
            assert (field != null);
            this.setFormBeanName(this.addFormBean(field.getType(), parentApp));
        } else {
            this.setReadonly(true);
        }
    }

    protected String getFormBean(Declaration sourceElement, GenStrutsApp parentApp) {
        return null;
    }

    protected void getForwards(AnnotationMirror annotation, ClassDeclaration jclass, GenStrutsApp parentApp) {
    }

    private void addForwards(AnnotationMirror annotation, GenStrutsApp parentApp, ClassDeclaration jclass) {
        SimpleActionForward fwd;
        String forwardRef = CompilerUtils.getString(annotation, "forwardRef", true);
        if (forwardRef == null && ((fwd = new SimpleActionForward(forwardRef = "_defaultForward", parentApp, annotation, jclass)).getPath() != null || fwd.isReturnToAction() || fwd.isReturnToPage() || fwd.isNestedReturn())) {
            this.addForward(fwd);
        }
        this.setDefaultForwardName(forwardRef);
        List<AnnotationMirror> conditionalFwdAnnotations = CompilerUtils.getAnnotationArray(annotation, "conditionalForwards", true);
        if (conditionalFwdAnnotations != null) {
            int anonCount = 0;
            for (AnnotationMirror conditionalFwdAnnotation : conditionalFwdAnnotations) {
                SimpleActionForward conditionalFwd = new SimpleActionForward(parentApp, conditionalFwdAnnotation, jclass);
                String expression = CompilerUtils.getString(conditionalFwdAnnotation, "condition", true);
                assert (expression != null);
                if (conditionalFwd.getName() == null) {
                    conditionalFwd.setName("_anon" + ++anonCount);
                }
                this.addForward(conditionalFwd);
                this.addConditionalForward(expression, conditionalFwd.getName());
            }
        }
    }

    private static class SimpleActionForward
    extends GenForwardModel {
        public SimpleActionForward(GenStrutsApp parent, AnnotationMirror annotation, ClassDeclaration jclass) {
            super(parent, annotation, jclass, null);
        }

        public SimpleActionForward(String name, GenStrutsApp parent, AnnotationMirror annotation, ClassDeclaration jclass) {
            super(parent, annotation, jclass, null);
            this.setName(name);
        }

        protected void addActionOutputs(AnnotationMirror annotation, ClassDeclaration jclass) {
        }
    }
}

