/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.compiler.genmodel;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.DeclaredType;
import java.util.Collection;
import java.util.List;
import org.apache.beehive.netui.compiler.CompilerUtils;
import org.apache.beehive.netui.compiler.JpfLanguageConstants;
import org.apache.beehive.netui.compiler.genmodel.GenActionOutputModel;
import org.apache.beehive.netui.compiler.genmodel.GenStrutsApp;
import org.apache.beehive.netui.compiler.model.ForwardContainer;
import org.apache.beehive.netui.compiler.model.ForwardModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenForwardModel
extends ForwardModel
implements JpfLanguageConstants {
    public GenForwardModel(GenStrutsApp parent, AnnotationMirror annotation, ClassDeclaration jclass, String commentSuffix) {
        super(parent);
        this.setName(CompilerUtils.getString(annotation, "name", true));
        this.setRedirect(CompilerUtils.getBoolean(annotation, "redirect", false));
        if (CompilerUtils.getBoolean(annotation, "externalRedirect", false).booleanValue()) {
            this.setExternalRedirect(true);
        }
        DeclaredType returnFormType = CompilerUtils.getDeclaredType(annotation, "outputFormBeanType", true);
        String returnFormMember = CompilerUtils.getString(annotation, "outputFormBean", true);
        if (returnFormMember != null) {
            FieldDeclaration field = CompilerUtils.getClassField((TypeDeclaration)jclass, returnFormMember, null);
            assert (returnFormType == null);
            assert (field != null);
            assert (field.getType() instanceof DeclaredType) : field.getType().getClass().getName();
            returnFormType = (DeclaredType)field.getType();
        }
        this.setReturnFormMember(returnFormMember);
        this.setReturnFormType(returnFormType != null ? CompilerUtils.getLoadableName(returnFormType) : null);
        String returnAction = CompilerUtils.getString(annotation, "returnAction", true);
        String navigateTo = CompilerUtils.getEnumFieldName(annotation, "navigateTo", true);
        String tilesDefinition = CompilerUtils.getString(annotation, "tilesDefinition", true);
        String path = CompilerUtils.getString(annotation, "path", true);
        if (returnAction != null) {
            assert (navigateTo == null);
            assert (tilesDefinition == null);
            assert (path == null);
            this.setIsNestedReturn(true);
            this.setPath(returnAction);
        } else if (navigateTo != null) {
            assert (tilesDefinition == null);
            assert (path == null);
            if (navigateTo.equals("page") || navigateTo.equals("currentPage") || navigateTo.equals("previousPage")) {
                this.setReturnToPage(true);
            } else if (navigateTo.equals("previousAction")) {
                this.setReturnToAction(true);
                boolean restore = CompilerUtils.getBoolean(annotation, "restoreQueryString", false);
                this.setRestoreQueryString(restore);
            } else assert (false) : "unknown value for navigateTo: \"" + navigateTo + "\"";
            this.setPath(navigateTo);
        } else if (tilesDefinition != null) {
            assert (path == null);
            this.setPath(tilesDefinition);
        } else {
            assert (path != null);
            boolean contextRelative = true;
            if (!path.startsWith("/")) {
                contextRelative = false;
                if (!CompilerUtils.isAbsoluteURL(path)) {
                    path = "/" + path;
                }
            }
            this.setPath(path);
            this.setContextRelative(contextRelative);
        }
        this.addActionOutputs(annotation, jclass);
        if (commentSuffix != null) {
            this.setComment("forward \"" + this.getName() + "\"" + commentSuffix);
        }
    }

    static void addForwards(AnnotationMirror annotation, ForwardContainer container, ClassDeclaration jclass, GenStrutsApp strutsApp, String commentSuffix) {
        List<AnnotationMirror> forwards = CompilerUtils.getAnnotationArray(annotation, "forwards", true);
        GenForwardModel.addForwards(forwards, container, jclass, strutsApp, commentSuffix);
    }

    static void addForwards(Collection<AnnotationMirror> forwards, ForwardContainer container, ClassDeclaration jclass, GenStrutsApp strutsApp, String commentSuffix) {
        if (forwards != null) {
            for (AnnotationMirror ann : forwards) {
                container.addForward(new GenForwardModel(strutsApp, ann, jclass, commentSuffix));
            }
        }
    }

    protected void addActionOutputs(AnnotationMirror annotation, ClassDeclaration jclass) {
        List<AnnotationMirror> actionOutputs = CompilerUtils.getAnnotationArray(annotation, "actionOutputs", true);
        if (actionOutputs != null) {
            for (AnnotationMirror ann : actionOutputs) {
                this.addActionOutput(new GenActionOutputModel(ann, jclass));
            }
        }
    }
}

