/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.compiler.genmodel;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import java.util.Collection;
import java.util.List;
import org.apache.beehive.netui.compiler.CompilerUtils;
import org.apache.beehive.netui.compiler.JpfLanguageConstants;
import org.apache.beehive.netui.compiler.genmodel.GenForwardModel;
import org.apache.beehive.netui.compiler.genmodel.GenStrutsApp;
import org.apache.beehive.netui.compiler.model.ExceptionContainer;
import org.apache.beehive.netui.compiler.model.ExceptionModel;
import org.apache.beehive.netui.compiler.model.ForwardContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenExceptionModel
extends ExceptionModel
implements JpfLanguageConstants {
    public GenExceptionModel(GenStrutsApp parentApp, AnnotationMirror annotation, ClassDeclaration jclass, ForwardContainer forwardContainer) {
        super(parentApp);
        this.setType(CompilerUtils.getLoadableName(CompilerUtils.getDeclaredType(annotation, "type", true)));
        this.setPath(CompilerUtils.getString(annotation, "path", true));
        this.setMessage(CompilerUtils.getString(annotation, "message", true));
        this.setMessageKey(CompilerUtils.getString(annotation, "messageKey", true));
        String methodName = CompilerUtils.getString(annotation, "method", true);
        this.setHandlerMethod(methodName);
        if (methodName != null) {
            MethodDeclaration method = CompilerUtils.getClassMethod((TypeDeclaration)jclass, methodName, "ExceptionHandler");
            AnnotationMirror exHandlerAnnotation = CompilerUtils.getAnnotation((Declaration)method, "ExceptionHandler");
            GenForwardModel.addForwards(exHandlerAnnotation, forwardContainer, jclass, parentApp, " from exception-handler " + methodName);
            Boolean readOnly = CompilerUtils.getBoolean(exHandlerAnnotation, "readOnly", true);
            if (readOnly == null) {
                readOnly = parentApp.getFlowControllerInfo().getMergedControllerAnnotation().isReadOnly();
            }
            this.setReadonly(readOnly);
        }
    }

    static void addCatches(AnnotationMirror annotation, ExceptionContainer container, ClassDeclaration jclass, GenStrutsApp strutsApp, ForwardContainer forwardContainer) {
        List<AnnotationMirror> catches = CompilerUtils.getAnnotationArray(annotation, "catches", true);
        GenExceptionModel.addCatches(catches, container, jclass, strutsApp, forwardContainer);
    }

    static void addCatches(Collection<AnnotationMirror> catches, ExceptionContainer container, ClassDeclaration jclass, GenStrutsApp strutsApp, ForwardContainer forwardContainer) {
        if (catches != null) {
            for (AnnotationMirror i : catches) {
                container.addException(new GenExceptionModel(strutsApp, i, jclass, forwardContainer));
            }
        }
    }
}

