/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.compiler.genmodel;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.TypeMirror;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.beehive.netui.compiler.CompilerUtils;
import org.apache.beehive.netui.compiler.JpfLanguageConstants;
import org.apache.beehive.netui.compiler.genmodel.GenExceptionModel;
import org.apache.beehive.netui.compiler.genmodel.GenForwardModel;
import org.apache.beehive.netui.compiler.genmodel.GenStrutsApp;
import org.apache.beehive.netui.compiler.model.ActionModel;
import org.apache.beehive.netui.compiler.model.ExceptionContainer;
import org.apache.beehive.netui.compiler.model.ForwardContainer;

public class GenActionModel
extends ActionModel
implements JpfLanguageConstants {
    public GenActionModel(Declaration sourceElement, GenStrutsApp parentApp, ClassDeclaration jclass) {
        super(parentApp);
        this.setFormBeanName(this.getFormBean(sourceElement, parentApp));
        this.init(this.getActionName(sourceElement), this.getActionAnnotation(sourceElement), parentApp, jclass);
    }

    protected GenActionModel(String actionName, AnnotationMirror ann, GenStrutsApp parentApp, ClassDeclaration jclass) {
        super(parentApp);
        this.init(actionName, ann, parentApp, jclass);
    }

    private void init(String actionName, AnnotationMirror annotation, GenStrutsApp parentApp, ClassDeclaration jclass) {
        Boolean explicitDoValidation;
        this.setPath('/' + actionName);
        Boolean loginRequired = CompilerUtils.getBoolean(annotation, "loginRequired", true);
        if (loginRequired == null) {
            loginRequired = parentApp.getFlowControllerInfo().getMergedControllerAnnotation().isLoginRequired();
        }
        this.setLoginRequired(loginRequired);
        Boolean preventDoubleSubmit = CompilerUtils.getBoolean(annotation, "preventDoubleSubmit", false);
        this.setPreventDoubleSubmit(preventDoubleSubmit);
        Boolean readOnly = CompilerUtils.getBoolean(annotation, "readOnly", true);
        if (readOnly == null) {
            readOnly = parentApp.getFlowControllerInfo().getMergedControllerAnnotation().isReadOnly();
        }
        this.setReadonly(readOnly);
        this.setRolesAllowed(annotation, jclass, parentApp);
        this.setType("org.apache.beehive.netui.pageflow.internal.FlowControllerAction");
        this.setParameter(jclass.getQualifiedName());
        this.setFormMember(CompilerUtils.getString(annotation, "useFormBean", true));
        this.getForwards(annotation, jclass, parentApp);
        AnnotationMirror validateErrFwd = CompilerUtils.getAnnotation(annotation, "validationErrorForward", true);
        boolean doValidation = false;
        if (validateErrFwd != null) {
            GenForwardModel fwd = new GenForwardModel(parentApp, validateErrFwd, jclass, " (validationErrorForward)");
            this.addForward(fwd);
            this.setInput(fwd.getName());
            doValidation = true;
        }
        this.setValidate((explicitDoValidation = CompilerUtils.getBoolean(annotation, "doValidation", true)) != null ? explicitDoValidation : doValidation);
        GenExceptionModel.addCatches(annotation, (ExceptionContainer)this, jclass, parentApp, (ForwardContainer)this);
    }

    private void setRolesAllowed(AnnotationMirror annotation, ClassDeclaration jclass, GenStrutsApp parentApp) {
        List<String> rolesAllowed = CompilerUtils.getStringArray(annotation, "rolesAllowed", true);
        List<String> classLevelRA = parentApp.getFlowControllerInfo().getMergedControllerAnnotation().getRolesAllowed();
        Iterator<String> it = null;
        if (rolesAllowed != null && classLevelRA != null) {
            HashSet<String> merged = new HashSet<String>();
            for (String role : rolesAllowed) {
                merged.add(role);
            }
            for (String classLevelRole : classLevelRA) {
                merged.add(classLevelRole);
            }
            it = merged.iterator();
        } else if (rolesAllowed != null) {
            it = rolesAllowed.iterator();
        } else if (classLevelRA != null) {
            it = classLevelRA.iterator();
        }
        if (it != null && it.hasNext()) {
            StringBuffer rolesAllowedStr = new StringBuffer(it.next());
            while (it.hasNext()) {
                rolesAllowedStr.append(',').append(it.next().trim());
            }
            this.setRoles(rolesAllowedStr.toString());
        }
    }

    protected String getActionName(Declaration sourceElement) {
        return sourceElement.getSimpleName();
    }

    protected String getFormBean(Declaration sourceElement, GenStrutsApp parentApp) {
        assert (sourceElement instanceof MethodDeclaration) : sourceElement.getClass().getName();
        Collection params = ((MethodDeclaration)sourceElement).getParameters();
        String formBeanName = null;
        if (params.size() > 0) {
            assert (params.size() == 1) : params.size();
            formBeanName = this.addFormBean(((ParameterDeclaration)params.iterator().next()).getType(), parentApp);
        }
        return formBeanName;
    }

    protected String addFormBean(TypeMirror paramType, GenStrutsApp parentApp) {
        assert (paramType instanceof DeclaredType) : paramType.getClass().getName();
        TypeDeclaration decl = CompilerUtils.getDeclaration((DeclaredType)paramType);
        String formBeanName = parentApp.addFormBean(decl, this);
        if (!CompilerUtils.isAssignableFrom("org.apache.struts.action.ActionForm", decl, parentApp.getEnv())) {
            this.setFormClass(CompilerUtils.getLoadableName(decl));
        }
        return formBeanName;
    }

    protected AnnotationMirror getActionAnnotation(Declaration sourceElement) {
        assert (sourceElement instanceof MethodDeclaration) : sourceElement.getClass().getName();
        return CompilerUtils.getAnnotation(sourceElement, "Action");
    }

    protected void getForwards(AnnotationMirror annotation, ClassDeclaration jclass, GenStrutsApp parentApp) {
        GenForwardModel.addForwards(annotation, (ForwardContainer)this, jclass, parentApp, null);
    }
}

