/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.compiler.genmodel;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.type.PrimitiveType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.beehive.netui.compiler.CompilerUtils;
import org.apache.beehive.netui.compiler.genmodel.ValidatorRuleFactory;
import org.apache.beehive.netui.compiler.model.validation.ValidatorConstants;
import org.apache.beehive.netui.compiler.model.validation.ValidatorRule;
import org.apache.beehive.netui.compiler.model.validation.ValidatorRuleRange;

public class DefaultValidatorRuleFactory
implements ValidatorRuleFactory,
ValidatorConstants {
    private static final Map<PrimitiveType.Kind, String> VALIDATE_TYPE_RULES = new HashMap<PrimitiveType.Kind, String>();

    public ValidatorRule getFieldRule(String entityName, String propertyName, AnnotationMirror ruleAnnotation) {
        ValidatorRule rule = null;
        String annName = CompilerUtils.getSimpleName(ruleAnnotation);
        if (annName.equals("ValidateRequired")) {
            rule = new ValidatorRule("required");
        } else if (annName.equals("ValidateCreditCard")) {
            rule = new ValidatorRule("creditCard");
        } else if (annName.equals("ValidateEmail")) {
            rule = new ValidatorRule("email");
        } else if (annName.equals("ValidateRange")) {
            Double minFloat = CompilerUtils.getDouble(ruleAnnotation, "minFloat", true);
            if (minFloat != null) {
                Double maxFloat = CompilerUtils.getDouble(ruleAnnotation, "maxFloat", true);
                assert (maxFloat != null);
                rule = new ValidatorRuleRange(minFloat, maxFloat);
            } else {
                Integer minInt = CompilerUtils.getInteger(ruleAnnotation, "minInt", true);
                Integer maxInt = CompilerUtils.getInteger(ruleAnnotation, "maxInt", true);
                assert (minInt != null);
                assert (maxInt != null);
                rule = new ValidatorRuleRange(minInt, maxInt);
            }
        } else if (annName.equals("ValidateMinLength")) {
            Integer nChars = CompilerUtils.getInteger(ruleAnnotation, "chars", true);
            assert (nChars != null);
            rule = new ValidatorRule("minlength");
            rule.setVar("minlength", nChars.toString());
        } else if (annName.equals("ValidateMaxLength")) {
            Integer nChars = CompilerUtils.getInteger(ruleAnnotation, "chars", true);
            assert (nChars != null);
            rule = new ValidatorRule("maxlength");
            rule.setVar("maxlength", nChars.toString());
        } else if (annName.equals("ValidateMask")) {
            String regex = CompilerUtils.getString(ruleAnnotation, "regex", true);
            assert (regex != null);
            rule = new ValidatorRule("mask");
            rule.setVar("mask", regex);
        } else if (annName.equals("ValidateDate")) {
            boolean strict = CompilerUtils.getBoolean(ruleAnnotation, "strict", false);
            String pattern = CompilerUtils.getString(ruleAnnotation, "pattern", true);
            assert (pattern != null);
            rule = new ValidatorRule("date");
            rule.setVar(strict ? "datePatternStrict" : "datePattern", pattern);
        } else if (annName.equals("ValidateType")) {
            AnnotationValue annotationValue = CompilerUtils.getAnnotationValue(ruleAnnotation, "type", true);
            assert (annotationValue != null);
            Object value = annotationValue.getValue();
            assert (value instanceof PrimitiveType) : value.getClass().getName();
            String typeName = VALIDATE_TYPE_RULES.get(((PrimitiveType)value).getKind());
            assert (typeName != null) : ((PrimitiveType)value).getKind().toString();
            rule = new ValidatorRule(typeName);
        } else if (annName.equals("ValidateValidWhen")) {
            rule = new ValidatorRule("netui_validwhen");
            rule.setVar("netui_validwhen", CompilerUtils.getString(ruleAnnotation, "condition", true));
        } else if (annName.equals("ValidateCustom")) {
            String ruleName = CompilerUtils.getString(ruleAnnotation, "rule", false);
            rule = new ValidatorRule(ruleName);
            List<AnnotationMirror> ruleVars = CompilerUtils.getAnnotationArray(ruleAnnotation, "variables", false);
            for (AnnotationMirror ruleVar : ruleVars) {
                rule.setVar(CompilerUtils.getString(ruleVar, "name", false), CompilerUtils.getString(ruleVar, "value", false));
            }
        }
        return rule;
    }

    static {
        VALIDATE_TYPE_RULES.put(PrimitiveType.Kind.INT, "integer");
        VALIDATE_TYPE_RULES.put(PrimitiveType.Kind.FLOAT, "float");
        VALIDATE_TYPE_RULES.put(PrimitiveType.Kind.LONG, "long");
        VALIDATE_TYPE_RULES.put(PrimitiveType.Kind.DOUBLE, "double");
        VALIDATE_TYPE_RULES.put(PrimitiveType.Kind.BYTE, "byte");
        VALIDATE_TYPE_RULES.put(PrimitiveType.Kind.SHORT, "short");
    }
}

