/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.compiler.apt;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.Modifier;
import com.sun.mirror.declaration.TypeDeclaration;
import java.io.File;
import org.apache.beehive.netui.compiler.BaseChecker;
import org.apache.beehive.netui.compiler.CompilerUtils;
import org.apache.beehive.netui.compiler.Diagnostics;
import org.apache.beehive.netui.compiler.FacesBackingChecker;
import org.apache.beehive.netui.compiler.FacesBackingInfo;
import org.apache.beehive.netui.compiler.FlowControllerInfo;
import org.apache.beehive.netui.compiler.PageFlowChecker;
import org.apache.beehive.netui.compiler.SharedFlowChecker;
import org.apache.beehive.netui.compiler.apt.BaseAnnotationProcessor;

public class PageFlowAnnotationProcessor
extends BaseAnnotationProcessor {
    protected PageFlowAnnotationProcessor(AnnotationProcessorEnvironment env) {
        super(env);
    }

    protected BaseChecker getChecker(ClassDeclaration classDecl, Diagnostics diagnostics) {
        String className = classDecl.getQualifiedName();
        if (CompilerUtils.getAnnotation((Declaration)classDecl, "FacesBacking") != null) {
            File originalFile = CompilerUtils.getOriginalFile((TypeDeclaration)classDecl);
            FacesBackingInfo fbInfo = new FacesBackingInfo(originalFile, className);
            return new FacesBackingChecker(this.getEnv(), diagnostics, fbInfo);
        }
        if (CompilerUtils.isAssignableFrom("org.apache.beehive.netui.pageflow.PageFlowController", (TypeDeclaration)classDecl, this.getEnv())) {
            FlowControllerInfo fcInfo = new FlowControllerInfo(classDecl);
            if (PageFlowAnnotationProcessor.expectControllerAnnotation(classDecl, ".jpf", "org.apache.beehive.netui.pageflow.PageFlowController", diagnostics)) {
                return new PageFlowChecker(this.getEnv(), diagnostics, fcInfo);
            }
        } else if (CompilerUtils.isAssignableFrom("org.apache.beehive.netui.pageflow.SharedFlowController", (TypeDeclaration)classDecl, this.getEnv())) {
            FlowControllerInfo fcInfo = new FlowControllerInfo(classDecl);
            if (PageFlowAnnotationProcessor.expectControllerAnnotation(classDecl, ".jpfs", "org.apache.beehive.netui.pageflow.SharedFlowController", diagnostics)) {
                return new SharedFlowChecker(this.getEnv(), diagnostics, fcInfo);
            }
        } else if (CompilerUtils.isAssignableFrom("org.apache.beehive.netui.pageflow.GlobalApp", (TypeDeclaration)classDecl, this.getEnv())) {
            FlowControllerInfo fcInfo = new FlowControllerInfo(classDecl);
            if (PageFlowAnnotationProcessor.expectControllerAnnotation(classDecl, ".app", "org.apache.beehive.netui.pageflow.GlobalApp", diagnostics)) {
                return new SharedFlowChecker(this.getEnv(), diagnostics, fcInfo);
            }
        } else {
            AnnotationMirror ann = CompilerUtils.getAnnotation((Declaration)classDecl, "Controller");
            if (ann != null) {
                diagnostics.addError(ann, "error.annotation-invalid-base-class2", "Controller", "org.apache.beehive.netui.pageflow.PageFlowController", "org.apache.beehive.netui.pageflow.SharedFlowController");
            }
        }
        return null;
    }

    private static boolean expectControllerAnnotation(ClassDeclaration classDecl, String fileExtensionRequiresAnnotation, String baseClass, Diagnostics diagnostics) {
        if (CompilerUtils.getAnnotation((Declaration)classDecl, "Controller") != null) {
            return true;
        }
        String fileName = classDecl.getPosition().file().getName();
        if (fileExtensionRequiresAnnotation != null && fileName.endsWith(fileExtensionRequiresAnnotation)) {
            diagnostics.addError((Declaration)classDecl, "error.controller-annotation-required", fileExtensionRequiresAnnotation, "org.apache.beehive.netui.pageflow.annotations.Jpf.Controller");
        } else if (!CompilerUtils.hasModifier((Declaration)classDecl, Modifier.ABSTRACT)) {
            diagnostics.addWarning((Declaration)classDecl, "warning.no-controller-annotation", baseClass, "org.apache.beehive.netui.pageflow.annotations.Jpf.Controller");
        }
        return false;
    }
}

