/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.compiler.apt;

import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.util.DeclarationVisitor;
import com.sun.mirror.util.SimpleDeclarationVisitor;
import org.apache.beehive.netui.compiler.BaseChecker;
import org.apache.beehive.netui.compiler.BaseGenerator;
import org.apache.beehive.netui.compiler.Diagnostics;

public abstract class BaseAnnotationProcessor
implements AnnotationProcessor {
    private final AnnotationProcessorEnvironment _env;

    BaseAnnotationProcessor(AnnotationProcessorEnvironment env) {
        this._env = env;
    }

    public void process() {
        ListClassVisitor visitor = new ListClassVisitor();
        for (TypeDeclaration typeDecl : this._env.getSpecifiedTypeDeclarations()) {
            typeDecl.accept((DeclarationVisitor)visitor);
        }
    }

    protected abstract BaseChecker getChecker(ClassDeclaration var1, Diagnostics var2);

    protected AnnotationProcessorEnvironment getEnv() {
        return this._env;
    }

    private class ListClassVisitor
    extends SimpleDeclarationVisitor {
        private ListClassVisitor() {
        }

        public void visitTypeDeclaration(TypeDeclaration decl) {
            Diagnostics diagnostics;
            ClassDeclaration classDecl;
            BaseChecker checker;
            if (decl instanceof ClassDeclaration && (checker = BaseAnnotationProcessor.this.getChecker(classDecl = (ClassDeclaration)decl, diagnostics = new Diagnostics(BaseAnnotationProcessor.this._env))) != null) {
                BaseGenerator generator;
                checker.check(classDecl);
                if (!diagnostics.hadErrors() && (generator = checker.getGenerator()) != null) {
                    generator.generate(classDecl);
                }
            }
        }
    }
}

