/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.compiler;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.TypeDeclaration;
import java.io.File;
import java.io.IOException;
import org.apache.beehive.netui.compiler.AnnotationGrammar;
import org.apache.beehive.netui.compiler.BaseGenerator;
import org.apache.beehive.netui.compiler.CompilerUtils;
import org.apache.beehive.netui.compiler.Diagnostics;
import org.apache.beehive.netui.compiler.FlowControllerChecker;
import org.apache.beehive.netui.compiler.FlowControllerInfo;
import org.apache.beehive.netui.compiler.JpfLanguageConstants;
import org.apache.beehive.netui.compiler.SharedFlowGenerator;
import org.apache.beehive.netui.compiler.genmodel.GenSharedFlowStrutsApp;
import org.apache.beehive.netui.compiler.genmodel.GenStrutsApp;
import org.apache.beehive.netui.compiler.grammar.ControllerGrammar;
import org.apache.beehive.netui.compiler.model.NoWebInfDirectoryException;
import org.apache.xmlbeans.XmlException;

public class SharedFlowChecker
extends FlowControllerChecker {
    public SharedFlowChecker(AnnotationProcessorEnvironment env, Diagnostics diagnostics, FlowControllerInfo fcInfo) {
        super(env, diagnostics, fcInfo);
    }

    public BaseGenerator getGenerator() {
        return new SharedFlowGenerator(this.getEnv(), this.getFlowControllerInfo());
    }

    protected void doAdditionalClassChecks(ClassDeclaration jclass, File webappRoot) {
        String pkg = jclass.getPackage().getQualifiedName();
        if (pkg.length() == 0) {
            this.getDiagnostics().addError((Declaration)jclass, "error.wrong-package", "webappRoot");
        }
        if (CompilerUtils.isAssignableFrom("org.apache.beehive.netui.pageflow.GlobalApp", (TypeDeclaration)jclass, this.getEnv())) {
            if (!pkg.equals("global")) {
                this.getDiagnostics().addError((Declaration)jclass, "error.wrong-package", "global");
            }
            if (!jclass.getPosition().file().getPath().contains(JpfLanguageConstants.WEBINF_SRC_DIR)) {
                this.getDiagnostics().addError((Declaration)jclass, "error.global-app-wrong-dir", "Global.app", "/WEB-INF/src/global");
            }
        }
    }

    protected String getDesiredBaseClass(ClassDeclaration jclass) {
        File sourceFile = CompilerUtils.getOriginalFile((TypeDeclaration)jclass);
        if (sourceFile.getName().endsWith(".app")) {
            return "org.apache.beehive.netui.pageflow.GlobalApp";
        }
        if (sourceFile.getName().endsWith(".jpfs")) {
            return "org.apache.beehive.netui.pageflow.SharedFlowController";
        }
        return null;
    }

    protected GenStrutsApp createStrutsApp(File sourceFile, ClassDeclaration jclass) throws XmlException, IOException, NoWebInfDirectoryException {
        return new GenSharedFlowStrutsApp(sourceFile, jclass, this.getEnv(), this.getFlowControllerInfo(), true);
    }

    protected AnnotationGrammar getControllerGrammar() {
        return new ControllerGrammar(this.getEnv(), this.getDiagnostics(), this.getRuntimeVersionChecker(), this.getFlowControllerInfo());
    }
}

