/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.compiler;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.Declaration;
import java.io.File;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.beehive.netui.compiler.Diagnostics;
import org.apache.beehive.netui.compiler.JpfLanguageConstants;

public class RuntimeVersionChecker
implements JpfLanguageConstants {
    private String _runtimeVersion;

    RuntimeVersionChecker() {
        this._runtimeVersion = this.getHighVersion();
    }

    public RuntimeVersionChecker(File webappRoot) {
        File pageflowJar = new File(webappRoot.getPath() + "/WEB-INF/lib/beehive-netui-pageflow.jar");
        if (pageflowJar.exists()) {
            try {
                Attributes attrs;
                Manifest mf = new JarFile(pageflowJar).getManifest();
                if (mf != null && (attrs = mf.getMainAttributes()) != null) {
                    String version = attrs.getValue("PageFlow-Runtime-Version");
                    this._runtimeVersion = version != null ? version : "0";
                }
            }
            catch (IOException e) {
                this._runtimeVersion = this.getHighVersion();
            }
        } else {
            this._runtimeVersion = this.getHighVersion();
        }
    }

    private String getHighVersion() {
        return new Integer(Integer.MAX_VALUE).toString();
    }

    int getRuntimeVersion() {
        return Integer.parseInt(this._runtimeVersion);
    }

    public boolean checkRuntimeVersion(String requiredRuntimeVersion, AnnotationValue value, Diagnostics diags, String errMsg, Object ... errMsgParams) {
        if (requiredRuntimeVersion != null) {
            int runtimeVersion = this.getRuntimeVersion();
            if (Integer.parseInt(requiredRuntimeVersion) > runtimeVersion) {
                diags.addError(value, errMsg, errMsgParams);
                return false;
            }
        }
        return true;
    }

    public boolean checkRuntimeVersion(String requiredRuntimeVersion, Declaration element, Diagnostics diags, String errMsg, Object ... errMsgParams) {
        if (requiredRuntimeVersion != null) {
            int runtimeVersion = this.getRuntimeVersion();
            if (Integer.parseInt(requiredRuntimeVersion) > runtimeVersion) {
                diags.addError(element, errMsg, errMsgParams);
                return false;
            }
        }
        return true;
    }

    public boolean checkRuntimeVersion(String requiredRuntimeVersion, AnnotationMirror element, Diagnostics diags, String errMsg, Object ... errMsgParams) {
        if (requiredRuntimeVersion != null) {
            int runtimeVersion = this.getRuntimeVersion();
            if (Integer.parseInt(requiredRuntimeVersion) > runtimeVersion) {
                diags.addError(element, errMsg, errMsgParams);
                return false;
            }
        }
        return true;
    }
}

