/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.compiler;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeElementDeclaration;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.MemberDeclaration;
import com.sun.mirror.declaration.Modifier;
import com.sun.mirror.declaration.PackageDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.TypeMirror;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.apache.beehive.netui.compiler.AnnotationGrammar;
import org.apache.beehive.netui.compiler.AnnotationMemberType;
import org.apache.beehive.netui.compiler.BaseGenerator;
import org.apache.beehive.netui.compiler.CompilerUtils;
import org.apache.beehive.netui.compiler.Diagnostics;
import org.apache.beehive.netui.compiler.FlowControllerChecker;
import org.apache.beehive.netui.compiler.FlowControllerInfo;
import org.apache.beehive.netui.compiler.JpfLanguageConstants;
import org.apache.beehive.netui.compiler.PageFlowGenerator;
import org.apache.beehive.netui.compiler.genmodel.GenStrutsApp;
import org.apache.beehive.netui.compiler.grammar.ControllerGrammar;
import org.apache.beehive.netui.compiler.grammar.WebappPathOrActionType;
import org.apache.beehive.netui.compiler.model.NoWebInfDirectoryException;
import org.apache.xmlbeans.XmlException;

public class PageFlowChecker
extends FlowControllerChecker {
    private static final FilenameFilter JPF_FILE_FILTER = new JpfFileFilter();

    public PageFlowChecker(AnnotationProcessorEnvironment env, Diagnostics diagnostics, FlowControllerInfo fcInfo) {
        super(env, diagnostics, fcInfo);
    }

    public BaseGenerator getGenerator() {
        return new PageFlowGenerator(this.getEnv(), this.getFlowControllerInfo());
    }

    protected void checkField(FieldDeclaration field, TypeDeclaration jclass) {
        AnnotationMirror sfFieldAnn = CompilerUtils.getAnnotation((Declaration)field, "SharedFlowField");
        if (sfFieldAnn != null) {
            String sharedFlowName = CompilerUtils.getString(sfFieldAnn, "name", true);
            assert (sharedFlowName != null);
            Collection<AnnotationMirror> sharedFlowRefs = this.getFlowControllerInfo().getMergedControllerAnnotation().getSharedFlowRefs();
            boolean foundOne = false;
            if (sharedFlowRefs != null) {
                for (AnnotationMirror sharedFlowRef : sharedFlowRefs) {
                    if (!sharedFlowName.equals(CompilerUtils.getString(sharedFlowRef, "name", true))) continue;
                    foundOne = true;
                    TypeMirror sfType = CompilerUtils.getTypeMirror(sharedFlowRef, "type", true);
                    TypeMirror ft = field.getType();
                    if (sfType instanceof DeclaredType && CompilerUtils.isAssignableFrom(ft, ((DeclaredType)sfType).getDeclaration())) continue;
                    this.getDiagnostics().addError((Declaration)field, "error.field-not-assignable", CompilerUtils.getDeclaration((DeclaredType)sfType).getQualifiedName());
                }
            }
            if (!foundOne) {
                this.getDiagnostics().addError(sfFieldAnn, "error.no-matching-shared-flow-declared", "SharedFlowRef", sharedFlowName);
            }
        }
        super.checkField(field, jclass);
    }

    protected void doAdditionalClassChecks(ClassDeclaration jpfClass, File webappRoot) {
        int len;
        File jpfFile = CompilerUtils.getOriginalFile((TypeDeclaration)jpfClass);
        PackageDeclaration pkg = jpfClass.getPackage();
        Collection packageClasses = pkg.getClasses();
        HashSet<String> overlapping = new HashSet<String>();
        ArrayList<File> overlappingFiles = new ArrayList<File>();
        for (ClassDeclaration classDecl : packageClasses) {
            if (!CompilerUtils.isPageFlowClass(classDecl, this.getEnv())) continue;
            File file = CompilerUtils.getOriginalFile((TypeDeclaration)classDecl);
            if (jpfFile == null || jpfFile.equals(file) || file == null || !file.exists()) continue;
            overlapping.add(file.getName());
            overlappingFiles.add(file);
        }
        File parentDir = jpfFile.getParentFile();
        File[] peers = parentDir.listFiles(JPF_FILE_FILTER);
        if (peers != null) {
            for (int i = 0; i < peers.length; ++i) {
                String name;
                File peer = peers[i];
                if (peer.equals(jpfFile) || overlapping.contains(name = peer.getName())) continue;
                overlapping.add(name);
                overlappingFiles.add(peer);
            }
        }
        if ((len = overlapping.size()) > 0) {
            if (len > 3) {
                this.getDiagnostics().addError((Declaration)jpfClass, "error.overlapping-pageflows", overlapping.toArray());
            } else {
                this.getDiagnostics().addError((Declaration)jpfClass, "error.overlapping-pageflows" + len, overlapping.toArray());
            }
        }
        this.getCheckResultMap().put(JpfLanguageConstants.ExtraInfoKeys.overlappingPageFlowFiles, overlappingFiles);
        String jpfPackageName = pkg.getQualifiedName();
        if (parentDir.equals(webappRoot)) {
            if (jpfPackageName != null && jpfPackageName.length() > 0) {
                this.getDiagnostics().addError((Declaration)jpfClass, "error.root-level-package", new Object[0]);
            }
        } else {
            String expectedPackage = parentDir.getPath().substring(webappRoot.getPath().length());
            if ((expectedPackage = expectedPackage.replace('\\', '/')).startsWith("/WEB-INF/src")) {
                expectedPackage = expectedPackage.substring("/WEB-INF/src".length());
            }
            assert (expectedPackage.length() != 1) : expectedPackage;
            if (expectedPackage.length() > 1) {
                expectedPackage = expectedPackage.substring(1).replace('/', '.');
            }
            if (jpfPackageName != null && !jpfPackageName.equals(expectedPackage)) {
                this.getDiagnostics().addError((Declaration)jpfClass, "error.wrong-package", expectedPackage);
            }
        }
        if (pkg != null && jpfClass.getSimpleName().equals(pkg.getSimpleName())) {
            this.getDiagnostics().addWarning((Declaration)jpfClass, "warning.classname-same-as-package", new Object[0]);
        }
        if (!WebappPathOrActionType.actionExists("begin", (TypeDeclaration)jpfClass, null, this.getEnv(), this.getFlowControllerInfo(), true) && !CompilerUtils.hasModifier((Declaration)jpfClass, Modifier.ABSTRACT)) {
            this.getDiagnostics().addError((Declaration)jpfClass, "error.no-begin-action", new Object[0]);
        }
        if (this.getFlowControllerInfo().isNested() && this.getFlowControllerInfo().countReturnActions() == 0) {
            this.getDiagnostics().addError((Declaration)jpfClass, "error.no-return-action", "Jpf.Forward");
        }
    }

    protected String getDesiredBaseClass(ClassDeclaration jclass) {
        return "org.apache.beehive.netui.pageflow.PageFlowController";
    }

    protected GenStrutsApp createStrutsApp(File sourceFile, ClassDeclaration jclass) throws XmlException, IOException, NoWebInfDirectoryException {
        return new GenStrutsApp(sourceFile, jclass, this.getEnv(), this.getFlowControllerInfo(), true);
    }

    protected AnnotationGrammar getControllerGrammar() {
        return new JpfControllerGrammar();
    }

    private class JpfControllerGrammar
    extends ControllerGrammar {
        public JpfControllerGrammar() {
            super(PageFlowChecker.this.getEnv(), PageFlowChecker.this.getDiagnostics(), PageFlowChecker.this.getRuntimeVersionChecker(), PageFlowChecker.this.getFlowControllerInfo());
            this.addMemberType("nested", new AnnotationMemberType(null, this));
            this.addMemberType("longLived", new LongLivedAttrType());
        }

        protected class LongLivedAttrType
        extends AnnotationMemberType {
            public LongLivedAttrType() {
                super("3", JpfControllerGrammar.this);
            }

            public Object onCheck(AnnotationTypeElementDeclaration valueDecl, AnnotationValue value, AnnotationMirror[] parentAnnotations, MemberDeclaration classMember) {
                boolean isLongLived = (Boolean)value.getValue();
                if (isLongLived && PageFlowChecker.this.getFlowControllerInfo().isNested()) {
                    this.addError(value, "error.nested-long-lived", new Object[0]);
                }
                return null;
            }
        }
    }

    private static class JpfFileFilter
    implements FilenameFilter {
        private JpfFileFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(".jpf");
        }
    }
}

