/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.compiler;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.ClassType;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.beehive.netui.compiler.CompilerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergedControllerAnnotation {
    private String _strutsMerge;
    private String _validatorMerge;
    private List<String> _tilesDefsConfigs;
    private boolean _nested;
    private boolean _longLived;
    private List<String> _rolesAllowed;
    private boolean _loginRequired;
    private boolean _readOnly;
    private LinkedHashMap<String, AnnotationMirror> _forwards = new LinkedHashMap();
    private LinkedHashMap<String, AnnotationMirror> _sharedFlowRefs = new LinkedHashMap();
    private LinkedHashMap<String, AnnotationMirror> _catches = new LinkedHashMap();
    private LinkedHashMap<String, AnnotationMirror> _simpleActions = new LinkedHashMap();
    private LinkedHashMap<String, AnnotationMirror> _validatableBeans = new LinkedHashMap();
    private LinkedHashMap<String, AnnotationMirror> _messageResources = new LinkedHashMap();
    private String _multipartHandler;

    public MergedControllerAnnotation(TypeDeclaration jclass) {
        this.mergeControllerAnnotations(jclass);
    }

    public void mergeAnnotation(AnnotationMirror controllerAnnotation) {
        Boolean readOnly;
        Boolean loginRequired;
        Boolean longLived;
        Boolean nested;
        String validatorMerge;
        String strutsMerge = CompilerUtils.getString(controllerAnnotation, "strutsMerge", true);
        if (strutsMerge != null) {
            this._strutsMerge = strutsMerge;
        }
        if ((validatorMerge = CompilerUtils.getString(controllerAnnotation, "validatorMerge", true)) != null) {
            this._validatorMerge = validatorMerge;
        }
        if ((nested = CompilerUtils.getBoolean(controllerAnnotation, "nested", true)) != null) {
            this._nested = nested;
        }
        if ((longLived = CompilerUtils.getBoolean(controllerAnnotation, "longLived", true)) != null) {
            this._longLived = longLived;
        }
        if ((loginRequired = CompilerUtils.getBoolean(controllerAnnotation, "loginRequired", true)) != null) {
            this._loginRequired = loginRequired;
        }
        if ((readOnly = CompilerUtils.getBoolean(controllerAnnotation, "readOnly", true)) != null) {
            this._readOnly = readOnly;
        }
        this._rolesAllowed = MergedControllerAnnotation.mergeStringArray(this._rolesAllowed, controllerAnnotation, "rolesAllowed");
        this._tilesDefsConfigs = MergedControllerAnnotation.mergeStringArray(this._tilesDefsConfigs, controllerAnnotation, "tilesDefinitionsConfigs");
        MergedControllerAnnotation.mergeAnnotationArray(this._forwards, controllerAnnotation, "forwards", "name");
        MergedControllerAnnotation.mergeAnnotationArray(this._sharedFlowRefs, controllerAnnotation, "sharedFlowRefs", "name");
        MergedControllerAnnotation.mergeAnnotationArray(this._catches, controllerAnnotation, "catches", "type");
        MergedControllerAnnotation.mergeAnnotationArray(this._simpleActions, controllerAnnotation, "simpleActions", "name");
        MergedControllerAnnotation.mergeAnnotationArray(this._validatableBeans, controllerAnnotation, "validatableBeans", "type");
        MergedControllerAnnotation.mergeAnnotationArray(this._messageResources, controllerAnnotation, "messageResources", "name");
        String multipartHandler = CompilerUtils.getEnumFieldName(controllerAnnotation, "multipartHandler", true);
        if (multipartHandler != null) {
            this._multipartHandler = multipartHandler;
        }
    }

    private static List<String> mergeStringArray(List<String> memberList, AnnotationMirror parentAnnotation, String attr) {
        List<String> newList = CompilerUtils.getStringArray(parentAnnotation, attr, true);
        if (newList != null) {
            if (memberList == null) {
                return newList;
            }
            memberList.addAll(newList);
        }
        return memberList;
    }

    private static void mergeAnnotationArray(LinkedHashMap<String, AnnotationMirror> keyedList, AnnotationMirror parentAnnotation, String attr, String keyAttr) {
        List<AnnotationMirror> annotations = CompilerUtils.getAnnotationArray(parentAnnotation, attr, true);
        if (annotations != null) {
            for (AnnotationMirror ann : annotations) {
                AnnotationValue key = CompilerUtils.getAnnotationValue(ann, keyAttr, true);
                assert (key != null) : "missing value for " + keyAttr + " on " + ann.getAnnotationType().getDeclaration().getQualifiedName();
                keyedList.put(key.toString(), ann);
            }
        }
    }

    public String getStrutsMerge() {
        return this._strutsMerge;
    }

    public String getValidatorMerge() {
        return this._validatorMerge;
    }

    public List<String> getTilesDefinitionsConfigs() {
        return this._tilesDefsConfigs;
    }

    public boolean isNested() {
        return this._nested;
    }

    public boolean isLongLived() {
        return this._longLived;
    }

    public List<String> getRolesAllowed() {
        return this._rolesAllowed;
    }

    public boolean isLoginRequired() {
        return this._loginRequired;
    }

    public boolean isReadOnly() {
        return this._readOnly;
    }

    public Collection<AnnotationMirror> getForwards() {
        return this._forwards.values();
    }

    public Collection<AnnotationMirror> getSharedFlowRefs() {
        return this._sharedFlowRefs.values();
    }

    public Collection<AnnotationMirror> getCatches() {
        return this._catches.values();
    }

    public Collection<AnnotationMirror> getSimpleActions() {
        return this._simpleActions.values();
    }

    public Collection<AnnotationMirror> getValidatableBeans() {
        return this._validatableBeans.values();
    }

    public Collection<AnnotationMirror> getMessageResources() {
        return this._messageResources.values();
    }

    public String getMultipartHandler() {
        return this._multipartHandler;
    }

    private void mergeControllerAnnotations(TypeDeclaration jclass) {
        if (jclass != null && jclass instanceof ClassDeclaration) {
            AnnotationMirror controllerAnnotation;
            ClassType superClass = ((ClassDeclaration)jclass).getSuperclass();
            if (superClass != null) {
                this.mergeControllerAnnotations((TypeDeclaration)superClass.getDeclaration());
            }
            if ((controllerAnnotation = CompilerUtils.getAnnotation((Declaration)jclass, "Controller")) != null) {
                this.mergeAnnotation(controllerAnnotation);
            }
        }
    }
}

