/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.compiler;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeElementDeclaration;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.MemberDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.Modifier;
import com.sun.mirror.declaration.TypeDeclaration;
import java.util.Collection;
import java.util.Map;
import org.apache.beehive.netui.compiler.AnnotationGrammar;
import org.apache.beehive.netui.compiler.BaseChecker;
import org.apache.beehive.netui.compiler.BaseGenerator;
import org.apache.beehive.netui.compiler.CompilerUtils;
import org.apache.beehive.netui.compiler.Diagnostics;
import org.apache.beehive.netui.compiler.grammar.ValidatablePropertyGrammar;

public class FormBeanChecker
extends BaseChecker {
    public FormBeanChecker(AnnotationProcessorEnvironment env, Diagnostics diags) {
        super(env, diags);
    }

    public BaseGenerator getGenerator() {
        return null;
    }

    public Map onCheck(ClassDeclaration jclass) {
        GetterValidatablePropertyGrammar validatablePropertyGrammar = new GetterValidatablePropertyGrammar();
        boolean isFormBeanClass = CompilerUtils.getAnnotation((Declaration)jclass, "FormBean") != null;
        Collection<MethodDeclaration> methods = CompilerUtils.getClassMethods((TypeDeclaration)jclass, null);
        for (MethodDeclaration method : methods) {
            isFormBeanClass |= this.checkValidationAnnotation(method, "ValidatableProperty", validatablePropertyGrammar);
        }
        if (isFormBeanClass || CompilerUtils.isAssignableFrom("org.apache.struts.action.ActionForm", (TypeDeclaration)jclass, this.getEnv())) {
            if (jclass.getDeclaringType() != null && !CompilerUtils.hasModifier((Declaration)jclass, Modifier.STATIC)) {
                this.getDiagnostics().addError((Declaration)jclass, "error.form-not-static", new Object[0]);
            }
            if (!CompilerUtils.hasModifier((Declaration)jclass, Modifier.PUBLIC)) {
                this.getDiagnostics().addError((Declaration)jclass, "error.form-not-public", new Object[0]);
            }
            if (!CompilerUtils.hasDefaultConstructor((TypeDeclaration)jclass)) {
                this.getDiagnostics().addError((Declaration)jclass, "error.form-no-default-constructor", new Object[0]);
            }
        }
        return null;
    }

    private boolean checkValidationAnnotation(MethodDeclaration method, String annotationTagName, AnnotationGrammar grammar) {
        AnnotationMirror annotation = CompilerUtils.getAnnotation((Declaration)method, annotationTagName);
        if (annotation != null) {
            if (CompilerUtils.getBeanProperty(method) == null) {
                this.getDiagnostics().addError(annotation, "error.validation-field-on-non-getter", new Object[0]);
            }
            grammar.check(annotation, null, (MemberDeclaration)method);
            return true;
        }
        return false;
    }

    private class GetterValidatablePropertyGrammar
    extends ValidatablePropertyGrammar {
        public GetterValidatablePropertyGrammar() {
            super(FormBeanChecker.this.getEnv(), FormBeanChecker.this.getDiagnostics(), FormBeanChecker.this.getRuntimeVersionChecker());
        }

        public String[][] getRequiredAttrs() {
            return null;
        }

        protected void onCheckMember(AnnotationTypeElementDeclaration memberDecl, AnnotationValue member, AnnotationMirror annotation, AnnotationMirror[] parentAnnotations, MemberDeclaration classMember) {
            if (memberDecl.getSimpleName().equals("propertyName")) {
                this.addError(member, "error.validatable-field-property-name-not-allowed", "propertyName");
            }
        }
    }
}

