/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.compiler;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.TypeMirror;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.beehive.netui.compiler.CompilerUtils;
import org.apache.beehive.netui.compiler.MergedControllerAnnotation;
import org.apache.beehive.netui.compiler.SourceFileInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowControllerInfo
extends SourceFileInfo {
    private static final ActionInfo[] EMPTY_ACTION_INFO_ARRAY = new ActionInfo[0];
    private Set<ActionInfo> _actions = new HashSet<ActionInfo>();
    private Set _returnActions = null;
    private File _webappRoot = null;
    private Map<String, TypeDeclaration> _sharedFlowTypes = Collections.emptyMap();
    private Map<String, String> _sharedFlowTypeNames = Collections.emptyMap();
    private Map<String, File> _sharedFlowFiles = Collections.emptyMap();
    private List<File> _referencedFiles = new ArrayList<File>();
    private boolean _isBuilding = false;
    private Map<String, String> _messageResourcesByKey = new HashMap<String, String>();
    private boolean _navigateToActionEnabled = false;
    private boolean _navigateToPageEnabled = false;
    private boolean _isNested;
    private MergedControllerAnnotation _mergedControllerAnnotation;

    public FlowControllerInfo(ClassDeclaration jclass) {
        super(CompilerUtils.getOriginalFile((TypeDeclaration)jclass), jclass.getQualifiedName());
    }

    public FlowControllerInfo(ClassDeclaration jclass, File webappRoot) {
        this(jclass);
        this._webappRoot = webappRoot;
    }

    void startBuild(AnnotationProcessorEnvironment env, ClassDeclaration jclass) {
        this._isBuilding = true;
        this._mergedControllerAnnotation = new MergedControllerAnnotation((TypeDeclaration)jclass);
        this._isNested = this._mergedControllerAnnotation.isNested();
        this.setSharedFlowInfo(env);
    }

    void endBuild() {
        this._isBuilding = false;
        this._sharedFlowTypes = null;
        this._mergedControllerAnnotation = null;
    }

    public ActionInfo[] getActions() {
        return this._actions.toArray(new ActionInfo[this._actions.size()]);
    }

    public boolean isNested() {
        return this._isNested;
    }

    public ActionInfo[] getReturnActions() {
        if (this._returnActions == null) {
            return EMPTY_ACTION_INFO_ARRAY;
        }
        return this._returnActions.toArray(new ActionInfo[this._returnActions.size()]);
    }

    public String getFormBeanType(String actionName) {
        String bestType = null;
        for (ActionInfo actionInfo : this._actions) {
            if (!actionInfo.getName().equals(actionName)) continue;
            String beanType = actionInfo.getBeanType();
            if (beanType == null) {
                return null;
            }
            if (bestType == null) {
                bestType = beanType;
                continue;
            }
            if (beanType.compareTo(bestType) >= 0) continue;
            bestType = beanType;
        }
        return bestType;
    }

    int countReturnActions() {
        return this._returnActions != null ? this._returnActions.size() : 0;
    }

    public void addAction(String actionName, String formBeanType) {
        this._actions.add(new ActionInfo(actionName, formBeanType));
    }

    public void addReturnAction(String returnActionName, String formBeanType) {
        if (this._returnActions == null) {
            this._returnActions = new HashSet();
        }
        this._returnActions.add(new ActionInfo(returnActionName, formBeanType));
    }

    public List<File> getReferencedFiles() {
        return this._referencedFiles;
    }

    public void addReferencedFile(File file) {
        if (!file.equals(this.getSourceFile())) {
            this._referencedFiles.add(file);
        }
    }

    private void setSharedFlowInfo(AnnotationProcessorEnvironment env) {
        TypeDeclaration typeDeclaration;
        File globalAppFile;
        this._sharedFlowTypes = new LinkedHashMap<String, TypeDeclaration>();
        Collection<AnnotationMirror> sharedFlowRefs = this._mergedControllerAnnotation.getSharedFlowRefs();
        if (sharedFlowRefs != null) {
            for (AnnotationMirror annotationMirror : sharedFlowRefs) {
                TypeDeclaration typeDecl;
                String name = CompilerUtils.getString(annotationMirror, "name", true);
                TypeMirror type2 = CompilerUtils.getTypeMirror(annotationMirror, "type", true);
                if (!(type2 instanceof DeclaredType) || (typeDecl = ((DeclaredType)type2).getDeclaration()) == null) continue;
                this._sharedFlowTypes.put(name, typeDecl);
            }
        }
        if (this._sharedFlowTypes.isEmpty() && (globalAppFile = new File(this.getWebappRoot().getPath() + "/WEB-INF/src/global/Global.app")).exists() && (typeDeclaration = env.getTypeDeclaration("global.Global")) != null) {
            this._sharedFlowTypes.put("__global", typeDeclaration);
        }
        this._sharedFlowTypeNames = new LinkedHashMap<String, String>();
        this._sharedFlowFiles = new LinkedHashMap<String, File>();
        for (Map.Entry entry : this._sharedFlowTypes.entrySet()) {
            TypeDeclaration type3 = (TypeDeclaration)entry.getValue();
            this._sharedFlowTypeNames.put((String)entry.getKey(), type3.getQualifiedName());
            File file = CompilerUtils.getOriginalFile(type3);
            this._sharedFlowFiles.put((String)entry.getKey(), file);
            this._referencedFiles.add(file);
        }
    }

    public Map<String, TypeDeclaration> getSharedFlowTypes() {
        assert (this._isBuilding) : "use getSharedFlowTypeNames after check or generate phases";
        return this._sharedFlowTypes;
    }

    public Map<String, String> getSharedFlowTypeNames() {
        return this._sharedFlowTypeNames;
    }

    public MergedControllerAnnotation getMergedControllerAnnotation() {
        assert (this._isBuilding) : "only valid during the check or generate phases";
        return this._mergedControllerAnnotation;
    }

    public File getWebappRoot() {
        return this._webappRoot;
    }

    void setWebappRoot(File webappRoot) {
        this._webappRoot = webappRoot;
    }

    public Map<String, String> getMessageResourcesByKey() {
        return this._messageResourcesByKey;
    }

    public void addMessageResource(String key, String name) {
        this._messageResourcesByKey.put(key, name);
    }

    public String getControllerClassName() {
        return this.getClassName();
    }

    public Map<String, File> getSharedFlowFiles() {
        return this._sharedFlowFiles;
    }

    public void enableNavigateToAction() {
        this._navigateToActionEnabled = true;
    }

    public void enableNavigateToPage() {
        this._navigateToPageEnabled = true;
    }

    public boolean isNavigateToActionEnabled() {
        return this._navigateToActionEnabled;
    }

    public boolean isNavigateToPageEnabled() {
        return this._navigateToPageEnabled;
    }

    public static class ActionInfo {
        private String _name;
        private String _beanType = null;

        public ActionInfo(String name) {
            this._name = name;
        }

        public ActionInfo(String name, String beanType) {
            this._name = name;
            this._beanType = beanType;
        }

        public void setBeanType(String beanType) {
            this._beanType = beanType;
        }

        public String getName() {
            return this._name;
        }

        public String getBeanType() {
            return this._beanType;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof ActionInfo)) {
                return false;
            }
            ActionInfo other = (ActionInfo)o;
            if (!this._name.equals(other.getName())) {
                return false;
            }
            String otherBeanType = other.getBeanType();
            return this._beanType == null && otherBeanType == null || this._beanType != null && otherBeanType != null && this._beanType.equals(otherBeanType);
        }

        public int hashCode() {
            int nameHash = this._name.hashCode();
            if (this._beanType == null) {
                return nameHash;
            }
            return nameHash != 0 ? this._beanType.hashCode() % nameHash : this._beanType.hashCode();
        }
    }
}

