/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.compiler;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.TypeDeclaration;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.beehive.netui.compiler.BaseGenerator;
import org.apache.beehive.netui.compiler.CompilerUtils;
import org.apache.beehive.netui.compiler.Diagnostics;
import org.apache.beehive.netui.compiler.FlowControllerInfo;
import org.apache.beehive.netui.compiler.genmodel.GenStrutsApp;
import org.apache.beehive.netui.compiler.genmodel.GenValidationModel;
import org.apache.beehive.netui.compiler.model.NoWebInfDirectoryException;
import org.apache.xmlbeans.XmlException;

abstract class FlowControllerGenerator
extends BaseGenerator {
    private static long _compilerJarTimestamp = -1L;
    private static final boolean ALWAYS_GENERATE = true;
    private FlowControllerInfo _fcInfo;

    protected FlowControllerGenerator(AnnotationProcessorEnvironment env, FlowControllerInfo fcInfo) {
        super(env);
        this._fcInfo = fcInfo;
    }

    protected abstract GenStrutsApp createStrutsApp(File var1, ClassDeclaration var2) throws XmlException, IOException, NoWebInfDirectoryException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(ClassDeclaration publicClass) {
        GenStrutsApp app = null;
        this._fcInfo.startBuild(this.getEnv(), publicClass);
        try {
            app = this.createStrutsApp(CompilerUtils.getOriginalFile((TypeDeclaration)publicClass), publicClass);
            GenValidationModel validationModel = new GenValidationModel(publicClass, app);
            if (!validationModel.isEmpty()) {
                app.setValidationModel(validationModel);
                validationModel.writeToFile();
            }
            this.generateStrutsConfig(app, publicClass);
        }
        catch (Exception e) {
            e.printStackTrace();
            assert (e instanceof NoWebInfDirectoryException || e instanceof XmlException || e instanceof IOException || e instanceof FileNotFoundException);
            this.getDiagnostics().addError((Declaration)publicClass, "error.could-not-generate-struts-config", app != null ? app.getStrutsConfigFile() : null);
        }
        finally {
            this._fcInfo.endBuild();
        }
    }

    protected void generateStrutsConfig(GenStrutsApp app, ClassDeclaration publicClass) {
        File strutsConfigFile = null;
        try {
            strutsConfigFile = app.getStrutsConfigFile();
            app.writeToFile();
        }
        catch (Exception e) {
            Object[] objectArray;
            e.printStackTrace();
            assert (e instanceof NoWebInfDirectoryException || e instanceof FileNotFoundException || e instanceof IOException || e instanceof XmlException);
            this.getEnv().getMessager().printError(publicClass.getPosition(), "");
            Diagnostics diagnostics = this.getDiagnostics();
            Object[] objectArray2 = new Object[2];
            if (strutsConfigFile != null) {
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = strutsConfigFile.getPath();
            } else {
                objectArray = null;
            }
            objectArray2[0] = objectArray;
            objectArray2[1] = null;
            diagnostics.addError((Declaration)publicClass, "error.could-not-generate-struts-config", objectArray2);
        }
    }

    protected FlowControllerInfo getFlowControllerInfo() {
        return this._fcInfo;
    }
}

