/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.compiler;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.MemberDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.Modifier;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.TypeMirror;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.beehive.netui.compiler.AnnotationGrammar;
import org.apache.beehive.netui.compiler.BaseChecker;
import org.apache.beehive.netui.compiler.BaseGenerator;
import org.apache.beehive.netui.compiler.CompilerUtils;
import org.apache.beehive.netui.compiler.Diagnostics;
import org.apache.beehive.netui.compiler.FlowControllerInfo;
import org.apache.beehive.netui.compiler.FormBeanChecker;
import org.apache.beehive.netui.compiler.JpfLanguageConstants;
import org.apache.beehive.netui.compiler.MergedControllerAnnotation;
import org.apache.beehive.netui.compiler.genmodel.GenStrutsApp;
import org.apache.beehive.netui.compiler.grammar.ActionGrammar;
import org.apache.beehive.netui.compiler.grammar.ExceptionHandlerGrammar;
import org.apache.beehive.netui.compiler.grammar.WebappPathType;
import org.apache.beehive.netui.compiler.model.NoWebInfDirectoryException;
import org.apache.xmlbeans.XmlException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FlowControllerChecker
extends BaseChecker {
    private FlowControllerInfo _fcInfo;
    private AnnotationGrammar _controllerGrammar;
    private AnnotationGrammar _actionGrammar;
    private AnnotationGrammar _exceptionHandlerGrammar;
    private FormBeanChecker _formBeanChecker;
    private Map _checkResultMap;

    protected FlowControllerChecker(AnnotationProcessorEnvironment env, Diagnostics diags, FlowControllerInfo fcInfo) {
        super(env, diags);
        this._fcInfo = fcInfo;
    }

    protected void doAdditionalClassChecks(ClassDeclaration jpfClass, File webappRoot) {
    }

    protected Map getCheckResultMap() {
        return this._checkResultMap;
    }

    protected abstract String getDesiredBaseClass(ClassDeclaration var1);

    protected abstract AnnotationGrammar getControllerGrammar();

    @Override
    public abstract BaseGenerator getGenerator();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map onCheck(ClassDeclaration jclass) {
        this._checkResultMap = new HashMap();
        this._controllerGrammar = this.getControllerGrammar();
        this._actionGrammar = new ActionGrammar(this.getEnv(), this.getDiagnostics(), this.getRuntimeVersionChecker(), this._fcInfo);
        this._exceptionHandlerGrammar = new ExceptionHandlerGrammar(this.getEnv(), this.getDiagnostics(), this.getRuntimeVersionChecker(), this._fcInfo);
        this._formBeanChecker = new FormBeanChecker(this.getEnv(), this.getDiagnostics());
        this._fcInfo.setWebappRoot(this.getWebappRoot());
        this._fcInfo.startBuild(this.getEnv(), jclass);
        try {
            Map map = this.onCheckInternal(jclass);
            return map;
        }
        finally {
            this._fcInfo.endBuild();
        }
    }

    private Map onCheckInternal(ClassDeclaration jclass) {
        String desiredBaseClass = this.getDesiredBaseClass(jclass);
        if (desiredBaseClass != null && !CompilerUtils.isAssignableFrom(desiredBaseClass, (TypeDeclaration)jclass, this.getEnv())) {
            this.getDiagnostics().addError((Declaration)jclass, "error.does-not-extend-base", desiredBaseClass);
        }
        this.startCheckClass(jclass);
        Collection<FieldDeclaration> fields = CompilerUtils.getClassFields((TypeDeclaration)jclass);
        for (FieldDeclaration field : fields) {
            this.checkField(field, (TypeDeclaration)jclass);
        }
        Collection<MethodDeclaration> methods = CompilerUtils.getClassMethods((TypeDeclaration)jclass, null);
        for (MethodDeclaration method : methods) {
            this.checkMethod(method, jclass);
        }
        Collection<TypeDeclaration> innerTypes = CompilerUtils.getClassNestedTypes((TypeDeclaration)jclass);
        for (TypeDeclaration innerType : innerTypes) {
            if (!(innerType instanceof ClassDeclaration)) continue;
            this.checkInnerClass((ClassDeclaration)innerType);
        }
        this.doAdditionalClassChecks(jclass, this.getWebappRoot());
        FlowControllerChecker.enableNavigateTo((TypeDeclaration)jclass, this._fcInfo.getMergedControllerAnnotation(), this._fcInfo);
        Map<String, TypeDeclaration> sharedFlowTypes = this._fcInfo.getSharedFlowTypes();
        if (sharedFlowTypes != null) {
            for (TypeDeclaration sharedFlowType : sharedFlowTypes.values()) {
                FlowControllerChecker.enableNavigateTo(sharedFlowType, new MergedControllerAnnotation(sharedFlowType), this._fcInfo);
            }
        }
        this.endCheckClass(jclass);
        this._checkResultMap.put(JpfLanguageConstants.ExtraInfoKeys.flowControllerInfo, this._fcInfo);
        return this._checkResultMap;
    }

    private static void enableNavigateTo(TypeDeclaration flowControllerClass, MergedControllerAnnotation controllerAnn, FlowControllerInfo fcInfo) {
        FlowControllerChecker.enableNavigateTo(controllerAnn.getForwards(), fcInfo);
        FlowControllerChecker.enableNavigateTo(controllerAnn.getSimpleActions(), fcInfo);
        Collection<MethodDeclaration> methods = CompilerUtils.getClassMethods(flowControllerClass, null);
        for (MethodDeclaration method : methods) {
            AnnotationMirror ann = CompilerUtils.getAnnotation((Declaration)method, "Action");
            if (ann != null) {
                FlowControllerChecker.enableNavigateTo(CompilerUtils.getAnnotation(ann, "validationErrorForward", true), fcInfo);
            }
            if (ann == null) {
                ann = CompilerUtils.getAnnotation((Declaration)method, "ExceptionHandler");
            }
            if (ann == null) continue;
            FlowControllerChecker.enableNavigateTo(CompilerUtils.getAnnotationArray(ann, "forwards", true), fcInfo);
        }
    }

    private static void enableNavigateTo(Collection<AnnotationMirror> childAnnotations, FlowControllerInfo fcInfo) {
        if (childAnnotations != null) {
            for (AnnotationMirror childAnnotation : childAnnotations) {
                FlowControllerChecker.enableNavigateTo(childAnnotation, fcInfo);
            }
        }
    }

    private static void enableNavigateTo(AnnotationMirror ann, FlowControllerInfo fcInfo) {
        if (ann == null) {
            return;
        }
        String val = CompilerUtils.getEnumFieldName(ann, "navigateTo", true);
        if (val != null) {
            if (val.equals("currentPage") || val.equals("previousPage") || val.equals("page")) {
                fcInfo.enableNavigateToPage();
            } else if (val.equals("previousAction")) {
                fcInfo.enableNavigateToAction();
            }
        }
    }

    protected void endCheckClass(ClassDeclaration jclass) {
    }

    protected abstract GenStrutsApp createStrutsApp(File var1, ClassDeclaration var2) throws XmlException, IOException, NoWebInfDirectoryException;

    protected void startCheckClass(ClassDeclaration jclass) {
        File sourceFile = CompilerUtils.getOriginalFile((TypeDeclaration)jclass);
        try {
            GenStrutsApp strutsApp = null;
            File strutsConfigFile = null;
            try {
                strutsApp = this.createStrutsApp(sourceFile, jclass);
                strutsConfigFile = strutsApp.getStrutsConfigFile();
            }
            catch (XmlException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
            if (strutsConfigFile != null) {
                File parentDir = strutsConfigFile.getParentFile();
                this.getFlowControllerInfo().addReferencedFile(strutsConfigFile);
                if (!(parentDir.isDirectory() || parentDir.mkdirs() || parentDir.isDirectory())) {
                    this.getDiagnostics().addError((Declaration)jclass, "error.invalid-parent-directory", parentDir);
                }
                if (strutsConfigFile.exists() && strutsApp != null && !strutsApp.canWrite()) {
                    this.getDiagnostics().addError((Declaration)jclass, "error.struts-config-not-writable", strutsConfigFile);
                }
            }
            this.getRuntimeVersionChecker().checkRuntimeVersion("2", (Declaration)jclass, this.getDiagnostics(), "warning.runtime-version", "/WEB-INF/lib/beehive-netui-pageflow.jar");
        }
        catch (NoWebInfDirectoryException e) {
            this.getDiagnostics().addError((Declaration)jclass, "error.web-inf-not-found", sourceFile);
        }
        AnnotationMirror controllerAnnotation = CompilerUtils.getAnnotation((Declaration)jclass, "Controller");
        if (controllerAnnotation != null) {
            this._controllerGrammar.check(controllerAnnotation, null, (MemberDeclaration)jclass);
        }
        this.checkInheritedRelativePaths(jclass);
    }

    private void checkInheritedRelativePaths(ClassDeclaration jclass) {
        for (ClassType type = jclass.getSuperclass(); type != null && CompilerUtils.isAssignableFrom("org.apache.beehive.netui.pageflow.FlowController", (TypeMirror)type, this.getEnv()); type = type.getSuperclass()) {
            List<AnnotationMirror> catches;
            List<AnnotationMirror> forwards;
            TypeDeclaration decl = CompilerUtils.getDeclaration((DeclaredType)type);
            List<AnnotationMirror> simpleActions = CompilerUtils.getAnnotationArrayValue((Declaration)decl, "Controller", "simpleActions", true);
            if (simpleActions != null) {
                for (AnnotationMirror i : simpleActions) {
                    this.checkRelativePath(i, (TypeDeclaration)jclass, decl);
                    List<AnnotationMirror> conditionalForwards = CompilerUtils.getAnnotationArray(i, "conditionalForwards", true);
                    if (conditionalForwards == null) continue;
                    for (AnnotationMirror j : conditionalForwards) {
                        this.checkRelativePath(j, (TypeDeclaration)jclass, decl);
                    }
                }
            }
            if ((forwards = CompilerUtils.getAnnotationArrayValue((Declaration)decl, "Controller", "forwards", true)) != null) {
                for (AnnotationMirror i : forwards) {
                    this.checkRelativePath(i, (TypeDeclaration)jclass, decl);
                }
            }
            if ((catches = CompilerUtils.getAnnotationArrayValue((Declaration)decl, "Controller", "catches", true)) == null) continue;
            for (AnnotationMirror i : catches) {
                this.checkRelativePath(i, (TypeDeclaration)jclass, decl);
            }
        }
    }

    private void checkRelativePath(AnnotationMirror ann, TypeDeclaration jclass, TypeDeclaration baseType) {
        String path;
        AnnotationValue pathVal;
        if (ann != null && (pathVal = CompilerUtils.getAnnotationValue(ann, "path", true)) != null && !WebappPathType.relativePathExists(path = (String)pathVal.getValue(), jclass, this.getEnv())) {
            this.getDiagnostics().addWarning(pathVal, "warning.inherited-file-not-found", path, "Jpf." + ann.getAnnotationType().getDeclaration().getSimpleName(), baseType.getQualifiedName());
        }
    }

    protected void checkField(FieldDeclaration field, TypeDeclaration jclass) {
        if (CompilerUtils.typesAreEqual(jclass, field.getDeclaringType())) {
            TypeMirror type = field.getType();
            if (!CompilerUtils.hasModifier((Declaration)field, Modifier.TRANSIENT) && !CompilerUtils.hasModifier((Declaration)field, Modifier.STATIC) && type instanceof ClassType && !CompilerUtils.isAssignableFrom("java.io.Serializable", type, this.getEnv())) {
                this.getDiagnostics().addWarning((Declaration)field, "warning.nonserializable-member-data", new Object[0]);
            }
        }
    }

    protected void checkMethod(MethodDeclaration method, ClassDeclaration jclass) {
        Collection annotations = method.getAnnotationMirrors();
        for (AnnotationMirror annotation : annotations) {
            String annotationName = CompilerUtils.getDeclaration((DeclaredType)annotation.getAnnotationType()).getSimpleName();
            if (annotationName.equals("Action")) {
                this._actionGrammar.check(annotation, null, (MemberDeclaration)method);
                this.checkActionMethod(method, jclass, annotation);
                continue;
            }
            if (!annotationName.equals("ExceptionHandler")) continue;
            this._exceptionHandlerGrammar.check(annotation, null, (MemberDeclaration)method);
            this.checkExceptionHandlerMethod(method);
        }
    }

    protected void checkInnerClass(ClassDeclaration innerClass) {
        this._formBeanChecker.check(innerClass, this.getWebappRoot());
    }

    private void checkActionMethod(MethodDeclaration method, ClassDeclaration jclass, AnnotationMirror annotation) {
        FieldDeclaration memberForm;
        String formMemberName;
        if (!CompilerUtils.isAssignableFrom("org.apache.beehive.netui.pageflow.Forward", method.getReturnType(), this.getEnv())) {
            this.getDiagnostics().addError((Declaration)method, "error.method-wrong-return-type", "org.apache.beehive.netui.pageflow.Forward");
        }
        Collection parameters = method.getParameters();
        int nParameters = parameters.size();
        TypeDeclaration argTypeDecl = null;
        if (nParameters > 0) {
            TypeMirror argType = ((ParameterDeclaration)parameters.iterator().next()).getType();
            if (!(argType instanceof DeclaredType)) {
                this.getDiagnostics().addError((Declaration)method, "error.action-method-invalid-argument-type", new Object[0]);
                argType = null;
            } else {
                Boolean doValidation;
                argTypeDecl = CompilerUtils.getDeclaration((DeclaredType)argType);
                if (argTypeDecl instanceof ClassDeclaration && !CompilerUtils.hasDefaultConstructor(argTypeDecl)) {
                    this.getDiagnostics().addError((Declaration)method, "error.action-method-arg-no-default-constructor", argTypeDecl.getQualifiedName());
                }
                if (!CompilerUtils.hasModifier((Declaration)argTypeDecl, Modifier.PUBLIC)) {
                    this.getDiagnostics().addError((Declaration)method, "error.action-method-arg-not-public", argTypeDecl.getQualifiedName());
                }
                if (argTypeDecl.getDeclaringType() != null && !CompilerUtils.hasModifier((Declaration)argTypeDecl, Modifier.STATIC)) {
                    this.getDiagnostics().addError((Declaration)method, "error.action-method-arg-not-static", argTypeDecl.getQualifiedName());
                }
                if (CompilerUtils.getAnnotationValue(annotation, "validationErrorForward", true) == null && this.hasValidationAnnotations(argTypeDecl) && ((doValidation = CompilerUtils.getBoolean(annotation, "doValidation", true)) == null || doValidation.booleanValue())) {
                    this.getDiagnostics().addWarning((Declaration)method, "warning.validatable-formbean-no-forward", "Jpf.Action", "validationErrorForward", "validationErrorForward", argTypeDecl.getQualifiedName());
                }
            }
        }
        this._fcInfo.addAction(method.getSimpleName(), argTypeDecl != null ? argTypeDecl.getQualifiedName() : null);
        if (nParameters > 1) {
            this.getDiagnostics().addError((Declaration)method, "error.action-method-wrong-arg", new Object[0]);
        }
        if ((formMemberName = CompilerUtils.getStringValue((Declaration)method, "Action", "useFormBean", true)) != null && (memberForm = CompilerUtils.findField((TypeDeclaration)jclass, formMemberName)) != null) {
            String memberFormTypeName;
            TypeMirror memberFormType = memberForm.getType();
            String string = memberFormTypeName = memberFormType instanceof DeclaredType ? CompilerUtils.getDeclaration((DeclaredType)memberFormType).getQualifiedName() : memberFormType.toString();
            if (nParameters == 0) {
                this.getDiagnostics().addError((Declaration)method, "error.action-mismatched-form", "useFormBean", formMemberName, memberFormTypeName);
            } else if (!CompilerUtils.isAssignableFrom(argTypeDecl, memberForm.getType())) {
                this.getDiagnostics().addError((Declaration)method, "error.action-mismatched-form", "useFormBean", formMemberName, memberFormTypeName);
            }
        }
    }

    private boolean hasValidationAnnotations(TypeDeclaration type) {
        Collection methods = type.getMethods();
        for (MethodDeclaration method : methods) {
            Collection annotations = method.getAnnotationMirrors();
            for (AnnotationMirror ann : annotations) {
                String annotationName = CompilerUtils.getDeclaration((DeclaredType)ann.getAnnotationType()).getQualifiedName();
                int pos = annotationName.indexOf("org.apache.beehive.netui.pageflow.annotations.Jpf.");
                if (pos == -1 || !annotationName.substring(pos + "org.apache.beehive.netui.pageflow.annotations.Jpf.".length()).startsWith("Validat")) continue;
                return true;
            }
        }
        return false;
    }

    private void checkExceptionHandlerMethod(MethodDeclaration method) {
        ArrayList<ParameterDeclaration> parameters;
        if (!CompilerUtils.isAssignableFrom("org.apache.beehive.netui.pageflow.Forward", method.getReturnType(), this.getEnv())) {
            this.getDiagnostics().addError((Declaration)method, "error.method-wrong-return-type", "org.apache.beehive.netui.pageflow.Forward");
        }
        if ((parameters = new ArrayList<ParameterDeclaration>(method.getParameters())).size() == 4) {
            if (!CompilerUtils.isAssignableFrom(JpfLanguageConstants.THROWABLE_CLASS_NAME, ((ParameterDeclaration)parameters.get(0)).getType(), this.getEnv())) {
                this.getDiagnostics().addError((Declaration)method, "error.exception-method-wrong-exception-arg", JpfLanguageConstants.THROWABLE_CLASS_NAME);
            }
            this.checkExceptionHandlerArgType(method, parameters, 1, JpfLanguageConstants.STRING_CLASS_NAME);
            this.checkExceptionHandlerArgType(method, parameters, 2, JpfLanguageConstants.STRING_CLASS_NAME);
            if (CompilerUtils.isAssignableFrom("org.apache.struts.action.ActionForm", ((ParameterDeclaration)parameters.get(3)).getType(), this.getEnv())) {
                this.getDiagnostics().addWarning((Declaration)method, "warning.exception-method-deprecated-form-arg", new Object[0]);
            } else {
                this.checkExceptionHandlerArgType(method, parameters, 3, JpfLanguageConstants.OBJECT_CLASS_NAME);
            }
        } else {
            this.getDiagnostics().addError((Declaration)method, "error.exception-method-wrong-arg-count", 4);
        }
    }

    private void checkExceptionHandlerArgType(MethodDeclaration method, List<ParameterDeclaration> parameters, int index, String className) {
        if (!CompilerUtils.isOfClass(parameters.get(index).getType(), className, this.getEnv())) {
            this.getDiagnostics().addError((Declaration)method, "error.exception-method-wrong-arg-type", index + 1, className);
        }
    }

    protected FlowControllerInfo getFlowControllerInfo() {
        return this._fcInfo;
    }
}

