/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.compiler;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.MemberDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.beehive.netui.compiler.BaseChecker;
import org.apache.beehive.netui.compiler.BaseGenerator;
import org.apache.beehive.netui.compiler.CompilerUtils;
import org.apache.beehive.netui.compiler.Diagnostics;
import org.apache.beehive.netui.compiler.FacesBackingInfo;
import org.apache.beehive.netui.compiler.FlowControllerInfo;
import org.apache.beehive.netui.compiler.JpfLanguageConstants;
import org.apache.beehive.netui.compiler.grammar.CommandHandlerGrammar;

public class FacesBackingChecker
extends BaseChecker {
    private FacesBackingInfo _facesBackingInfo;

    public FacesBackingChecker(AnnotationProcessorEnvironment env, Diagnostics diags, FacesBackingInfo fbInfo) {
        super(env, diags);
        this._facesBackingInfo = fbInfo;
    }

    public BaseGenerator getGenerator() {
        return new BaseGenerator(this.getEnv()){

            public void generate(ClassDeclaration publicClass) {
            }
        };
    }

    public Map onCheck(ClassDeclaration jclass) {
        if (!CompilerUtils.isAssignableFrom("org.apache.beehive.netui.pageflow.FacesBackingBean", (TypeDeclaration)jclass, this.getEnv())) {
            this.getDiagnostics().addError((Declaration)jclass, "error.does-not-extend-base", "org.apache.beehive.netui.pageflow.FacesBackingBean");
            return null;
        }
        Collection packageClasses = jclass.getPackage().getClasses();
        ClassDeclaration jpfClass = null;
        for (ClassDeclaration classDecl : packageClasses) {
            if (!CompilerUtils.isPageFlowClass(classDecl, this.getEnv())) continue;
            jpfClass = classDecl;
        }
        FlowControllerInfo fcInfo = new FlowControllerInfo(jpfClass, this.getWebappRoot());
        fcInfo.startBuild(this.getEnv(), jpfClass);
        CommandHandlerGrammar chg = new CommandHandlerGrammar(this.getEnv(), this.getDiagnostics(), this.getRuntimeVersionChecker(), jpfClass, fcInfo);
        Collection<MethodDeclaration> methods = CompilerUtils.getClassMethods((TypeDeclaration)jclass, "CommandHandler");
        for (MethodDeclaration method : methods) {
            this._facesBackingInfo.addCommandHandler(method.getSimpleName());
            chg.check(CompilerUtils.getAnnotation((Declaration)method, "CommandHandler"), null, (MemberDeclaration)method);
        }
        HashMap<JpfLanguageConstants.ExtraInfoKeys, FacesBackingInfo> checkResultMap = new HashMap<JpfLanguageConstants.ExtraInfoKeys, FacesBackingInfo>();
        checkResultMap.put(JpfLanguageConstants.ExtraInfoKeys.facesBackingInfo, this._facesBackingInfo);
        return checkResultMap;
    }
}

