/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.compiler;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.Declaration;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class Diagnostics {
    private AnnotationProcessorEnvironment _env;
    private ResourceBundle _messages;
    private boolean _hadErrors = false;

    public Diagnostics(AnnotationProcessorEnvironment env) {
        this._env = env;
        this._messages = ResourceBundle.getBundle("org.apache.beehive.netui.compiler.diagnostics");
    }

    public void addError(Declaration decl, String messageKey, Object ... args) {
        this._env.getMessager().printError(decl.getPosition(), this.getMessage(messageKey, args));
        this._hadErrors = true;
    }

    public void addError(AnnotationMirror ann, String messageKey, Object ... args) {
        this._env.getMessager().printError(ann.getPosition(), this.getMessage(messageKey, args));
        this._hadErrors = true;
    }

    public void addErrorArrayArgs(AnnotationMirror ann, String messageKey, Object[] args) {
        this._env.getMessager().printError(ann.getPosition(), this.getMessage(messageKey, args));
        this._hadErrors = true;
    }

    public void addError(AnnotationValue annVal, String messageKey, Object ... args) {
        this._env.getMessager().printError(annVal.getPosition(), this.getMessage(messageKey, args));
        this._hadErrors = true;
    }

    public void addWarning(Declaration decl, String messageKey, Object ... args) {
        this._env.getMessager().printWarning(decl.getPosition(), this.getMessage(messageKey, args));
    }

    public void addWarning(AnnotationMirror ann, String messageKey, Object ... args) {
        this._env.getMessager().printWarning(ann.getPosition(), this.getMessage(messageKey, args));
    }

    public void addWarning(AnnotationValue annVal, String messageKey, Object ... args) {
        this._env.getMessager().printWarning(annVal.getPosition(), this.getMessage(messageKey, args));
    }

    private String getMessage(String key, Object ... args) {
        String message = this._messages.getString(key);
        return MessageFormat.format(message, args);
    }

    public boolean hadErrors() {
        return this._hadErrors;
    }
}

