/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.compiler;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.AnnotationProcessorListener;
import com.sun.mirror.apt.Filer;
import com.sun.mirror.apt.Messager;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.AnnotationTypeElementDeclaration;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.ConstructorDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.MemberDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.Modifier;
import com.sun.mirror.declaration.PackageDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.declaration.TypeParameterDeclaration;
import com.sun.mirror.type.ArrayType;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.type.ReferenceType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.util.DeclarationVisitor;
import com.sun.mirror.util.Declarations;
import com.sun.mirror.util.SourcePosition;
import com.sun.mirror.util.Types;
import java.io.File;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.beehive.netui.compiler.JpfLanguageConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilerUtils
implements JpfLanguageConstants {
    private static final ErrorTypeDeclaration ERROR_TYPE_DECLARATION = new ErrorTypeDeclaration();

    public static boolean isJpfAnnotation(AnnotationMirror annotation, String unqualifiedName) {
        String annotationName = CompilerUtils.getDeclaration((DeclaredType)annotation.getAnnotationType()).getQualifiedName();
        return annotationName.equals("org.apache.beehive.netui.pageflow.annotations.Jpf." + unqualifiedName);
    }

    public static AnnotationMirror getAnnotation(Declaration element, String unqualifiedName) {
        Collection annotations = element.getAnnotationMirrors();
        unqualifiedName = "org.apache.beehive.netui.pageflow.annotations.Jpf." + unqualifiedName;
        for (AnnotationMirror i : annotations) {
            String iName = CompilerUtils.getDeclaration((DeclaredType)i.getAnnotationType()).getQualifiedName();
            if (!unqualifiedName.equals(iName)) continue;
            return i;
        }
        return null;
    }

    public static AnnotationValue getAnnotationValue(Declaration element, String annotationName, String valueName) {
        AnnotationMirror ann = CompilerUtils.getAnnotation(element, annotationName);
        return ann != null ? CompilerUtils.getAnnotationValue(ann, valueName, true) : null;
    }

    private static AnnotationValue assertAnnotationValue(Declaration element, String annotationName, String valueName, boolean defaultIsNull) {
        AnnotationMirror ann = CompilerUtils.getAnnotation(element, annotationName);
        if (ann == null) {
            return null;
        }
        return CompilerUtils.getAnnotationValue(ann, valueName, defaultIsNull);
    }

    public static String getStringValue(Declaration element, String annotationName, String memberName, boolean defaultIsNull) {
        return (String)CompilerUtils.getValue(element, annotationName, memberName, defaultIsNull);
    }

    public static AnnotationValue getAnnotationValue(AnnotationMirror annotation, String memberName, boolean defaultIsNull) {
        Map valuesPresent = annotation.getElementValues();
        for (Map.Entry i : valuesPresent.entrySet()) {
            if (!memberName.equals(((AnnotationTypeElementDeclaration)i.getKey()).getSimpleName())) continue;
            return (AnnotationValue)i.getValue();
        }
        if (defaultIsNull) {
            return null;
        }
        AnnotationTypeDeclaration typeDecl = annotation.getAnnotationType().getDeclaration();
        if (typeDecl == null) {
            return null;
        }
        for (AnnotationTypeElementDeclaration j : typeDecl.getMethods()) {
            if (!memberName.equals(j.getSimpleName())) continue;
            return j.getDefaultValue();
        }
        assert (false) : "Member " + memberName + " not found on annotation type " + CompilerUtils.getQualifiedName(annotation);
        return null;
    }

    public static List<String> getStringArrayValue(Declaration element, String annotationName, String memberName, boolean defaultIsNull) {
        AnnotationValue value = CompilerUtils.assertAnnotationValue(element, annotationName, memberName, defaultIsNull);
        if (value == null) {
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>();
        CompilerUtils.getValues(value, ret, false);
        return ret;
    }

    public static Boolean getBooleanValue(Declaration element, String annotationName, String memberName, boolean defaultIsNull) {
        AnnotationValue value = CompilerUtils.assertAnnotationValue(element, annotationName, memberName, defaultIsNull);
        return value != null ? (Boolean)value.getValue() : null;
    }

    public static String getString(AnnotationMirror annotation, String memberName, boolean defaultIsNull) {
        AnnotationValue value = CompilerUtils.getAnnotationValue(annotation, memberName, defaultIsNull);
        return value != null ? (String)value.getValue() : (defaultIsNull ? null : "");
    }

    public static TypeMirror getTypeMirror(AnnotationMirror annotation, String memberName, boolean defaultIsNull) {
        AnnotationValue value = CompilerUtils.getAnnotationValue(annotation, memberName, defaultIsNull);
        return value != null ? (TypeMirror)value.getValue() : null;
    }

    public static String getEnumFieldName(AnnotationMirror annotation, String memberName, boolean defaultIsNull) {
        AnnotationValue value = CompilerUtils.getAnnotationValue(annotation, memberName, defaultIsNull);
        return value != null ? CompilerUtils.getEnumFieldName(value) : null;
    }

    public static List<String> getStringArray(AnnotationMirror annotation, String memberName, boolean defaultIsNull) {
        AnnotationValue value = CompilerUtils.getAnnotationValue(annotation, memberName, defaultIsNull);
        if (value == null) {
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>();
        CompilerUtils.getValues(value, ret, false);
        return ret;
    }

    public static DeclaredType getDeclaredType(AnnotationMirror annotation, String memberName, boolean defaultIsNull) {
        AnnotationValue value = CompilerUtils.getAnnotationValue(annotation, memberName, defaultIsNull);
        return value != null ? (DeclaredType)value.getValue() : null;
    }

    public static ReferenceType getReferenceType(AnnotationMirror annotation, String memberName, boolean defaultIsNull) {
        AnnotationValue value = CompilerUtils.getAnnotationValue(annotation, memberName, defaultIsNull);
        return value != null ? (ReferenceType)value.getValue() : null;
    }

    public static Integer getInteger(AnnotationMirror annotation, String memberName, boolean defaultIsNull) {
        AnnotationValue value = CompilerUtils.getAnnotationValue(annotation, memberName, defaultIsNull);
        return value != null ? (Integer)value.getValue() : (defaultIsNull ? null : new Integer(0));
    }

    public static Float getFloat(AnnotationMirror annotation, String memberName, boolean defaultIsNull) {
        AnnotationValue value = CompilerUtils.getAnnotationValue(annotation, memberName, defaultIsNull);
        return value != null ? (Float)value.getValue() : (defaultIsNull ? null : new Float(0.0f));
    }

    public static Double getDouble(AnnotationMirror annotation, String memberName, boolean defaultIsNull) {
        AnnotationValue value = CompilerUtils.getAnnotationValue(annotation, memberName, defaultIsNull);
        return value != null ? (Double)value.getValue() : (defaultIsNull ? null : new Double(0.0));
    }

    public static Boolean getBoolean(AnnotationMirror annotation, String memberName, boolean defaultIsNull) {
        AnnotationValue value = CompilerUtils.getAnnotationValue(annotation, memberName, defaultIsNull);
        return value != null ? (Boolean)value.getValue() : (defaultIsNull ? null : Boolean.FALSE);
    }

    public static Object getValue(Declaration element, String annotationName, String memberName, boolean defaultIsNull) {
        AnnotationValue value = CompilerUtils.assertAnnotationValue(element, annotationName, memberName, defaultIsNull);
        return value != null ? value.getValue() : null;
    }

    public static List<AnnotationMirror> getAnnotationArrayValue(Declaration element, String annotationName, String memberName, boolean defaultIsNull) {
        AnnotationValue value = CompilerUtils.assertAnnotationValue(element, annotationName, memberName, defaultIsNull);
        if (value == null) {
            return null;
        }
        ArrayList<AnnotationMirror> ret = new ArrayList<AnnotationMirror>();
        CompilerUtils.getValues(value, ret, true);
        return ret;
    }

    public static List<AnnotationMirror> getAnnotationArray(AnnotationMirror annotation, String memberName, boolean defaultIsNull) {
        AnnotationValue value = CompilerUtils.getAnnotationValue(annotation, memberName, defaultIsNull);
        return CompilerUtils.getAnnotationArray(value);
    }

    public static List<AnnotationMirror> getAnnotationArray(AnnotationValue value) {
        if (value == null) {
            return null;
        }
        ArrayList<AnnotationMirror> ret = new ArrayList<AnnotationMirror>();
        CompilerUtils.getValues(value, ret, true);
        return ret;
    }

    private static void getValues(AnnotationValue arrayValue, List translatedValues, boolean weedOutErrorType) {
        List values = (List)arrayValue.getValue();
        for (Object i : values) {
            Object value;
            Object object = value = i instanceof AnnotationValue ? ((AnnotationValue)i).getValue() : i;
            if (weedOutErrorType && "<error>".equals(value)) continue;
            translatedValues.add(value);
        }
    }

    public static String getQualifiedName(AnnotationMirror annotation) {
        return CompilerUtils.getDeclaration((DeclaredType)annotation.getAnnotationType()).getQualifiedName();
    }

    public static String getSimpleName(AnnotationMirror annotation) {
        return CompilerUtils.getDeclaration((DeclaredType)annotation.getAnnotationType()).getSimpleName();
    }

    public static AnnotationMirror getAnnotation(AnnotationMirror annotation, String memberName, boolean defaultIsNull) {
        AnnotationValue value = CompilerUtils.getAnnotationValue(annotation, memberName, defaultIsNull);
        return value != null ? (AnnotationMirror)value.getValue() : null;
    }

    public static boolean hasModifier(Declaration decl, Modifier modifier) {
        for (Modifier i : decl.getModifiers()) {
            if (!i.equals((Object)modifier)) continue;
            return true;
        }
        return false;
    }

    public static MethodDeclaration getClassMethod(TypeDeclaration jclass, String methodName, String desiredAnnotation) {
        return CompilerUtils.getClassMethod(jclass, methodName, desiredAnnotation, false);
    }

    private static MethodDeclaration getClassMethod(TypeDeclaration type, String methodName, String desiredAnnotation, boolean onlyPublicOrProtected) {
        if (!(type instanceof ClassDeclaration)) {
            return null;
        }
        ClassDeclaration jclass = (ClassDeclaration)type;
        Collection methods = jclass.getMethods();
        for (MethodDeclaration method : methods) {
            if (onlyPublicOrProtected && !CompilerUtils.hasModifier((Declaration)method, Modifier.PROTECTED) && !CompilerUtils.hasModifier((Declaration)method, Modifier.PUBLIC) || !methodName.equals(method.getSimpleName()) || desiredAnnotation != null && CompilerUtils.getAnnotation((Declaration)method, desiredAnnotation) == null) continue;
            return method;
        }
        ClassType superclass = jclass.getSuperclass();
        if (superclass != null) {
            return CompilerUtils.getClassMethod(CompilerUtils.getDeclaration((DeclaredType)superclass), methodName, desiredAnnotation, true);
        }
        return null;
    }

    public static FieldDeclaration getClassField(TypeDeclaration jclass, String fieldName, String desiredAnnotation) {
        return CompilerUtils.getClassField(jclass, fieldName, desiredAnnotation, false);
    }

    private static FieldDeclaration getClassField(TypeDeclaration type, String fieldName, String desiredAnnotation, boolean onlyPublicOrProtected) {
        if (!(type instanceof ClassDeclaration)) {
            return null;
        }
        ClassDeclaration jclass = (ClassDeclaration)type;
        Collection fields = jclass.getFields();
        for (FieldDeclaration field : fields) {
            if (onlyPublicOrProtected && !CompilerUtils.hasModifier((Declaration)field, Modifier.PROTECTED) && !CompilerUtils.hasModifier((Declaration)field, Modifier.PUBLIC) || !fieldName.equals(field.getSimpleName()) || desiredAnnotation != null && CompilerUtils.getAnnotation((Declaration)field, desiredAnnotation) == null) continue;
            return field;
        }
        ClassType superclass = jclass.getSuperclass();
        if (superclass != null) {
            return CompilerUtils.getClassField(CompilerUtils.getDeclaration((DeclaredType)superclass), fieldName, desiredAnnotation, true);
        }
        return null;
    }

    public static Collection<MethodDeclaration> getClassMethods(TypeDeclaration jclass, String desiredAnnotation) {
        ArrayList<MethodDeclaration> results = new ArrayList<MethodDeclaration>();
        CompilerUtils.getClassMethods(jclass, desiredAnnotation, false, results);
        return results;
    }

    private static void getClassMethods(TypeDeclaration type, String desiredAnnotation, boolean onlyPublicOrPrivate, Collection<MethodDeclaration> results) {
        if (!(type instanceof ClassDeclaration)) {
            return;
        }
        ClassDeclaration jclass = (ClassDeclaration)type;
        Collection methods = jclass.getMethods();
        for (MethodDeclaration method : methods) {
            if (onlyPublicOrPrivate && !CompilerUtils.hasModifier((Declaration)method, Modifier.PROTECTED) && !CompilerUtils.hasModifier((Declaration)method, Modifier.PUBLIC) || desiredAnnotation != null && CompilerUtils.getAnnotation((Declaration)method, desiredAnnotation) == null) continue;
            results.add(method);
        }
        ClassType superclass = jclass.getSuperclass();
        if (superclass != null) {
            CompilerUtils.getClassMethods(CompilerUtils.getDeclaration((DeclaredType)superclass), desiredAnnotation, true, results);
        }
    }

    public static Collection<FieldDeclaration> getClassFields(TypeDeclaration jclass) {
        ArrayList<FieldDeclaration> results = new ArrayList<FieldDeclaration>();
        CompilerUtils.getClassFields(jclass, false, results);
        return results;
    }

    private static void getClassFields(TypeDeclaration type, boolean onlyPublicOrPrivate, Collection<FieldDeclaration> results) {
        if (!(type instanceof ClassDeclaration)) {
            return;
        }
        ClassDeclaration jclass = (ClassDeclaration)type;
        Collection fields = jclass.getFields();
        for (FieldDeclaration field : fields) {
            if (onlyPublicOrPrivate && !CompilerUtils.hasModifier((Declaration)field, Modifier.PROTECTED) && !CompilerUtils.hasModifier((Declaration)field, Modifier.PUBLIC)) continue;
            results.add(field);
        }
        ClassType superclass = jclass.getSuperclass();
        if (superclass != null) {
            CompilerUtils.getClassFields(CompilerUtils.getDeclaration((DeclaredType)superclass), true, results);
        }
    }

    public static Collection<TypeDeclaration> getClassNestedTypes(TypeDeclaration jclass) {
        ArrayList<TypeDeclaration> results = new ArrayList<TypeDeclaration>();
        CompilerUtils.getClassNestedTypes(jclass, false, results);
        return results;
    }

    private static void getClassNestedTypes(TypeDeclaration type, boolean onlyPublicOrPrivate, Collection<TypeDeclaration> results) {
        if (!(type instanceof ClassDeclaration)) {
            return;
        }
        ClassDeclaration jclass = (ClassDeclaration)type;
        Collection nestedTypes = jclass.getNestedTypes();
        for (TypeDeclaration nestedType : nestedTypes) {
            if (onlyPublicOrPrivate && !CompilerUtils.hasModifier((Declaration)nestedType, Modifier.PROTECTED) && !CompilerUtils.hasModifier((Declaration)nestedType, Modifier.PUBLIC)) continue;
            results.add(nestedType);
        }
        ClassType superclass = jclass.getSuperclass();
        if (superclass != null) {
            CompilerUtils.getClassNestedTypes(CompilerUtils.getDeclaration((DeclaredType)superclass), true, results);
        }
    }

    public static String getFormClassName(TypeDeclaration jclass, AnnotationProcessorEnvironment env) {
        if (CompilerUtils.isAssignableFrom("org.apache.struts.action.ActionForm", jclass, env)) {
            return CompilerUtils.getLoadableName(jclass);
        }
        if (CompilerUtils.isAssignableFrom("com.bea.xml.XmlObject", jclass, env)) {
            return "org.apache.beehive.netui.pageflow.internal.XmlBeanActionForm";
        }
        if (CompilerUtils.isAssignableFrom("org.apache.xmlbeans.XmlObject", jclass, env)) {
            return "org.apache.beehive.netui.pageflow.internal.XmlBeanActionForm";
        }
        return "org.apache.beehive.netui.pageflow.internal.AnyBeanActionForm";
    }

    public static String getFormClassName(DeclaredType jclass, AnnotationProcessorEnvironment env) {
        return CompilerUtils.getFormClassName(CompilerUtils.getDeclaration(jclass), env);
    }

    public static boolean isAbsoluteURL(String path) {
        try {
            return new URI(path).getScheme() != null;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    public static boolean isAssignableFrom(String className, TypeMirror type, AnnotationProcessorEnvironment env) {
        if (!(type instanceof DeclaredType)) {
            return false;
        }
        return CompilerUtils.isAssignableFrom(className, CompilerUtils.getDeclaration((DeclaredType)type), env);
    }

    public static boolean isAssignableFrom(TypeDeclaration base, TypeDeclaration typeDecl) {
        if (base != null && typeDecl != null) {
            ClassType superclass;
            if (CompilerUtils.typesAreEqual(typeDecl, base)) {
                return true;
            }
            if (typeDecl instanceof ClassDeclaration && (superclass = ((ClassDeclaration)typeDecl).getSuperclass()) != null && CompilerUtils.isAssignableFrom(base, CompilerUtils.getDeclaration((DeclaredType)superclass))) {
                return true;
            }
            Collection superInterfaces = typeDecl.getSuperinterfaces();
            for (InterfaceType superInterface : superInterfaces) {
                if (!CompilerUtils.isAssignableFrom(base, CompilerUtils.getDeclaration((DeclaredType)superInterface))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isAssignableFrom(TypeMirror base, TypeDeclaration cl) {
        if (!(base instanceof DeclaredType)) {
            return false;
        }
        return CompilerUtils.isAssignableFrom(CompilerUtils.getDeclaration((DeclaredType)base), cl);
    }

    public static boolean isAssignableFrom(TypeDeclaration base, TypeMirror cl) {
        if (!(cl instanceof DeclaredType)) {
            return false;
        }
        return CompilerUtils.isAssignableFrom(base, CompilerUtils.getDeclaration((DeclaredType)cl));
    }

    public static boolean isAssignableFrom(String className, TypeDeclaration cl, AnnotationProcessorEnvironment env) {
        TypeDeclaration base = env.getTypeDeclaration(className);
        return CompilerUtils.isAssignableFrom(base, cl);
    }

    public static boolean isOfClass(TypeMirror type, String className, AnnotationProcessorEnvironment env) {
        if (!(type instanceof DeclaredType)) {
            return false;
        }
        return CompilerUtils.typesAreEqual(CompilerUtils.getDeclaration((DeclaredType)type), env.getTypeDeclaration(className));
    }

    public static boolean typesAreEqual(TypeDeclaration t1, TypeDeclaration t2) {
        assert (t1 != null);
        if (t2 == null) {
            return false;
        }
        return t1.getQualifiedName().equals(t2.getQualifiedName());
    }

    public static TypeDeclaration getOuterClass(MemberDeclaration classMember) {
        return classMember instanceof ClassDeclaration ? (ClassDeclaration)classMember : classMember.getDeclaringType();
    }

    public static TypeDeclaration getOutermostClass(MemberDeclaration classMember) {
        TypeDeclaration containingClass;
        while ((containingClass = classMember.getDeclaringType()) != null) {
            classMember = containingClass;
        }
        assert (classMember instanceof ClassDeclaration) : classMember.getClass().getName();
        return (ClassDeclaration)classMember;
    }

    public static boolean hasDefaultConstructor(TypeDeclaration jclass) {
        if (!(jclass instanceof ClassDeclaration)) {
            return false;
        }
        Collection constructors = ((ClassDeclaration)jclass).getConstructors();
        for (ConstructorDeclaration ctor : constructors) {
            if (ctor.getParameters().size() != 0) continue;
            return true;
        }
        return false;
    }

    private static Declaration findElement(Collection elements, String elementName) {
        for (Object element : elements) {
            Declaration decl = (Declaration)element;
            if (!decl.getSimpleName().equals(elementName)) continue;
            return decl;
        }
        return null;
    }

    public static FieldDeclaration findField(TypeDeclaration jclass, String fieldName) {
        return (FieldDeclaration)CompilerUtils.findElement(CompilerUtils.getClassFields(jclass), fieldName);
    }

    public static ClassDeclaration findInnerClass(TypeDeclaration jclass, String innerClassName) {
        return (ClassDeclaration)CompilerUtils.findElement(CompilerUtils.getClassNestedTypes(jclass), innerClassName);
    }

    public static String getEnumFieldName(AnnotationValue enumMember) {
        if (enumMember == null || enumMember.getValue() == null) {
            return "";
        }
        return enumMember.getValue().toString();
    }

    public static String getLoadableName(TypeDeclaration jclass) {
        TypeDeclaration containingClass = jclass.getDeclaringType();
        if (containingClass == null) {
            return jclass.getQualifiedName();
        }
        return CompilerUtils.getLoadableName(containingClass) + '$' + jclass.getSimpleName();
    }

    public static String getLoadableName(DeclaredType jclass) {
        return CompilerUtils.getLoadableName(CompilerUtils.getDeclaration(jclass));
    }

    public static File getOriginalFile(TypeDeclaration decl) {
        decl = CompilerUtils.getOutermostClass((MemberDeclaration)decl);
        SourcePosition position = decl.getPosition();
        File retVal = null;
        if (position != null) {
            File file = position.file();
            String path = file.getAbsoluteFile().getPath();
            int pos = path.indexOf(TMP_SRC_DIR);
            if (pos != -1) {
                String webappRootPath = path.substring(0, pos - 1);
                if (decl.getQualifiedName().equals("global.Global")) {
                    StringBuilder sb = new StringBuilder(webappRootPath);
                    sb.append("/WEB-INF/src").append('/');
                    sb.append("global").append('/');
                    sb.append("Global");
                    String basePath = sb.toString();
                    retVal = new File(basePath + ".app");
                    if (!retVal.exists()) {
                        retVal = new File(basePath + ".java");
                    }
                } else {
                    String fileRelativePath = path.substring(pos + TMP_SRC_DIR.length());
                    retVal = CompilerUtils.findSourceFileInWebapp(webappRootPath, fileRelativePath);
                }
            } else {
                retVal = new File(path);
            }
        }
        return retVal;
    }

    public static File findSourceFileInWebapp(String webappRootPath, String fileRelativePath) {
        int extensionPos = fileRelativePath.lastIndexOf(".java");
        assert (extensionPos != -1) : "expected a .java file: " + fileRelativePath;
        File retVal = new File((webappRootPath = webappRootPath + File.separatorChar) + fileRelativePath);
        if (!retVal.exists()) {
            fileRelativePath = fileRelativePath.substring(0, extensionPos);
            retVal = CompilerUtils.getSourceFile(webappRootPath + fileRelativePath);
            if (retVal == null) {
                StringBuilder retValPath = new StringBuilder(webappRootPath);
                retValPath.append("WEB-INF").append(File.separatorChar);
                retValPath.append("src").append(File.separatorChar);
                retValPath.append(fileRelativePath);
                retVal = CompilerUtils.getSourceFile(retValPath.toString());
            }
        }
        assert (retVal != null) : "could not find original file for " + fileRelativePath;
        return retVal.exists() ? retVal.getAbsoluteFile() : null;
    }

    private static File getSourceFile(String base) {
        File file = new File(base + ".java");
        if (file.exists()) {
            return file;
        }
        file = new File(base + ".jpf");
        if (file.exists()) {
            return file;
        }
        file = new File(base + ".jpfs");
        if (file.exists()) {
            return file;
        }
        file = new File(base + ".jsfb");
        if (file.exists()) {
            return file;
        }
        return null;
    }

    public static boolean annotationsAreEqual(AnnotationMirror a1, AnnotationMirror a2, boolean allowExactDuplicates, AnnotationProcessorEnvironment env) {
        assert (a1 != null);
        if (a2 == null) {
            return false;
        }
        if (!allowExactDuplicates && env instanceof ExtendedAnnotationProcessorEnvironment && ((ExtendedAnnotationProcessorEnvironment)env).useEqualsToCompareAnnotations()) {
            return a1.equals(a2);
        }
        Map vals1 = a1.getElementValues();
        Map vals2 = a2.getElementValues();
        if (vals1.size() != vals2.size()) {
            return false;
        }
        Iterator ents1 = vals1.entrySet().iterator();
        Iterator ents2 = vals2.entrySet().iterator();
        while (ents1.hasNext()) {
            Map.Entry entry1 = ents1.next();
            Map.Entry entry2 = ents2.next();
            if (!((AnnotationTypeElementDeclaration)entry1.getKey()).getSimpleName().equals(((AnnotationTypeElementDeclaration)entry2.getKey()).getSimpleName())) {
                return false;
            }
            Object val1 = ((AnnotationValue)entry1.getValue()).getValue();
            Object val2 = ((AnnotationValue)entry2.getValue()).getValue();
            if (val1 instanceof Collection) {
                if (!(val2 instanceof Collection)) {
                    return false;
                }
                Collection list1 = (Collection)val1;
                Collection list2 = (Collection)val2;
                if (list1.size() != list2.size()) {
                    return false;
                }
                Iterator j1 = list1.iterator();
                Iterator j2 = list2.iterator();
                while (j1.hasNext()) {
                    Object o1 = ((AnnotationValue)j1.next()).getValue();
                    Object o2 = ((AnnotationValue)j2.next()).getValue();
                    if (o1 instanceof AnnotationMirror) {
                        if (!(o2 instanceof AnnotationMirror)) {
                            return false;
                        }
                        if (CompilerUtils.annotationsAreEqual((AnnotationMirror)o1, (AnnotationMirror)o2, allowExactDuplicates, env)) continue;
                        return false;
                    }
                    if (o1.equals(o2)) continue;
                    return false;
                }
                continue;
            }
            if (val1 instanceof AnnotationMirror) {
                if (!(val2 instanceof AnnotationMirror)) {
                    return false;
                }
                if (CompilerUtils.annotationsAreEqual((AnnotationMirror)val1, (AnnotationMirror)val2, allowExactDuplicates, env)) continue;
                return false;
            }
            if (val1.equals(val2)) continue;
            return false;
        }
        return true;
    }

    public static BeanPropertyDeclaration getBeanProperty(MethodDeclaration method) {
        String returnType;
        if (CompilerUtils.hasModifier((Declaration)method, Modifier.PUBLIC) && !CompilerUtils.hasModifier((Declaration)method, Modifier.STATIC) && !(returnType = method.getReturnType().toString()).equals("void") && method.getParameters().size() == 0) {
            String methodName = method.getSimpleName();
            String propertyName = null;
            if (methodName.startsWith("get") && methodName.length() > "get".length()) {
                propertyName = methodName.substring("get".length());
            } else if (methodName.startsWith("is") && returnType.equals("boolean") && methodName.length() > "is".length()) {
                propertyName = methodName.substring("is".length());
            }
            if (propertyName != null) {
                if (propertyName.length() == 1) {
                    propertyName = propertyName.toLowerCase();
                } else if (!Character.isUpperCase(propertyName.charAt(1))) {
                    propertyName = Character.toLowerCase(propertyName.charAt(0)) + propertyName.substring(1);
                }
                return new BeanPropertyDeclaration(propertyName, returnType, method);
            }
        }
        return null;
    }

    public static Collection<BeanPropertyDeclaration> getBeanProperties(ClassDeclaration type, boolean getInheritedProperties) {
        Collection<MethodDeclaration> methods = getInheritedProperties ? CompilerUtils.getClassMethods((TypeDeclaration)type, null) : type.getMethods();
        ArrayList<BeanPropertyDeclaration> ret = new ArrayList<BeanPropertyDeclaration>();
        for (MethodDeclaration method : methods) {
            BeanPropertyDeclaration bpd;
            if (!CompilerUtils.hasModifier((Declaration)method, Modifier.PUBLIC) || (bpd = CompilerUtils.getBeanProperty(method)) == null) continue;
            ret.add(bpd);
        }
        return ret;
    }

    public static boolean isPageFlowClass(ClassDeclaration jclass, AnnotationProcessorEnvironment env) {
        return CompilerUtils.getAnnotation((Declaration)jclass, "Controller") != null && CompilerUtils.isAssignableFrom("org.apache.beehive.netui.pageflow.PageFlowController", (TypeDeclaration)jclass, env);
    }

    public static String removeFileExtension(String uri) {
        int lastDot = uri.lastIndexOf(46);
        return uri.substring(0, lastDot);
    }

    public static TypeDeclaration inferTypeFromFile(File file, String webappRoot, AnnotationProcessorEnvironment env) {
        assert (file.getPath().startsWith(webappRoot)) : file + ", " + webappRoot;
        return CompilerUtils.inferTypeFromPath(file.getPath().substring(webappRoot.length()).replace(File.separatorChar, '/'), env);
    }

    public static TypeDeclaration inferTypeFromPath(String pathFromWebappRoot, AnnotationProcessorEnvironment env) {
        assert (pathFromWebappRoot.startsWith("/")) : pathFromWebappRoot;
        String className = CompilerUtils.removeFileExtension(pathFromWebappRoot.substring(1));
        return env.getTypeDeclaration(className.replace('/', '.'));
    }

    public static TypeDeclaration getDeclaration(DeclaredType type) {
        TypeDeclaration typeDecl = type.getDeclaration();
        return typeDecl != null ? typeDecl : ERROR_TYPE_DECLARATION;
    }

    public static boolean isAbsoluteURI(String uri) {
        if (uri.length() == 0 || uri.charAt(0) == '/') {
            return false;
        }
        int len = uri.length();
        for (int i = 0; i < len; ++i) {
            char c = uri.charAt(i);
            if (c == ':') {
                return true;
            }
            if (c != '/') continue;
            return false;
        }
        return false;
    }

    public static TypeMirror getArrayBaseType(ArrayType arrayType) {
        ArrayType baseType = arrayType;
        while ((baseType = baseType.getComponentType()) instanceof ArrayType) {
        }
        return baseType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Mutable<T> {
        private T _val = null;

        public Mutable() {
        }

        public Mutable(T val) {
            this._val = val;
        }

        public void set(T val) {
            this._val = val;
        }

        public T get() {
            return this._val;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ErrorTypeDeclaration
    implements TypeDeclaration {
        private ErrorTypeDeclaration() {
        }

        public PackageDeclaration getPackage() {
            throw new IllegalStateException("not implemented ");
        }

        public String getQualifiedName() {
            return "<error>";
        }

        public Collection<TypeParameterDeclaration> getFormalTypeParameters() {
            return Collections.emptyList();
        }

        public Collection<InterfaceType> getSuperinterfaces() {
            return Collections.emptyList();
        }

        public Collection<FieldDeclaration> getFields() {
            return Collections.emptyList();
        }

        public Collection<? extends MethodDeclaration> getMethods() {
            return Collections.emptyList();
        }

        public Collection<TypeDeclaration> getNestedTypes() {
            return Collections.emptyList();
        }

        public TypeDeclaration getDeclaringType() {
            return null;
        }

        public String getDocComment() {
            throw new IllegalStateException("not implemented ");
        }

        public Collection<AnnotationMirror> getAnnotationMirrors() {
            return Collections.emptyList();
        }

        public <A extends Annotation> A getAnnotation(Class<A> aClass) {
            throw new IllegalStateException("not implemented ");
        }

        public Collection<Modifier> getModifiers() {
            return Collections.emptyList();
        }

        public String getSimpleName() {
            return this.getQualifiedName();
        }

        public SourcePosition getPosition() {
            throw new IllegalStateException("not implemented ");
        }

        public void accept(DeclarationVisitor declarationVisitor) {
            throw new IllegalStateException("not implemented ");
        }
    }

    public static class BeanPropertyDeclaration
    extends BeanPropertyDescriptor {
        private MethodDeclaration _getter;

        public BeanPropertyDeclaration(String propertyName, String type, MethodDeclaration getter) {
            super(propertyName, type);
            this._getter = getter;
        }

        public MethodDeclaration getGetter() {
            return this._getter;
        }
    }

    public static class BeanPropertyDescriptor {
        private String _propertyName;
        private String _type;

        public BeanPropertyDescriptor(String propertyName, String type) {
            this._propertyName = propertyName;
            this._type = type;
        }

        public String getPropertyName() {
            return this._propertyName;
        }

        public String getType() {
            return this._type;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExtendedAnnotationProcessorEnvironment
    implements AnnotationProcessorEnvironment {
        private AnnotationProcessorEnvironment _env;
        private boolean _useEqualsToCompareAnnotations;

        public ExtendedAnnotationProcessorEnvironment(AnnotationProcessorEnvironment env, boolean useEqualsToCompareAnnotations) {
            this._env = env;
            this._useEqualsToCompareAnnotations = useEqualsToCompareAnnotations;
        }

        public boolean useEqualsToCompareAnnotations() {
            return this._useEqualsToCompareAnnotations;
        }

        public Map<String, String> getOptions() {
            return this._env.getOptions();
        }

        public Messager getMessager() {
            return this._env.getMessager();
        }

        public Filer getFiler() {
            return this._env.getFiler();
        }

        public Collection<TypeDeclaration> getSpecifiedTypeDeclarations() {
            return this._env.getSpecifiedTypeDeclarations();
        }

        public PackageDeclaration getPackage(String s) {
            return this._env.getPackage(s);
        }

        public TypeDeclaration getTypeDeclaration(String s) {
            return this._env.getTypeDeclaration(s);
        }

        public Collection<TypeDeclaration> getTypeDeclarations() {
            return this._env.getTypeDeclarations();
        }

        public Collection<Declaration> getDeclarationsAnnotatedWith(AnnotationTypeDeclaration annotationTypeDeclaration) {
            return this._env.getDeclarationsAnnotatedWith(annotationTypeDeclaration);
        }

        public Declarations getDeclarationUtils() {
            return this._env.getDeclarationUtils();
        }

        public Types getTypeUtils() {
            return this._env.getTypeUtils();
        }

        public void addListener(AnnotationProcessorListener annotationProcessorListener) {
            this._env.addListener(annotationProcessorListener);
        }

        public void removeListener(AnnotationProcessorListener annotationProcessorListener) {
            this._env.removeListener(annotationProcessorListener);
        }
    }
}

