/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.compiler;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.TypeDeclaration;
import java.io.File;
import java.util.Map;
import org.apache.beehive.netui.compiler.BaseGenerator;
import org.apache.beehive.netui.compiler.CompilerUtils;
import org.apache.beehive.netui.compiler.Diagnostics;
import org.apache.beehive.netui.compiler.RuntimeVersionChecker;
import org.apache.beehive.netui.compiler.model.NoWebInfDirectoryException;
import org.apache.beehive.netui.compiler.model.StrutsApp;

public abstract class BaseChecker {
    private AnnotationProcessorEnvironment _env;
    private Diagnostics _diagnostics;
    private RuntimeVersionChecker _runtimeVersionChecker;
    private File _webappRoot = null;

    protected BaseChecker(AnnotationProcessorEnvironment env, Diagnostics diagnostics) {
        this._env = env;
        this._diagnostics = diagnostics;
    }

    Map check(ClassDeclaration jclass, File webappRoot) {
        this._webappRoot = webappRoot;
        this.setRuntimeVersionChecker(new RuntimeVersionChecker(this._webappRoot));
        return this.onCheck(jclass);
    }

    public final Map check(ClassDeclaration jclass) {
        File webappRoot;
        File sourceFile = CompilerUtils.getOriginalFile((TypeDeclaration)jclass);
        assert (sourceFile != null) : "could not get source file for " + jclass.getQualifiedName();
        try {
            webappRoot = StrutsApp.getWebappRootFromJpf(sourceFile);
        }
        catch (NoWebInfDirectoryException e) {
            this.getDiagnostics().addError((Declaration)jclass, "error.web-inf-not-found", sourceFile);
            return null;
        }
        return this.check(jclass, webappRoot);
    }

    public abstract Map onCheck(ClassDeclaration var1);

    public abstract BaseGenerator getGenerator();

    protected AnnotationProcessorEnvironment getEnv() {
        return this._env;
    }

    protected Diagnostics getDiagnostics() {
        return this._diagnostics;
    }

    protected RuntimeVersionChecker getRuntimeVersionChecker() {
        return this._runtimeVersionChecker;
    }

    protected void setRuntimeVersionChecker(RuntimeVersionChecker runtimeVersionChecker) {
        this._runtimeVersionChecker = runtimeVersionChecker;
    }

    protected File getWebappRoot() {
        return this._webappRoot;
    }
}

