/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.netui.compiler;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeElementDeclaration;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.MemberDeclaration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.beehive.netui.compiler.AnnotationMemberType;
import org.apache.beehive.netui.compiler.CompilerUtils;
import org.apache.beehive.netui.compiler.Diagnostics;
import org.apache.beehive.netui.compiler.RuntimeVersionChecker;

public abstract class AnnotationGrammar {
    private String _requiredRuntimeVersion = null;
    private RuntimeVersionChecker _runtimeVersionChecker;
    private AnnotationProcessorEnvironment _env;
    private Diagnostics _diagnostics;
    private Map _memberGrammars = new HashMap();
    private Map _memberArrayGrammars = new HashMap();
    private Map _memberTypes = new HashMap();

    protected AnnotationGrammar(AnnotationProcessorEnvironment env, Diagnostics diags, String requiredRuntimeVersion, RuntimeVersionChecker runtimeVersionChecker) {
        this._env = env;
        this._diagnostics = diags;
        this._runtimeVersionChecker = runtimeVersionChecker;
        this._requiredRuntimeVersion = requiredRuntimeVersion;
    }

    public AnnotationProcessorEnvironment getEnv() {
        return this._env;
    }

    public Diagnostics getDiagnostics() {
        return this._diagnostics;
    }

    public final Object check(AnnotationMirror annotation, AnnotationMirror[] parentAnnotations, MemberDeclaration classMember) {
        if (!this.beginCheck(annotation, parentAnnotations, classMember)) {
            return null;
        }
        Map valuesPresent = annotation.getElementValues();
        HashSet<String> wasPresent = new HashSet<String>();
        HashMap<String, Object> checkResults = new HashMap<String, Object>();
        if (parentAnnotations == null) {
            parentAnnotations = new AnnotationMirror[]{};
        }
        int oldLen = parentAnnotations.length;
        AnnotationMirror[] parentsIncludingMe = new AnnotationMirror[oldLen + 1];
        System.arraycopy(parentAnnotations, 0, parentsIncludingMe, 0, oldLen);
        parentsIncludingMe[oldLen] = annotation;
        for (Map.Entry i : valuesPresent.entrySet()) {
            Object result;
            AnnotationTypeElementDeclaration decl = (AnnotationTypeElementDeclaration)i.getKey();
            AnnotationValue value = (AnnotationValue)i.getValue();
            String memberName = decl.getSimpleName();
            wasPresent.add(memberName);
            this.onCheckMember(decl, value, annotation, parentAnnotations, classMember);
            Object grammarOrType = null;
            Object v = this._memberGrammars.get(memberName);
            grammarOrType = v;
            if (v != null) {
                AnnotationGrammar childGrammar = grammarOrType;
                if (childGrammar == null || (result = childGrammar.check((AnnotationMirror)value.getValue(), parentsIncludingMe, classMember)) == null) continue;
                checkResults.put(memberName, result);
                continue;
            }
            Object v2 = this._memberArrayGrammars.get(memberName);
            grammarOrType = v2;
            if (v2 != null) {
                AnnotationGrammar arrayGrammar = grammarOrType;
                if (arrayGrammar == null) continue;
                List<AnnotationMirror> annotations = CompilerUtils.getAnnotationArray(value);
                for (AnnotationMirror ann : annotations) {
                    arrayGrammar.check(ann, parentsIncludingMe, classMember);
                }
                continue;
            }
            AnnotationMemberType memberType = (AnnotationMemberType)this._memberTypes.get(memberName);
            if (memberType == null || (result = memberType.check(decl, value, parentsIncludingMe, classMember)) == null) continue;
            checkResults.put(memberName, result);
        }
        return this.endCheck(annotation, parentAnnotations, classMember, wasPresent, checkResults);
    }

    public final boolean beginCheck(AnnotationMirror annotation, AnnotationMirror[] parentAnnotations, MemberDeclaration classMember) {
        if (!this._runtimeVersionChecker.checkRuntimeVersion(this._requiredRuntimeVersion, annotation, this._diagnostics, "error.required-runtime-version-annotation", "/WEB-INF/lib/beehive-netui-pageflow.jar")) {
            return false;
        }
        return this.onBeginCheck(annotation, parentAnnotations, classMember);
    }

    protected void addError(Declaration element, String key, Object ... args) {
        this.getDiagnostics().addError(element, key, args);
    }

    protected void addError(AnnotationValue element, String key, Object ... args) {
        this.getDiagnostics().addError(element, key, args);
    }

    protected void addError(AnnotationMirror element, String key, Object ... args) {
        this.getDiagnostics().addError(element, key, args);
    }

    protected void addWarning(Declaration element, String key, Object ... args) {
        this.getDiagnostics().addWarning(element, key, args);
    }

    protected void addWarning(AnnotationValue element, String key, Object ... args) {
        this.getDiagnostics().addWarning(element, key, args);
    }

    protected void addWarning(AnnotationMirror element, String key, Object ... args) {
        this.getDiagnostics().addWarning(element, key, args);
    }

    public final Object endCheck(AnnotationMirror annotation, AnnotationMirror[] parentAnnotations, MemberDeclaration classMember, Set wasPresent, Map checkResults) {
        String[][] mutuallyExclusiveAttrs = this.getMutuallyExclusiveAttrs();
        for (int i = 0; mutuallyExclusiveAttrs != null && i < mutuallyExclusiveAttrs.length; ++i) {
            String alreadyFound = null;
            for (int j = 0; j < mutuallyExclusiveAttrs[i].length; ++j) {
                String thisAttr = mutuallyExclusiveAttrs[i][j];
                if (!wasPresent.contains(thisAttr)) continue;
                if (alreadyFound == null) {
                    alreadyFound = thisAttr;
                    continue;
                }
                String errorKey = "error.atmost-one-may-exist-" + mutuallyExclusiveAttrs[i].length;
                this.getDiagnostics().addErrorArrayArgs(annotation, errorKey, mutuallyExclusiveAttrs[i]);
            }
        }
        String[][] requiredAttrs = this.getRequiredAttrs();
        for (int i = 0; requiredAttrs != null && i < requiredAttrs.length; ++i) {
            boolean foundOne = false;
            for (int j = 0; j < requiredAttrs[i].length; ++j) {
                String thisAttr = requiredAttrs[i][j];
                if (!wasPresent.contains(thisAttr)) continue;
                foundOne = true;
                break;
            }
            if (foundOne) continue;
            String errorKey = "error.atleast-one-must-exist-" + requiredAttrs[i].length;
            this.getDiagnostics().addErrorArrayArgs(annotation, errorKey, requiredAttrs[i]);
        }
        String[][] attrDependencies = this.getAttrDependencies();
        for (int i = 0; attrDependencies != null && i < attrDependencies.length; ++i) {
            String thisAttr = attrDependencies[i][0];
            if (!wasPresent.contains(thisAttr)) continue;
            boolean foundOne = false;
            for (int j = 1; j < attrDependencies[i].length; ++j) {
                if (!wasPresent.contains(attrDependencies[i][j])) continue;
                foundOne = true;
                break;
            }
            if (foundOne) continue;
            String key = "error.attr-dependency-not-found-" + (attrDependencies[i].length - 1);
            this.getDiagnostics().addErrorArrayArgs(annotation, key, attrDependencies[i]);
        }
        return this.onEndCheck(annotation, parentAnnotations, classMember, checkResults);
    }

    protected boolean onBeginCheck(AnnotationMirror annotation, AnnotationMirror[] parentAnnotations, MemberDeclaration classMember) {
        return true;
    }

    protected Object onEndCheck(AnnotationMirror annotation, AnnotationMirror[] parentAnnotations, MemberDeclaration classMember, Map checkResults) {
        return null;
    }

    protected void onCheckMember(AnnotationTypeElementDeclaration memberDecl, AnnotationValue member, AnnotationMirror annotation, AnnotationMirror[] parentAnnotations, MemberDeclaration classMember) {
    }

    public String[][] getMutuallyExclusiveAttrs() {
        return null;
    }

    public String[][] getRequiredAttrs() {
        return null;
    }

    public String[][] getAttrDependencies() {
        return null;
    }

    protected void addMemberGrammar(String memberName, AnnotationGrammar grammar) {
        this._memberGrammars.put(memberName, grammar);
    }

    protected void addMemberArrayGrammar(String memberName, AnnotationGrammar grammar) {
        this._memberArrayGrammars.put(memberName, grammar);
    }

    protected void addMemberType(String memberName, AnnotationMemberType type) {
        this._memberTypes.put(memberName, type);
    }

    public String getRequiredRuntimeVersion() {
        return this._requiredRuntimeVersion;
    }

    public RuntimeVersionChecker getRuntimeVersionChecker() {
        return this._runtimeVersionChecker;
    }
}

