/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.tags.html;

import com.bea.wlw.netui.pageflow.ProcessPopulate;
import com.bea.wlw.netui.pageflow.RequestParameterHandler;
import com.bea.wlw.netui.tags.OptionsDataSourceTag;
import com.bea.wlw.netui.tags.html.Form;
import com.bea.wlw.netui.tags.html.FormatTag;
import com.bea.wlw.netui.tags.html.Formattable;
import com.bea.wlw.netui.tags.naming.PrefixNameInterceptor;
import com.bea.wlw.netui.util.Bundle;
import com.bea.wlw.netui.util.debug.Debug;
import com.bea.wlw.netui.util.iterator.IteratorFactory;
import com.bea.wlw.netui.util.iterator.IteratorFactoryException;
import com.bea.wlw.netui.util.logging.Logger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import weblogic.utils.UnsyncStringBuffer;

public class Select
extends OptionsDataSourceTag
implements Formattable {
    public static final String NULL_VALUE = "netui_null";
    private static final Debug debug;
    private static final String SELECT_KEY = "select_key";
    private static final String OLDVALUE_SUFFIX = "OldValue";
    private List defaultSelections = null;
    private ArrayList formatters = null;
    private String[] match = null;
    private boolean multiple = false;
    private String saveBody = null;
    private String size = null;
    private String nullableOptionText = null;
    private boolean nullable = false;
    private ArrayList optionList;
    private String tagId = null;
    private String disabled;
    static /* synthetic */ Class class$com$bea$wlw$netui$tags$html$Select;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Select() {
        this.addNamingInterceptor(new PrefixNameInterceptor(SELECT_KEY));
    }

    public String getTagName() {
        return "Select";
    }

    protected Object evaluateDefaultValue() {
        Object val = super.evaluateDefaultValue();
        ArrayList<Object> defaults = null;
        if (val instanceof String) {
            defaults = new ArrayList<Object>();
            defaults.add(val);
        } else {
            Iterator optionsIterator = null;
            try {
                optionsIterator = IteratorFactory.makeIterator((Object)val);
                if (optionsIterator == null && this.getDefaultValue() != null) {
                    Logger.warn((String)Bundle.getString((String)"Tags_IteratorError", (Object[])new Object[]{this.getTagName(), "defaultValue", this.getDefaultValue()}), this.getClass());
                }
                if (optionsIterator == null) {
                    optionsIterator = IteratorFactory.EMPTY_ITERATOR;
                }
            }
            catch (IteratorFactoryException ife) {
                String s = Bundle.getString((String)"Tags_Iteration_Error", (Object[])new Object[]{ife.getTypeName()});
                s = this.registerTagError(s);
                return null;
            }
            defaults = new ArrayList();
            while (optionsIterator.hasNext()) {
                Object o = optionsIterator.next();
                defaults.add(o.toString());
            }
        }
        return defaults;
    }

    public boolean getMultiple() {
        return this.multiple;
    }

    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public String getNullableOptionText() {
        return this.nullableOptionText;
    }

    public void setNullableOptionText(String nullableOptionText) {
        this.nullableOptionText = nullableOptionText;
    }

    protected Object evaluateOptionsDataSource() throws JspException {
        Object val = super.evaluateOptionsDataSource();
        if (val == null) {
            if (this.getOptionsDataSource() != null) {
                Logger.warn((String)Bundle.getString((String)"Tags_IteratorError", (Object[])new Object[]{this.getTagName(), "optionsDataSource", this.getOptionsDataSource()}), this.getClass());
            }
            return null;
        }
        if (val instanceof Map) {
            return val;
        }
        Iterator options = null;
        try {
            options = IteratorFactory.makeIterator((Object)val);
            if (options == null) {
                options = IteratorFactory.EMPTY_ITERATOR;
            }
        }
        catch (IteratorFactoryException ife) {
            String s = Bundle.getString((String)"Tags_Iteration_Error", (Object[])new Object[]{ife.getTypeName()});
            s = this.registerTagError(s);
            return null;
        }
        return options;
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public String getTagId() {
        return this.tagId;
    }

    public void setTagId(String tagId) {
        this.tagId = tagId;
    }

    public String getDisabled() {
        return this.disabled;
    }

    public void setDisabled(String disabled) {
        this.disabled = disabled;
    }

    public boolean isMatched(String value) {
        if (value == null) {
            return false;
        }
        if (this.match != null) {
            int i = 0;
            while (i < this.match.length) {
                if (value.equals(this.match[i])) {
                    return true;
                }
                ++i;
            }
        } else if (this.defaultSelections != null) {
            return this.defaultSelections.contains(value);
        }
        return false;
    }

    public int doStartTag() throws JspException {
        Object val = this.evaluateDataSource();
        this.defaultSelections = (List)this.evaluateDefaultValue();
        if (this.hasErrors()) {
            return 0;
        }
        if (val != null) {
            int i;
            if (val instanceof String) {
                this.match = new String[]{(String)val};
            } else if (val instanceof String[]) {
                String[] s = (String[])val;
                int cnt = 0;
                int i2 = 0;
                while (i2 < s.length) {
                    if (s[i2] != null) {
                        ++cnt;
                    }
                    ++i2;
                }
                if (cnt == s.length) {
                    this.match = s;
                } else if (cnt > 0) {
                    this.match = new String[cnt];
                    cnt = 0;
                    i = 0;
                    while (i < s.length) {
                        if (s[i] != null) {
                            this.match[cnt++] = s[i];
                        }
                        ++i;
                    }
                }
            } else {
                Iterator matchIterator = null;
                try {
                    matchIterator = IteratorFactory.makeIterator((Object)val);
                    if (matchIterator == null) {
                        matchIterator = IteratorFactory.EMPTY_ITERATOR;
                    }
                }
                catch (IteratorFactoryException ife) {
                    String s = Bundle.getString((String)"Tags_Iteration_Error", (Object[])new Object[]{ife.getTypeName()});
                    s = this.registerTagError(s);
                    if (s == null) {
                        this.reportErrors();
                        return 0;
                    }
                    throw new JspException(s);
                }
                ArrayList matchList = new ArrayList();
                while (matchIterator.hasNext()) {
                    Object o = matchIterator.next();
                    if (o == null) continue;
                    matchList.add(o);
                }
                int size = matchList.size();
                this.match = new String[size];
                i = 0;
                while (i < size) {
                    if (!$assertionsDisabled && matchList.get(i) == null) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && matchList.get(i).toString() == null) {
                        throw new AssertionError();
                    }
                    this.match[i] = matchList.get(i).toString();
                    ++i;
                }
            }
            if (Select.debug.ON) {
                debug.out("****** Select Matches ******");
                int i3 = 0;
                while (i3 < this.match.length) {
                    debug.out(i3 + ": " + this.match[i3]);
                    ++i3;
                }
            }
        } else if (this.isNullable() && !this.multiple) {
            this.match = new String[]{NULL_VALUE};
        }
        this.formatters = new ArrayList();
        this.optionList = new ArrayList();
        return 2;
    }

    public int doAfterBody() throws JspException {
        if (this.hasErrors()) {
            return 0;
        }
        if (this.bodyContent != null) {
            String value = this.bodyContent.getString();
            this.bodyContent.clearBody();
            if (value == null) {
                value = "";
            }
            this.saveBody = value.trim();
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        Object dynamicOptions;
        String scriptId = null;
        if (this.hasErrors()) {
            this.reportErrors();
            this.localRelease();
            return 6;
        }
        boolean selectDisabled = false;
        if (this.disabled != null) {
            this.disabled = this.evaluateAttributeToString(this.disabled, "disabled");
            selectDisabled = Boolean.valueOf(this.disabled);
        }
        String hiddenParamName = null;
        hiddenParamName = this.doNaming() + OLDVALUE_SUFFIX;
        UnsyncStringBuffer results = new UnsyncStringBuffer(128);
        if (!selectDisabled) {
            results.append("<input type=\"hidden\" name=\"");
            if (this.hasErrors()) {
                this.reportErrors();
                this.localRelease();
                return 0;
            }
            results.append(hiddenParamName);
            results.append("\" value=\"true\"/>");
        }
        results.append("<select");
        results.append(" name=\"");
        results.append(this.doNaming());
        results.append("\"");
        if (this.tagId != null) {
            Form parentForm = this.getNearestForm();
            if (parentForm != null) {
                parentForm.addTagID(this.tagId, this.doNaming());
            }
            scriptId = this.addTagIdMapping(this.tagId, this.doNaming());
        }
        if (this.multiple) {
            results.append(" multiple");
        }
        if (this.size != null) {
            this.size = this.evaluateAttributeToString(this.size, "size");
            this.renderAttribute(results, "size", this.size);
        }
        if (selectDisabled) {
            this.renderAttribute(results, "disabled", "true");
        }
        results.append(this.renderAttributes(1));
        results.append(this.renderAttributes(0));
        results.append(this.renderAttributes(2));
        results.append(">");
        if (this.saveBody != null) {
            results.append(this.saveBody);
        }
        if ((dynamicOptions = this.evaluateOptionsDataSource()) != null) {
            if (dynamicOptions instanceof Map) {
                Map dynamicOptionsMap = (Map)dynamicOptions;
                Iterator keyIterator = dynamicOptionsMap.keySet().iterator();
                while (keyIterator.hasNext()) {
                    Object optionValue = keyIterator.next();
                    String optionDisplay = null;
                    if (dynamicOptionsMap.get(optionValue) != null) {
                        optionDisplay = dynamicOptionsMap.get(optionValue).toString();
                    }
                    this.addOption(results, optionValue.toString(), optionDisplay);
                }
            } else if (dynamicOptions instanceof Iterator) {
                Iterator dynamicOptionsIterator = (Iterator)this.evaluateOptionsDataSource();
                while (dynamicOptionsIterator.hasNext()) {
                    Object o = dynamicOptionsIterator.next();
                    if (o == null) continue;
                    String optionValue = o.toString();
                    this.addOption(results, optionValue, optionValue);
                }
            }
        }
        this.addDatasourceIfNeeded(results);
        this.addDefaultsIfNeeded(results);
        if (this.isNullable() && !this.multiple) {
            String txt = this.nullableOptionText != null ? this.nullableOptionText : "";
            this.addOption(results, NULL_VALUE, txt);
        }
        if (this.hasErrors()) {
            this.reportErrors();
            this.localRelease();
            return 6;
        }
        results.append("</select>");
        if (scriptId != null) {
            results.append(scriptId);
        }
        this.write(results.toString());
        this.localRelease();
        return 6;
    }

    protected void localRelease() {
        super.localRelease();
        this.defaultSelections = null;
        this.formatters = null;
        this.match = null;
        this.multiple = false;
        this.saveBody = null;
        this.size = null;
        this.nullable = false;
        this.nullableOptionText = null;
        this.optionList = null;
        this.tagId = null;
        this.disabled = null;
    }

    private void addDefaultsIfNeeded(UnsyncStringBuffer buffer) {
        if (this.defaultSelections != null) {
            Iterator iterator = this.defaultSelections.iterator();
            while (iterator.hasNext()) {
                Object selection = iterator.next();
                if (this.optionList.contains(selection)) continue;
                this.addOption(buffer, selection.toString(), selection.toString());
            }
        }
    }

    private void addDatasourceIfNeeded(UnsyncStringBuffer buffer) {
        if (this.match == null) {
            return;
        }
        int i = 0;
        while (i < this.match.length) {
            if (!this.optionList.contains(this.match[i]) && !this.match[i].equals(NULL_VALUE)) {
                this.addOption(buffer, this.match[i], this.match[i]);
            }
            ++i;
        }
    }

    private void addOption(UnsyncStringBuffer buffer, String optionValue, String optionDisplay) {
        if (!$assertionsDisabled && buffer == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && optionValue == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && optionDisplay == null) {
            throw new AssertionError();
        }
        buffer.append("<option value=\"");
        buffer.append(optionValue);
        buffer.append("\"");
        buffer.append(this.renderAttributes(1));
        if (this.isMatched(optionValue)) {
            buffer.append(" selected=\"true\"");
        }
        buffer.append(">");
        if (optionDisplay != null) {
            buffer.append(this.formatText(optionDisplay));
        } else {
            buffer.append("&lt;");
            buffer.append(optionValue);
            buffer.append(">");
        }
        buffer.append("</option>");
        this.addOptionToList(optionValue);
    }

    public void addFormatter(FormatTag.Formatter formatter) {
        this.formatters.add(formatter);
    }

    public void addOptionToList(String value) {
        this.optionList.add(value);
    }

    public String formatText(Object text) {
        int i = 0;
        while (i < this.formatters.size()) {
            FormatTag.Formatter currentFormatter = (FormatTag.Formatter)this.formatters.get(i);
            try {
                text = currentFormatter.format(text);
            }
            catch (JspException e) {
                this.registerTagError(e.getMessage());
            }
            ++i;
        }
        return text.toString();
    }

    public void setTabindex(String tabindex) {
        this.registerAttribute(0, "tabindex", tabindex);
    }

    public String getTabindex() {
        return this.getAttribute(0, "tabindex");
    }

    public void setStyle(String style) {
        this.registerAttribute(1, "style", style);
    }

    public String getStyle() {
        return this.getAttribute(1, "style");
    }

    public void setStyleClass(String styleClass) {
        this.registerAttribute(1, "class", styleClass);
    }

    public String getStyleClass() {
        return this.getAttribute(1, "class");
    }

    public String getAccessKey() {
        return this.getAttribute(0, "accesskey");
    }

    public void setAccessKey(String accessKey) {
        this.registerAttribute(0, "accesskey", accessKey);
    }

    public String getOnClick() {
        return this.getAttribute(2, "onclick");
    }

    public void setOnClick(String onclick) {
        this.registerAttribute(2, "onclick", onclick);
    }

    public String getOnDblClick() {
        return this.getAttribute(2, "ondblclick");
    }

    public void setOnDblClick(String ondblclick) {
        this.registerAttribute(2, "ondblclick", ondblclick);
    }

    public String getOnKeyDown() {
        return this.getAttribute(2, "onkeydown");
    }

    public void setOnKeyDown(String onkeydown) {
        this.registerAttribute(2, "onkeydown", onkeydown);
    }

    public String getOnKeyPress() {
        return this.getAttribute(2, "onkeypress");
    }

    public void setOnKeyPress(String onkeypress) {
        this.registerAttribute(2, "onkeypress", onkeypress);
    }

    public String getOnKeyUp() {
        return this.getAttribute(2, "onkeyup");
    }

    public void setOnKeyUp(String onkeyup) {
        this.registerAttribute(2, "onkeyup", onkeyup);
    }

    public String getOnMouseDown() {
        return this.getAttribute(2, "onmousedown");
    }

    public void setOnMouseDown(String onmousedown) {
        this.registerAttribute(2, "onmousedown", onmousedown);
    }

    public String getOnMouseMove() {
        return this.getAttribute(2, "onmousemove");
    }

    public void setOnMouseMove(String onmousemove) {
        this.registerAttribute(2, "onmousemove", onmousemove);
    }

    public String getOnMouseOut() {
        return this.getAttribute(2, "onmouseout");
    }

    public void setOnMouseOut(String onmouseout) {
        this.registerAttribute(2, "onmouseout", onmouseout);
    }

    public String getOnMouseOver() {
        return this.getAttribute(2, "onmouseover");
    }

    public void setOnMouseOver(String onmouseover) {
        this.registerAttribute(2, "onmouseover", onmouseover);
    }

    public String getOnMouseUp() {
        return this.getAttribute(2, "onmouseup");
    }

    public void setOnMouseUp(String onmouseup) {
        this.registerAttribute(2, "onmouseup", onmouseup);
    }

    public String getOnBlur() {
        return this.getAttribute(2, "onblur");
    }

    public void setOnBlur(String onblur) {
        this.registerAttribute(2, "onblur", onblur);
    }

    public String getOnFocus() {
        return this.getAttribute(2, "onfocus");
    }

    public void setOnFocus(String onblur) {
        this.registerAttribute(2, "onfocus", onblur);
    }

    public String getOnChange() {
        return this.getAttribute(2, "onchange");
    }

    public void setOnChange(String onchange) {
        this.registerAttribute(2, "onchange", onchange);
    }

    public String getOnSelect() {
        return this.getAttribute(2, "onselect");
    }

    public void setOnSelect(String onselect) {
        this.registerAttribute(2, "onselect", onselect);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$bea$wlw$netui$tags$html$Select == null ? (class$com$bea$wlw$netui$tags$html$Select = Select.class$("com.bea.wlw.netui.tags.html.Select")) : class$com$bea$wlw$netui$tags$html$Select).desiredAssertionStatus();
        debug = Debug.getInstance((Class)(class$com$bea$wlw$netui$tags$html$Select == null ? (class$com$bea$wlw$netui$tags$html$Select = Select.class$("com.bea.wlw.netui.tags.html.Select")) : class$com$bea$wlw$netui$tags$html$Select));
        ProcessPopulate.registerPrefixHandler((String)SELECT_KEY, (RequestParameterHandler)new SelectPrefixHandler());
    }

    public static class SelectPrefixHandler
    implements RequestParameterHandler {
        public void process(HttpServletRequest request, String key, ProcessPopulate.ExpressionUpdateNode node) {
            String newKey;
            String[] select;
            String[] returnArray = null;
            returnArray = !key.endsWith(Select.OLDVALUE_SUFFIX) ? request.getParameterValues(key) : ((select = request.getParameterValues(newKey = key.substring(0, key.indexOf(Select.OLDVALUE_SUFFIX)))) != null ? select : new String[]{});
            if (node.expression.endsWith(Select.OLDVALUE_SUFFIX)) {
                node.expression = node.expression.substring(0, node.expression.indexOf(Select.OLDVALUE_SUFFIX));
            }
            int i = 0;
            while (i < returnArray.length) {
                if (returnArray[i].equals(Select.NULL_VALUE)) {
                    returnArray[i] = null;
                }
                ++i;
            }
            node.values = returnArray;
            if (debug.ON) {
                debug.out("\n*********************************************\nprocess with key \"" + key + "\" and expression \"" + node.expression + "\"" + "and result size: " + (returnArray != null ? "" + returnArray.length : null) + "\n" + "*********************************************\n");
            }
        }
    }
}

