/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.tags.html;

import com.bea.wlw.netui.tags.AbstractBaseTag;
import com.bea.wlw.netui.tags.html.Formattable;
import com.bea.wlw.netui.util.Bundle;
import com.bea.wlw.netui.util.logging.Logger;
import java.util.Locale;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;

public abstract class FormatTag
extends AbstractBaseTag {
    private String language = null;
    private String country = null;
    protected String pattern = null;
    protected String patternValue;

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public Locale getLocale() {
        Locale loc = null;
        if (this.language != null || this.country != null) {
            if (this.language == null) {
                String s = Bundle.getString((String)"Tags_LocaleRequiresLanguage", (Object[])new Object[]{this.country});
                Logger.error((String)s, ((Object)((Object)this)).getClass());
                return super.getUserLocale();
            }
            loc = this.country == null ? new Locale(this.language) : new Locale(this.language, this.country);
        } else {
            loc = super.getUserLocale();
        }
        return loc;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        if (this.containsExpression(pattern)) {
            Object val = this.evaluateExpression(pattern, null);
            if (val != null) {
                this.patternValue = val.toString();
                if (this.patternValue.length() == 0) {
                    this.registerTagError(Bundle.getString((String)"Tags_NoFormatPattern"));
                }
            } else {
                this.patternValue = "";
                this.registerTagError(Bundle.getString((String)"Tags_NoFormatPattern"));
            }
        } else {
            if (pattern == null || pattern.length() == 0) {
                this.registerTagError(Bundle.getString((String)"Tags_NoFormatPattern"));
            }
            this.patternValue = pattern;
        }
        this.pattern = pattern;
    }

    public int doStartTag() throws JspException {
        Tag parentTag = this.getParent();
        if (parentTag instanceof Formattable) {
            Formatter formatter = new Formatter();
            formatter.setPattern(this.patternValue);
            Formattable parent = (Formattable)parentTag;
            parent.addFormatter(formatter);
        }
        this.localRelease();
        return 0;
    }

    protected void localRelease() {
        super.localRelease();
        this.language = null;
        this.country = null;
        this.pattern = null;
        this.patternValue = null;
    }

    public static class Formatter {
        private String pattern;

        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        public String format(Object dataToFormat) throws JspException {
            if (dataToFormat == null) {
                return null;
            }
            return dataToFormat.toString();
        }
    }
}

