/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.tags.html;

import com.bea.wlw.netui.tags.html.FormatTag;
import com.bea.wlw.netui.tags.html.Formattable;
import com.bea.wlw.netui.util.Bundle;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import weblogic.utils.UnsyncStringBuffer;

public class FormatNumber
extends FormatTag {
    protected String type;

    public String getTagName() {
        return "FormatNumber";
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int doStartTag() throws JspException {
        if (this.hasErrors()) {
            this.reportErrors();
            this.localRelease();
            return 6;
        }
        Tag parentTag = this.getParent();
        if (parentTag instanceof Formattable) {
            NumberFormatter formatter = new NumberFormatter();
            formatter.setPattern(this.patternValue);
            formatter.setType(this.type);
            formatter.setLocale(this.getLocale());
            Formattable parent = (Formattable)parentTag;
            parent.addFormatter(formatter);
        }
        this.localRelease();
        return 0;
    }

    protected void localRelease() {
        super.localRelease();
        this.type = null;
    }

    public static class NumberFormatter
    extends FormatTag.Formatter {
        private String type;
        private Locale locale;

        public void setType(String type) {
            this.type = type;
        }

        public void setLocale(Locale locale) {
            this.locale = locale;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public String format(Object dataToFormat) throws JspException {
            if (dataToFormat == null) {
                return null;
            }
            UnsyncStringBuffer formattedString = new UnsyncStringBuffer(32);
            DecimalFormat numberFormat = null;
            if (this.locale == null) {
                if (this.type == null || this.type.equals("number")) {
                    numberFormat = (DecimalFormat)NumberFormat.getNumberInstance();
                } else if (this.type.equals("currency")) {
                    numberFormat = (DecimalFormat)NumberFormat.getCurrencyInstance();
                } else {
                    if (!this.type.equals("percent")) throw new JspException(Bundle.getString((String)"Tags_NumberFormatWrongType"));
                    numberFormat = (DecimalFormat)NumberFormat.getPercentInstance();
                }
            } else if (this.type == null || this.type.equals("number")) {
                numberFormat = (DecimalFormat)NumberFormat.getNumberInstance(this.locale);
            } else if (this.type.equals("currency")) {
                numberFormat = (DecimalFormat)NumberFormat.getCurrencyInstance(this.locale);
            } else {
                if (!this.type.equals("percent")) throw new JspException(Bundle.getString((String)"Tags_NumberFormatWrongType"));
                numberFormat = (DecimalFormat)NumberFormat.getPercentInstance(this.locale);
            }
            try {
                if (this.getPattern() != null) {
                    numberFormat.applyPattern(this.getPattern());
                }
            }
            catch (Exception e) {
                throw new JspException(Bundle.getString((String)"Tags_FormatException", (Object)e.getMessage()), (Throwable)e);
            }
            if (dataToFormat.toString().length() == 0) {
                return "";
            }
            try {
                double number = Double.parseDouble(dataToFormat.toString());
                formattedString.append(numberFormat.format(number));
                return formattedString.toString();
            }
            catch (Exception e) {
                System.err.println("\n\n\nThrowing an exception");
                throw new JspException(Bundle.getString((String)"Tags_FormatException", (Object)e.getMessage()), (Throwable)e);
            }
        }
    }
}

