/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.tags;

import com.bea.wlw.netui.pageflow.util.URLRewriterService;
import com.bea.wlw.netui.script.ExpressionEvaluationException;
import com.bea.wlw.netui.script.ExpressionEvaluator;
import com.bea.wlw.netui.script.ExpressionEvaluatorFactory;
import com.bea.wlw.netui.tags.AbstractPageError;
import com.bea.wlw.netui.tags.ErrorReporter;
import com.bea.wlw.netui.tags.EvalErrorInfo;
import com.bea.wlw.netui.tags.JavaScriptUtils;
import com.bea.wlw.netui.tags.ScriptReporter;
import com.bea.wlw.netui.tags.TagErrorInfo;
import com.bea.wlw.netui.tags.html.Form;
import com.bea.wlw.netui.util.Bundle;
import com.bea.wlw.netui.util.PopulateContextHelper;
import com.bea.wlw.netui.util.debug.Debug;
import com.bea.wlw.netui.util.logging.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.Tag;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.util.ResponseUtils;
import weblogic.utils.UnsyncStringBuffer;

public abstract class AbstractBaseTag
extends BodyTagSupport {
    private static final Debug debug;
    private static final Logger logger;
    public static final String JAVASCRIPT_STATUS = "netui.javascript.status";
    public static final String NETUI_UNIQUE_CNT = "netui.unique.id";
    private static final String EMPTY_STRING = "";
    protected static final int ATTR_GENERAL = 0;
    protected static final int ATTR_STYLE = 1;
    protected static final int ATTR_JAVASCRIPT = 2;
    protected static final int ATTR_GENERAL_EXPRESSION = 4;
    protected static final String ONCLICK = "onclick";
    protected static final String ONDBLCLICK = "ondblclick";
    protected static final String ONKEYDOWN = "onkeydown";
    protected static final String ONKEYPRESS = "onkeypress";
    protected static final String ONKEYUP = "onkeyup";
    protected static final String ONMOUSEDOWN = "onmousedown";
    protected static final String ONMOUSEUP = "onmouseup";
    protected static final String ONMOUSEMOVE = "onmousemove";
    protected static final String ONMOUSEOVER = "onmouseover";
    protected static final String ONMOUSEOUT = "onmouseout";
    protected static final String STYLE = "style";
    protected static final String CLASS = "class";
    protected static final String TABINDEX = "tabindex";
    private List _errors = null;
    private Map jsMap = null;
    private Map styleMap = null;
    private Map generalMap = null;
    private Map generalExpressionMap = null;
    private ExpressionEvaluator ee = null;
    static /* synthetic */ Class class$com$bea$wlw$netui$tags$AbstractBaseTag;
    static final /* synthetic */ boolean $assertionsDisabled;

    public abstract String getTagName();

    protected void localRelease() {
        this.ee = null;
        if (this.jsMap != null) {
            this.jsMap.clear();
        }
        if (this.styleMap != null) {
            this.styleMap.clear();
        }
        if (this.generalMap != null) {
            this.generalMap.clear();
        }
        if (this.generalExpressionMap != null) {
            this.generalExpressionMap.clear();
        }
        this._errors = null;
    }

    public void release() {
        super.release();
    }

    public String registerTagError(String message) {
        if (!$assertionsDisabled && message == null) {
            throw new AssertionError();
        }
        if (this._errors == null) {
            this._errors = new ArrayList();
        }
        TagErrorInfo tei = new TagErrorInfo();
        tei.tagType = this.getTagName();
        tei.message = message;
        this._errors.add(tei);
        ErrorReporter er = this.getErrorReporter();
        if (er == null) {
            tei.errorNo = -1;
            return null;
        }
        er.addError(tei);
        if (!$assertionsDisabled && tei.errorNo <= 0) {
            throw new AssertionError();
        }
        return null;
    }

    protected final ExpressionEvaluator getExpressionEvaluator() {
        if (this.ee == null) {
            this.ee = ExpressionEvaluatorFactory.getInstance();
        }
        return this.ee;
    }

    protected void registerAttribute(int type, String key, String value) {
        if (value == null) {
            return;
        }
        Map map = this.selectMap(type, true);
        if (map == null) {
            return;
        }
        map.put(key, value);
    }

    protected void removeAttribute(int type, String key) {
        Map map = this.selectMap(type, false);
        if (map == null) {
            return;
        }
        map.remove(key);
    }

    protected String getAttribute(int type, String key) {
        Map map = this.selectMap(type, false);
        if (map == null) {
            return null;
        }
        return (String)map.get(key);
    }

    protected String renderAttributes(int type) {
        switch (type) {
            case 0: {
                return this.renderGeneral();
            }
            case 4: {
                return this.renderGeneralExpression();
            }
            case 2: {
                return this.renderEventHandlers();
            }
            case 1: {
                return this.renderStyles();
            }
        }
        throw new IllegalStateException("The type \"" + type + "\" was not recognized as a valid type.");
    }

    protected final void write(String string) {
        block2: {
            try {
                ResponseUtils.write((PageContext)this.pageContext, (String)string);
            }
            catch (JspException e) {
                if (!logger.isErrorEnabled()) break block2;
                logger.error((Object)Bundle.getString((String)"Tags_WriteException"), (Throwable)e);
            }
        }
    }

    protected final String filter(String value) {
        return this.filter(value, false);
    }

    protected String filter(String value, boolean markupHTMLSpaceReturn) {
        if (value == null) {
            return null;
        }
        boolean needsToChange = false;
        int numChars = value.length();
        int prev = 0;
        UnsyncStringBuffer result = new UnsyncStringBuffer(numChars + numChars / 5);
        int i = 0;
        while (i < numChars) {
            char c = value.charAt(i);
            switch (c) {
                case '<': {
                    needsToChange = true;
                    result.append("&lt;");
                    break;
                }
                case '>': {
                    needsToChange = true;
                    result.append("&gt;");
                    break;
                }
                case '&': {
                    needsToChange = true;
                    result.append("&amp;");
                    break;
                }
                case '\"': {
                    needsToChange = true;
                    result.append("&quot;");
                    break;
                }
                case '\'': {
                    needsToChange = true;
                    result.append("&#39;");
                    break;
                }
                case ' ': {
                    if (markupHTMLSpaceReturn) {
                        if (prev == 32) {
                            needsToChange = true;
                            result.append("&nbsp;");
                            break;
                        }
                        result.append(c);
                        break;
                    }
                    result.append(c);
                    break;
                }
                case '\n': {
                    if (markupHTMLSpaceReturn) {
                        needsToChange = true;
                        result.append("<br />");
                        break;
                    }
                    result.append(c);
                    break;
                }
                default: {
                    result.append(c);
                }
            }
            prev = c;
            ++i;
        }
        return needsToChange ? result.toString() : value;
    }

    protected String formatString(String key, Object[] values) {
        return Bundle.getString((String)key, (Object[])values);
    }

    protected String formatErrorString(String key, Object[] values) {
        return Bundle.getErrorString((String)key, (Object[])values);
    }

    protected void populateAvailableContexts(Map map) {
        PopulateContextHelper.populate((Map)map, (PageContext)this.pageContext, (Tag)this);
    }

    protected Object evaluateExpression(String expression, String attrName) {
        return this.evaluateExpressionInternal(expression, attrName);
    }

    protected String evaluateAttributeToString(String expression, String attrName) {
        if (expression == null) {
            return null;
        }
        if (!this.containsExpression(expression)) {
            return expression;
        }
        Object val = this.evaluateExpression(expression, attrName);
        if (val != null) {
            return val.toString();
        }
        return null;
    }

    protected boolean isExpression(String expression) {
        if (expression == null) {
            return false;
        }
        return this.getExpressionEvaluator().isExpression(expression);
    }

    protected boolean containsExpression(String expression) {
        return this.getExpressionEvaluator().containsExpression(expression);
    }

    protected boolean hasErrors() {
        return this._errors != null;
    }

    protected String getErrorsReport() {
        if (!$assertionsDisabled && this._errors == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this._errors.size() <= 0) {
            throw new AssertionError();
        }
        int cnt = this._errors.size();
        UnsyncStringBuffer sb = new UnsyncStringBuffer(128);
        AbstractPageError info = (AbstractPageError)this._errors.get(0);
        if (info.errorNo > 0) {
            String s;
            if (info instanceof EvalErrorInfo) {
                s = Bundle.getString((String)"Expression_Error");
                s = Bundle.getString((String)"Inline_error", (Object[])new Object[]{s, Integer.toString(info.errorNo), this.getTagName()});
            } else if (info instanceof TagErrorInfo) {
                s = Bundle.getString((String)"Tag_Error");
                s = Bundle.getString((String)"Inline_error", (Object[])new Object[]{s, Integer.toString(info.errorNo), this.getTagName()});
            } else {
                s = null;
            }
            sb.append(s);
            return s.toString();
        }
        String s = Bundle.getString((String)"Tag_Header", (Object[])new Object[]{this.getTagName(), Integer.toString(cnt)});
        sb.append(s);
        Object[] args = new Object[4];
        int i = 0;
        while (i < cnt) {
            AbstractPageError e;
            Object o = this._errors.get(i);
            if (o instanceof EvalErrorInfo) {
                e = (EvalErrorInfo)o;
                if (!$assertionsDisabled && info == null) {
                    throw new AssertionError();
                }
                args[0] = Bundle.getString((String)"Expression_Error");
                args[1] = e.attr;
                args[2] = e.expression;
                args[3] = e.evalExcp.getMessage();
                s = Bundle.getString((String)"Expression_Error_Line", (Object[])args);
            } else if (o instanceof TagErrorInfo) {
                e = (TagErrorInfo)o;
                if (!$assertionsDisabled && info == null) {
                    throw new AssertionError();
                }
                args[0] = Bundle.getString((String)"Tag_Error");
                args[1] = ((TagErrorInfo)e).message;
                s = Bundle.getString((String)"Tag_Error_Line", (Object[])args);
            }
            sb.append(s);
            ++i;
        }
        s = Bundle.getString((String)"Tag_Footer");
        sb.append(s);
        return sb.toString();
    }

    protected void reportErrors() throws JspException {
        this.write(this.getErrorsReport());
    }

    protected String rewriteName(String name) {
        return URLRewriterService.rewriteName((ServletContext)this.pageContext.getServletContext(), (ServletRequest)this.pageContext.getRequest(), (String)name);
    }

    public void registerError(EvalErrorInfo error) {
        if (!$assertionsDisabled && error == null) {
            throw new AssertionError();
        }
        if (this._errors == null) {
            this._errors = new ArrayList();
        }
        this._errors.add(error);
        ErrorReporter er = this.getErrorReporter();
        if (er == null) {
            error.errorNo = -1;
            return;
        }
        er.addError(error);
        if (!$assertionsDisabled && error.errorNo <= 0) {
            throw new AssertionError();
        }
    }

    private ErrorReporter getErrorReporter() {
        AbstractBaseTag par = this;
        while (par != null) {
            ErrorReporter er;
            if (par instanceof ErrorReporter && (er = (ErrorReporter)((Object)par)).isReporting()) {
                return er;
            }
            par = par.getParent();
        }
        return null;
    }

    private Object evaluateExpressionInternal(String expression, String attrName) {
        Object result;
        block8: {
            if (AbstractBaseTag.debug.ON) {
                debug.out("evaluate expression=\"" + expression + "\"");
            }
            result = null;
            try {
                HashMap map = new HashMap();
                this.populateAvailableContexts(map);
                result = this.getExpressionEvaluator().evaluateStrict(expression, map);
            }
            catch (ExpressionEvaluationException ee) {
                if (logger.isWarnEnabled()) {
                    Logger.warn((String)Bundle.getString((String)"Tags_ExpressionEvaluationFailure", (Object)expression), ((Object)((Object)this)).getClass());
                }
                EvalErrorInfo info = new EvalErrorInfo();
                info.evalExcp = ee;
                info.expression = expression;
                info.attr = attrName;
                info.tagType = this.getTagName();
                this.registerError(info);
                if (!$assertionsDisabled && this._errors == null) {
                    throw new AssertionError();
                }
                return null;
            }
            catch (Exception e) {
                String message = Bundle.getString((String)"Tags_ExpressionEvaluationException", (Object[])new Object[]{expression, e.toString()});
                if (AbstractBaseTag.debug.ON) {
                    debug.out(message, (Throwable)e);
                }
                if (!logger.isErrorEnabled()) break block8;
                logger.error((Object)message, (Throwable)e);
            }
        }
        if (AbstractBaseTag.debug.ON) {
            debug.out("resulting object: " + result);
        }
        return result;
    }

    private Map selectMap(int type, boolean createIfNull) {
        Map ret = null;
        if (type == 1) {
            if (this.styleMap == null && createIfNull) {
                this.styleMap = new HashMap();
            }
            ret = this.styleMap;
        } else if (type == 2) {
            if (this.jsMap == null && createIfNull) {
                this.jsMap = new HashMap();
            }
            ret = this.jsMap;
        } else if (type == 0) {
            if (this.generalMap == null && createIfNull) {
                this.generalMap = new HashMap();
            }
            ret = this.generalMap;
        } else if (type == 4) {
            if (this.generalExpressionMap == null && createIfNull) {
                this.generalExpressionMap = new HashMap();
            }
            ret = this.generalExpressionMap;
        }
        return ret;
    }

    private String renderStyles() {
        if (this.styleMap == null) {
            return EMPTY_STRING;
        }
        String val = null;
        UnsyncStringBuffer buf = new UnsyncStringBuffer(128);
        val = (String)this.styleMap.get(STYLE);
        if (val != null) {
            this.renderAttribute(buf, STYLE, val);
        }
        if ((val = (String)this.styleMap.get(CLASS)) != null) {
            this.renderAttribute(buf, CLASS, val);
        }
        return buf.toString();
    }

    private String renderEventHandlers() {
        if (this.jsMap == null) {
            return EMPTY_STRING;
        }
        UnsyncStringBuffer buf = new UnsyncStringBuffer(128);
        Iterator iterator = this.jsMap.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (key == null) continue;
            String value = (String)this.jsMap.get(key);
            this.renderAttribute(buf, key, value);
        }
        return buf.toString();
    }

    private String renderGeneral() {
        if (this.generalMap == null) {
            return EMPTY_STRING;
        }
        String val = null;
        UnsyncStringBuffer buf = new UnsyncStringBuffer(128);
        val = (String)this.generalMap.get(TABINDEX);
        if (val != null) {
            this.renderAttribute(buf, TABINDEX, val);
        }
        Iterator iterator = this.generalMap.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (key == null || key.equals(TABINDEX)) continue;
            String value = (String)this.generalMap.get(key);
            this.renderAttribute(buf, key, value);
        }
        return buf.toString();
    }

    private String renderGeneralExpression() {
        if (this.generalExpressionMap == null) {
            return EMPTY_STRING;
        }
        UnsyncStringBuffer buf = new UnsyncStringBuffer(128);
        Iterator iterator = this.generalExpressionMap.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (key == null) continue;
            String value = (String)this.generalExpressionMap.get(key);
            if (this.containsExpression(value)) {
                Object val = this.evaluateExpression(value, key);
                if (val == null) continue;
                value = val.toString();
            }
            this.renderAttribute(buf, key, value);
        }
        return buf.toString();
    }

    protected final void renderAttribute(UnsyncStringBuffer buf, String name, String value) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (value == null) {
            return;
        }
        buf.append(" ");
        buf.append(name);
        buf.append("=\"");
        buf.append(value);
        buf.append("\"");
    }

    public Form getNearestForm() {
        Tag parentTag = this.getParent();
        while (parentTag != null) {
            if (parentTag instanceof Form) {
                return (Form)parentTag;
            }
            parentTag = parentTag.getParent();
        }
        return null;
    }

    protected String addTagIdMapping(String tagId, String value) {
        ScriptReporter scriptReporter = this.getScriptReporter();
        if (scriptReporter != null) {
            scriptReporter.addTagId(tagId, value);
            return null;
        }
        JavaScriptUtils jsu = this.getJavaScriptUtils((HttpServletRequest)this.pageContext.getRequest());
        return jsu.getTagIdMapping(tagId, value);
    }

    protected int getNextId(HttpServletRequest req) {
        Integer i = (Integer)req.getAttribute(NETUI_UNIQUE_CNT);
        if (i == null) {
            i = new Integer(0);
        }
        int ret = i;
        req.setAttribute(NETUI_UNIQUE_CNT, (Object)new Integer(ret + 1));
        return ret;
    }

    protected ScriptReporter getScriptReporter() {
        Tag parentTag = this.getParent();
        while (parentTag != null) {
            if (parentTag instanceof ScriptReporter) {
                return (ScriptReporter)parentTag;
            }
            parentTag = parentTag.getParent();
        }
        return null;
    }

    protected JavaScriptUtils getJavaScriptUtils(HttpServletRequest request) {
        if (!$assertionsDisabled && request == null) {
            throw new AssertionError();
        }
        JavaScriptUtils jsu = (JavaScriptUtils)request.getAttribute(JAVASCRIPT_STATUS);
        if (jsu == null) {
            jsu = new JavaScriptUtils();
            request.setAttribute(JAVASCRIPT_STATUS, (Object)jsu);
        }
        if (!$assertionsDisabled && jsu == null) {
            throw new AssertionError();
        }
        return jsu;
    }

    protected String getQualifiedBundleName(String bundleName) {
        if (bundleName != null && bundleName.indexOf("/") == -1) {
            ModuleConfig mc = (ModuleConfig)this.pageContext.getRequest().getAttribute("org.apache.struts.action.MODULE");
            if (mc != null && mc.getPrefix() != null && mc.getPrefix().length() > 1) {
                bundleName = bundleName + mc.getPrefix();
            }
        } else if (bundleName != null && bundleName.endsWith("/")) {
            bundleName = bundleName.substring(0, bundleName.length() - 1);
        }
        return bundleName;
    }

    protected Locale getUserLocale() {
        Locale userLocale = (Locale)this.pageContext.getAttribute("org.apache.struts.action.LOCALE", 3);
        if (userLocale == null) {
            return this.pageContext.getRequest().getLocale();
        }
        return userLocale;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$bea$wlw$netui$tags$AbstractBaseTag == null ? (class$com$bea$wlw$netui$tags$AbstractBaseTag = AbstractBaseTag.class$("com.bea.wlw.netui.tags.AbstractBaseTag")) : class$com$bea$wlw$netui$tags$AbstractBaseTag).desiredAssertionStatus();
        debug = Debug.getInstance((Class)(class$com$bea$wlw$netui$tags$AbstractBaseTag == null ? (class$com$bea$wlw$netui$tags$AbstractBaseTag = AbstractBaseTag.class$("com.bea.wlw.netui.tags.AbstractBaseTag")) : class$com$bea$wlw$netui$tags$AbstractBaseTag));
        logger = Logger.getInstance((Class)(class$com$bea$wlw$netui$tags$AbstractBaseTag == null ? (class$com$bea$wlw$netui$tags$AbstractBaseTag = AbstractBaseTag.class$("com.bea.wlw.netui.tags.AbstractBaseTag")) : class$com$bea$wlw$netui$tags$AbstractBaseTag));
    }
}

