/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.tags.template;

import com.bea.wlw.netui.tags.AbstractBaseTag;
import com.bea.wlw.netui.tags.template.Template;
import com.bea.wlw.netui.tags.template.TemplateConstants;
import com.bea.wlw.netui.util.Bundle;
import com.bea.wlw.netui.util.logging.Logger;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import weblogic.utils.UnsyncStringBuffer;

public class IncludeSection
extends AbstractBaseTag
implements TemplateConstants {
    private String _name;
    private String _default;

    public String getTagName() {
        return "IncludeSection";
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setDefaultPage(String defaultPage) {
        this._default = defaultPage;
    }

    public String getDefaultPage() {
        return this._default;
    }

    public int doStartTag() throws JspException {
        ServletRequest req = this.pageContext.getRequest();
        Template.TemplateContext tc = (Template.TemplateContext)req.getAttribute("_netui.template.sections");
        if (tc == null) {
            String s = Bundle.getString((String)"Tags_TemplateContextMissing");
            Logger.warn((String)IncludeSection.stripBold(s), this.getClass());
            s = this.registerTagError(s);
            if (s != null) {
                JspException e = new JspException(s);
                throw e;
            }
            this.reportErrors();
            this.localRelease();
            return 0;
        }
        if (tc.secs == null) {
            if (this._default != null) {
                return this.callDefault(req);
            }
            String s = Bundle.getString((String)"Tags_TemplateSectionMissing", (Object[])new Object[]{this._name});
            Logger.warn((String)IncludeSection.stripBold(s), this.getClass());
            s = this.registerTagError(s);
            if (s != null) {
                JspException e = new JspException(s);
                throw e;
            }
            this.reportErrors();
            this.localRelease();
            return 0;
        }
        String val = (String)tc.secs.get(this._name);
        if (val == null) {
            if (this._default == null) {
                String s = Bundle.getString((String)"Tags_TemplateSectionMissing", (Object[])new Object[]{this._name});
                Logger.warn((String)IncludeSection.stripBold(s), this.getClass());
                s = this.registerTagError(s);
                if (s != null) {
                    JspException e = new JspException(s);
                    throw e;
                }
                this.reportErrors();
                this.localRelease();
                return 0;
            }
            return this.callDefault(req);
        }
        try {
            JspWriter out = this.pageContext.getOut();
            out.write(val);
        }
        catch (IOException e) {
            String reason = Bundle.getString((String)"TempExcp_WritingContent");
            String s = Bundle.getString((String)"TempExcp_Except", (Object[])new Object[]{"IOException", reason});
            Logger.error((String)s, this.getClass());
            throw new JspException(s, (Throwable)e);
        }
        this.localRelease();
        return 0;
    }

    private int callDefault(ServletRequest req) throws JspException {
        if (!this.defaultExists()) {
            String s = Bundle.getString((String)"TempExcp_MissingDefaultPage", (Object[])new Object[]{this._default});
            Logger.error((String)s, this.getClass());
            s = this.registerTagError(s);
            this.reportErrors();
            this.localRelease();
            return 0;
        }
        try {
            HttpServletResponse resp = (HttpServletResponse)this.pageContext.getResponse();
            RequestDispatcher rd = req.getRequestDispatcher(this._default);
            JspWriter out = this.pageContext.getOut();
            out.flush();
            rd.include(req, (ServletResponse)resp);
            this.localRelease();
            return 0;
        }
        catch (IOException e) {
            String s = Bundle.getString((String)"TempExcp_ExceptIncludeDefault", (Object[])new Object[]{"IOException", this._default});
            Logger.error((String)s, this.getClass());
            e.printStackTrace();
            throw new JspException(s, (Throwable)e);
        }
        catch (ServletException se) {
            String s = Bundle.getString((String)"TempExcp_ExceptIncludeDefault", (Object[])new Object[]{"ServletException", this._default});
            Logger.error((String)s, this.getClass());
            se.printStackTrace();
            throw new JspException(s, (Throwable)se);
        }
    }

    private boolean defaultExists() {
        HttpServletRequest req = (HttpServletRequest)this.pageContext.getRequest();
        String realURI = Template.getRealURI(req, this._default);
        try {
            URL uri = this.pageContext.getServletContext().getResource(realURI);
            return uri != null;
        }
        catch (MalformedURLException e) {
            System.err.println("Malformed URI");
            e.printStackTrace();
            return false;
        }
    }

    protected void localRelease() {
        super.localRelease();
        this._name = null;
        this._default = null;
    }

    static String stripBold(String in) {
        String boldStart = "<b>";
        String boldEnd = "</b>";
        int pos = in.indexOf(boldStart);
        if (pos == -1) {
            return in;
        }
        UnsyncStringBuffer sb = new UnsyncStringBuffer(in.substring(0, pos));
        int fill = pos + boldStart.length();
        if ((pos = in.indexOf(boldEnd, fill)) == -1) {
            return in;
        }
        sb.append(in.substring(fill, pos));
        sb.append(in.substring(pos += boldEnd.length()));
        return sb.toString();
    }
}

