/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.tags.databinding.grid.pager;

import com.bea.wlw.netui.pageflow.util.PageflowTagUtils;
import com.bea.wlw.netui.pageflow.util.URLRewriter;
import com.bea.wlw.netui.pageflow.util.URLRewriterService;
import com.bea.wlw.netui.tags.databinding.SortFilterService;
import com.bea.wlw.netui.tags.databinding.grid.GridComponent;
import com.bea.wlw.netui.tags.databinding.grid.datacontext.DataContext;
import com.bea.wlw.netui.util.Bundle;
import com.bea.wlw.netui.util.debug.Debug;
import com.bea.wlw.netui.util.logging.Logger;
import java.net.MalformedURLException;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import weblogic.utils.UnsyncStringBuffer;

public class Pager
extends GridComponent {
    private static final Debug debug = Debug.getInstance((Class)(class$com$bea$wlw$netui$tags$databinding$grid$pager$Pager == null ? (class$com$bea$wlw$netui$tags$databinding$grid$pager$Pager = Pager.class$("com.bea.wlw.netui.tags.databinding.grid.pager.Pager")) : class$com$bea$wlw$netui$tags$databinding$grid$pager$Pager));
    private static final Logger logger = Logger.getInstance((Class)(class$com$bea$wlw$netui$tags$databinding$grid$pager$Pager == null ? (class$com$bea$wlw$netui$tags$databinding$grid$pager$Pager = Pager.class$("com.bea.wlw.netui.tags.databinding.grid.pager.Pager")) : class$com$bea$wlw$netui$tags$databinding$grid$pager$Pager));
    private static final int DEFAULT_PAGE_SIZE = 10;
    private boolean renderInHeader = false;
    private boolean renderInFooter = false;
    private String action = null;
    private int pageSize = -1;
    static /* synthetic */ Class class$com$bea$wlw$netui$tags$databinding$grid$pager$Pager;

    public String getTagName() {
        return "Pager";
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageSize() {
        if (this.pageSize == -1) {
            return 10;
        }
        return this.pageSize;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getAction() {
        return this.action;
    }

    public void setRenderInFooter(boolean renderInFooter) {
        this.renderInFooter = renderInFooter;
    }

    public boolean getRenderInFooter() {
        return this.renderInFooter;
    }

    public void setRenderInHeader(boolean renderInHeader) {
        this.renderInHeader = renderInHeader;
    }

    public boolean getRenderInHeader() {
        return this.renderInHeader;
    }

    protected void localRelease() {
        super.localRelease();
        this.renderInHeader = false;
        this.renderInFooter = false;
        this.action = null;
        this.pageSize = -1;
    }

    protected int renderStartTag(int state) {
        return 0;
    }

    protected int renderEndTag(int state) throws JspException {
        int pageSize;
        int currentPage;
        String gridName;
        DataContext dc;
        block14: {
            dc = this.getGridContext().getDataContext();
            gridName = this.getGridContext().getName();
            SortFilterService svc = SortFilterService.getInstance(this.pageContext.getRequest());
            currentPage = svc.getCurrentPage(gridName);
            pageSize = this.getPageSize();
            if (currentPage > dc.size() / pageSize) {
                System.err.println("The current page \"" + currentPage + "\" is out of range for this data set; resetting to zero.");
                currentPage = 0;
            }
            try {
                dc.setIterationRange(currentPage * pageSize, currentPage * pageSize + pageSize);
            }
            catch (Exception e) {
                logger.info((Object)("Caught an error setting the iteration range: " + e));
                String msg = e.getLocalizedMessage();
                msg = this.registerTagError(msg);
                if (msg == null) break block14;
                throw new JspException(msg);
            }
        }
        if (this.hasErrors()) {
            this.reportErrors();
            return 6;
        }
        if (state == 1 && this.getRenderInHeader() || state == 5 && this.getRenderInFooter()) {
            int lastPage;
            int n = lastPage = dc.size() % pageSize == 0 ? dc.size() / pageSize : dc.size() / pageSize + 1;
            if (lastPage == 0) {
                lastPage = -1;
            }
            if (Pager.debug.ON) {
                debug.out("currentPage: " + currentPage);
                debug.out("pageSize: " + pageSize);
                debug.out("last page: " + lastPage);
            }
            UnsyncStringBuffer buf = new UnsyncStringBuffer(256);
            String loc = this.formatString("pager.location", new Object[]{new Integer(currentPage + 1), lastPage <= 0 ? new Integer(1) : new Integer(lastPage)});
            buf.append(loc);
            if (lastPage > -1) {
                String url;
                if (currentPage > 0) {
                    url = this.writeURL(this.getAction(), SortFilterService.getInstance(this.pageContext.getRequest()).getQueryParamsMapWithPage(gridName, currentPage - 1));
                    if (Pager.debug.ON) {
                        debug.out("pager.previouspage URL: " + url);
                    }
                    String prev = this.formatString("pager.previouspage", new Object[]{url});
                    buf.append(prev);
                }
                if (lastPage > -1 && currentPage + 1 != lastPage) {
                    url = this.writeURL(this.getAction(), SortFilterService.getInstance(this.pageContext.getRequest()).getQueryParamsMapWithPage(gridName, currentPage + 1));
                    if (Pager.debug.ON) {
                        debug.out("pager.nextpage URL: " + url);
                    }
                    String next = this.formatString("pager.nextpage", new Object[]{url});
                    buf.append(next);
                }
            }
            if (state == 1 && this.getRenderInHeader()) {
                this.write(buf.toString());
            }
            if (state == 5 && this.getRenderInFooter()) {
                this.write(buf.toString());
            }
        }
        return 6;
    }

    private final String writeURL(String where, Map params) throws JspException {
        String url;
        block3: {
            url = null;
            try {
                where = PageflowTagUtils.createActionURL((PageContext)this.pageContext, (String)where);
                url = PageflowTagUtils.computeURL((PageContext)this.pageContext, null, (String)where, null, null, (Map)params, null, (boolean)true);
                String type = URLRewriter.ACTION_UNSECURE;
                if (URLRewriterService.needsSecure((ServletRequest)this.pageContext.getRequest(), (ServletContext)this.pageContext.getServletContext(), (String)url, (boolean)true)) {
                    type = URLRewriter.ACTION_SECURE;
                }
                url = URLRewriterService.rewriteURL((ServletContext)this.pageContext.getServletContext(), (ServletRequest)this.pageContext.getRequest(), (ServletResponse)this.pageContext.getResponse(), (String)url, (String)type);
            }
            catch (MalformedURLException e) {
                System.err.println("MalformedURLException");
                String msg = Bundle.getErrorString((String)"Tags_Pager_malformedURL", (Object[])new Object[]{e.getMessage()});
                msg = this.registerTagError(msg);
                if (msg == null) break block3;
                throw new JspException(msg);
            }
        }
        return url;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

