/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.tags.databinding.grid.datacontext;

import com.bea.wlw.netui.tags.databinding.grid.datacontext.DataContext;
import com.bea.wlw.netui.tags.databinding.grid.datacontext.DataContextException;
import com.bea.wlw.netui.tags.databinding.grid.datacontext.EmptyDataContext;
import com.bea.wlw.netui.tags.databinding.grid.datacontext.RowSetDataContext;
import com.bea.wlw.netui.util.Bundle;
import javax.sql.RowSet;

public class DataContextFactory {
    private DataContextFactory() {
    }

    public static final DataContext createDataContext(Object dataSource) throws DataContextException {
        if (dataSource instanceof RowSet) {
            return new RowSetDataContext((RowSet)dataSource);
        }
        if (dataSource == null) {
            return DataContextFactory.createEmptyDataContext();
        }
        DataContextException dce = new DataContextException("Can not create a Grid DataContext from a data source of type \"" + (dataSource != null ? dataSource.getClass().getName() : "null"));
        if (dataSource == null) {
            dce.setLocalizedMessage(Bundle.getErrorString((String)"DataContextFactory_nullDataSource"));
        } else {
            dce.setLocalizedMessage(Bundle.getErrorString((String)"DataContextFactory_invalidDataSource", (Object[])new Object[]{dataSource.getClass().getName()}));
        }
        throw dce;
    }

    public static final DataContext createEmptyDataContext() {
        return new EmptyDataContext();
    }
}

