/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.tags.databinding.grid;

import com.bea.wlw.netui.tags.AbstractPageError;
import com.bea.wlw.netui.tags.DataAccessProvider;
import com.bea.wlw.netui.tags.DataSourceTag;
import com.bea.wlw.netui.tags.ErrorReporter;
import com.bea.wlw.netui.tags.EvalErrorInfo;
import com.bea.wlw.netui.tags.TagErrorInfo;
import com.bea.wlw.netui.tags.databinding.grid.DefaultGridRenderer;
import com.bea.wlw.netui.tags.databinding.grid.GridContext;
import com.bea.wlw.netui.tags.databinding.grid.datacontext.DataContext;
import com.bea.wlw.netui.tags.databinding.grid.datacontext.DataContextException;
import com.bea.wlw.netui.tags.databinding.grid.datacontext.DataContextFactory;
import com.bea.wlw.netui.tags.databinding.grid.style.GridStyleContext;
import com.bea.wlw.netui.util.Bundle;
import com.bea.wlw.netui.util.debug.Debug;
import com.bea.wlw.netui.util.exception.LocalizedUnsupportedOperationException;
import java.util.ArrayList;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import weblogic.utils.UnsyncStringBuffer;

public class Grid
extends DataSourceTag
implements DataAccessProvider,
ErrorReporter {
    private static final Debug debug;
    public static final int START = -1;
    public static final int INIT = 0;
    public static final int HEAD_PAGER = 1;
    public static final int HEADER = 2;
    public static final int ROWS = 3;
    public static final int FOOTER = 4;
    public static final int FOOT_PAGER = 5;
    public static final int END = 6;
    private GridContext gridContext = new GridContext();
    private UnsyncStringBuffer contentBuffer = null;
    private int currentState = -1;
    private boolean autoRender = false;
    private String imageRoot = null;
    private ArrayList localErrors = null;
    static /* synthetic */ Class class$com$bea$wlw$netui$tags$databinding$grid$Grid;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$bea$wlw$netui$tags$DataAccessProvider;

    public void setImageRoot(String imageRoot) {
        this.gridContext.setImageRoot(imageRoot);
    }

    public String getImageRoot() {
        return this.gridContext.getImageRoot();
    }

    public String getTagName() {
        return "Grid";
    }

    public final DataContext getDataContext() {
        return this.gridContext.getDataContext();
    }

    public final GridContext getGridContext() {
        return this.gridContext;
    }

    public final void addContent(String content) {
        if (this.contentBuffer == null) {
            int size = content != null ? 5 * content.length() : 1024;
            this.contentBuffer = new UnsyncStringBuffer(size);
        }
        this.contentBuffer.append(content);
    }

    public final String getContent() {
        if (this.contentBuffer == null) {
            return null;
        }
        return this.contentBuffer.toString();
    }

    public void setName(String name) {
        String localName = (String)this.evaluateExpression(name, "name");
        if (this.hasErrors()) {
            return;
        }
        this.gridContext.setName(localName);
    }

    public String getName() {
        return this.gridContext.getName();
    }

    public void setAutoRender(boolean autoRender) {
        this.autoRender = autoRender;
    }

    public boolean getAutoRender() {
        return this.autoRender;
    }

    public int getRenderState() {
        return this.currentState;
    }

    public void setGridStyle(GridStyleContext gridStyle) {
        this.gridContext.setGridStyle(gridStyle);
    }

    public int doStartTag() throws JspException {
        if (this.hasErrors()) {
            return 0;
        }
        this.gridContext.setDataSource(this.qualifyAttribute(this.getDataSource()));
        if (this.gridContext.getDataSource() != null) {
            Object dataObject = this.evaluateDataSource();
            if (Grid.debug.ON) {
                debug.out("name: " + this.getDataSource());
                debug.out("dataSource type: " + (dataObject != null ? dataObject.getClass().getName() : "null"));
            }
            if (this.hasErrors()) {
                if (Grid.debug.ON) {
                    debug.out("Reporting Errors from Grid with data source: " + this.gridContext.getDataSource());
                }
                return 0;
            }
            try {
                this.gridContext.setDataContext(DataContextFactory.createDataContext(dataObject));
            }
            catch (DataContextException dce) {
                String msg = null;
                msg = dataObject == null ? Bundle.getErrorString((String)"Tags_Grid_DataContextException_null", (Object[])new Object[]{dce.getMessage()}) : Bundle.getErrorString((String)"Tags_Grid_DataContextException", (Object[])new Object[]{dataObject.getClass().getName(), dce.getMessage()});
                msg = this.registerTagError(msg);
                if (msg == null) {
                    return 0;
                }
                throw new JspException(msg);
            }
        }
        this.currentState = 0;
        return 2;
    }

    public int doAfterBody() {
        if (Grid.debug.ON) {
            debug.here();
            debug.out("grid render state: " + this.stateToString(this.currentState));
            debug.out("gridStyle: " + this.gridContext.getGridStyle());
            debug.out("hasErrors: " + this.hasErrors());
        }
        if (this.hasErrors()) {
            return 0;
        }
        this.addContent(this.bodyContent.getString());
        this.bodyContent.clearBody();
        if (this.currentState == 0) {
            this.currentState = 1;
            return 2;
        }
        if (this.currentState == 1) {
            this.currentState = 2;
            this.addContent(this.renderTableStyle());
            if (this.getAutoRender()) {
                this.addContent(DefaultGridRenderer.autoGenerateHeader(this.getGridContext()));
                this.currentState = 3;
            } else {
                return 2;
            }
        }
        if (this.currentState == 2) {
            this.currentState = 3;
            if (!this.getAutoRender() && this.getDataContext().hasNext()) {
                this.getDataContext().next();
                return 2;
            }
        }
        if (this.currentState == 3) {
            if (this.getAutoRender()) {
                this.addContent(DefaultGridRenderer.autoGenerateRows(this.getGridContext()));
                this.currentState = 4;
            } else {
                if (this.getDataContext().hasNext()) {
                    this.getDataContext().next();
                } else {
                    this.currentState = 4;
                }
                return 2;
            }
        }
        if (this.currentState == 4) {
            this.addContent("</table>");
            this.currentState = 5;
            return 2;
        }
        if (this.currentState == 5) {
            this.currentState = 6;
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        if (this.hasErrors()) {
            this.reportErrors();
        } else if (this.contentBuffer != null) {
            this.write(this.contentBuffer.toString());
        }
        this.localRelease();
        return 6;
    }

    protected void localRelease() {
        super.localRelease();
        if (this.bodyContent != null) {
            this.bodyContent.clearBody();
        }
        this.currentState = -1;
        this.gridContext = new GridContext();
        this.contentBuffer = null;
        this.autoRender = false;
        this.imageRoot = null;
        this.localErrors = null;
    }

    public void addError(AbstractPageError ape) {
        if (Grid.debug.ON) {
            debug.out("Adding error: " + ape);
            if (ape instanceof TagErrorInfo) {
                debug.out("tei.message = " + ((TagErrorInfo)ape).message);
            }
            Thread.currentThread();
            Thread.dumpStack();
        }
        if (this.localErrors == null) {
            this.localErrors = new ArrayList();
        }
        this.localErrors.add(ape);
        ape.errorNo = this.localErrors.size();
    }

    protected boolean hasErrors() {
        return this.localErrors != null;
    }

    public boolean isReporting() {
        return true;
    }

    public ArrayList returnErrors() {
        return this.localErrors;
    }

    protected String getErrorsReport() {
        if (Grid.debug.ON) {
            debug.here();
        }
        if (!$assertionsDisabled && this.localErrors == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.localErrors.size() <= 0) {
            throw new AssertionError();
        }
        int cnt = this.localErrors.size();
        UnsyncStringBuffer sb = new UnsyncStringBuffer(512);
        String s = Bundle.getString((String)"Tags_Grid_ErrorHeader", (Object[])new Object[]{this.getName(), Integer.toString(cnt)});
        sb.append(s);
        Object[] args = new Object[5];
        int i = 0;
        while (i < cnt) {
            EvalErrorInfo e;
            Object o = this.localErrors.get(i);
            if (o instanceof EvalErrorInfo) {
                e = (EvalErrorInfo)o;
                if (!$assertionsDisabled && e == null) {
                    throw new AssertionError();
                }
                args[0] = e.tagType;
                args[1] = Bundle.getString((String)"Expression_Error");
                args[2] = e.attr;
                args[3] = e.expression;
                args[4] = e.evalExcp.getMessage();
                s = Bundle.getString((String)"Tags_Grid_ExpressionErrorItem", (Object[])args);
            } else if (o instanceof TagErrorInfo) {
                e = (TagErrorInfo)o;
                if (!$assertionsDisabled && e == null) {
                    throw new AssertionError();
                }
                args[0] = e.tagType;
                args[1] = Bundle.getString((String)"Tag_Error");
                args[2] = e.message;
                s = Bundle.getString((String)"Tags_Grid_ErrorItem", (Object[])args);
            }
            sb.append(s);
            ++i;
        }
        s = Bundle.getString((String)"Tags_Grid_ErrorFooter");
        sb.append(s);
        return sb.toString();
    }

    public int getCurrentIndex() {
        return this.getDataContext().getCurrentIndex();
    }

    public Object getCurrentItem() {
        return this.getDataContext().getCurrentItem();
    }

    public String getDataSource() {
        return this.gridContext.getDataSource();
    }

    public void setDataSource(String dataSource) {
        this.gridContext.setDataSource(dataSource);
    }

    public Object getCurrentMetadata() {
        LocalizedUnsupportedOperationException uoe = new LocalizedUnsupportedOperationException("The " + this.getTagName() + "does not export metadata for its iterated items.");
        uoe.setLocalizedMessage(Bundle.getErrorString((String)"Tags_DataAccessProvider_metadataUnsupported", (Object[])new Object[]{this.getTagName()}));
        throw uoe;
    }

    public DataAccessProvider getProviderParent() {
        return (DataAccessProvider)TagSupport.findAncestorWithClass((Tag)this, (Class)(class$com$bea$wlw$netui$tags$DataAccessProvider == null ? (class$com$bea$wlw$netui$tags$DataAccessProvider = Grid.class$("com.bea.wlw.netui.tags.DataAccessProvider")) : class$com$bea$wlw$netui$tags$DataAccessProvider));
    }

    private final String renderTableStyle() {
        GridStyleContext c = this.gridContext.getGridStyle();
        if (c != null) {
            UnsyncStringBuffer buf = new UnsyncStringBuffer("<table");
            buf.append(c.renderTableStyle());
            buf.append(">");
            return buf.toString();
        }
        return "<table>";
    }

    private String stateToString(int state) {
        if (state == 2) {
            return "HEADER";
        }
        if (state == 3) {
            return "ROWS";
        }
        if (state == 4) {
            return "FOOTER";
        }
        if (state == 0) {
            return "INIT";
        }
        if (state == 1) {
            return "HEAD_PAGER";
        }
        if (state == 5) {
            return "FOOT_PAGER";
        }
        return "START";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$bea$wlw$netui$tags$databinding$grid$Grid == null ? (class$com$bea$wlw$netui$tags$databinding$grid$Grid = Grid.class$("com.bea.wlw.netui.tags.databinding.grid.Grid")) : class$com$bea$wlw$netui$tags$databinding$grid$Grid).desiredAssertionStatus();
        debug = Debug.getInstance((Class)(class$com$bea$wlw$netui$tags$databinding$grid$Grid == null ? (class$com$bea$wlw$netui$tags$databinding$grid$Grid = Grid.class$("com.bea.wlw.netui.tags.databinding.grid.Grid")) : class$com$bea$wlw$netui$tags$databinding$grid$Grid));
    }
}

