/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.pageflow.scoping.internal;

import com.bea.wlw.netui.pageflow.scoping.ScopedRequest;
import com.bea.wlw.netui.pageflow.scoping.ScopedServletContext;
import com.bea.wlw.netui.pageflow.scoping.ScopedServletUtils;
import com.bea.wlw.netui.pageflow.scoping.internal.ScopedAttributeContainer;
import com.bea.wlw.netui.pageflow.scoping.internal.ScopedMultipartInputStream;
import com.bea.wlw.netui.pageflow.scoping.internal.ScopedRequestDispatcher;
import com.bea.wlw.netui.pageflow.scoping.internal.ScopedSession;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class ScopedRequestImpl
extends HttpServletRequestWrapper
implements ScopedRequest {
    private String _requestURI;
    private ScopedSession _session;
    private ServletContext _context;
    private String _forwardedURI;
    private ScopedAttributeContainer _scopedContainer;
    private ArrayList _listenScopes;
    private String _overridePathInfo = null;
    private boolean _isActiveRequest = false;
    private boolean _useScopedSession = false;
    private HashMap _seeThroughAttrs = new HashMap();
    private static final String OUR_SESSION_ATTR_NAME;
    private static final String STORED_ATTRS_ATTR_NAME;
    private static final String BOUNDARYSTR = "boundary=";
    private static final String REQUEST_ENSURED = "com.bea.wlw.runtime.core.dispatcher.AppManager.ensured";
    private static final Logger logger;
    static /* synthetic */ Class class$com$bea$wlw$netui$pageflow$scoping$ScopedRequest;
    static /* synthetic */ Class class$com$bea$wlw$netui$pageflow$scoping$internal$ScopedRequestImpl;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ScopedRequestImpl(HttpServletRequest request, String overrideRequestURI, Object scopeKey, ServletContext context, boolean useScopedSession) {
        super(request);
        this._scopedContainer = new ScopedAttributeContainer(scopeKey);
        this._requestURI = overrideRequestURI != null ? request.getContextPath() + overrideRequestURI : request.getContextPath();
        if (!$assertionsDisabled && context instanceof ScopedServletContext) {
            throw new AssertionError((Object)"for now, we don't use ScopedServletContxt");
        }
        this._context = context;
        this._useScopedSession = useScopedSession;
        this.registerOuterAttribute(REQUEST_ENSURED);
    }

    public ScopedRequestImpl(HttpServletRequest request, String overrideRequestURI, Object scopeKey, ServletContext context) {
        this(request, overrideRequestURI, scopeKey, context, false);
    }

    public String getRequestedSessionId() {
        if (this._useScopedSession) {
            return this._scopedContainer.getScopedName(this.getOuterRequest().getRequestedSessionId());
        }
        return super.getRequestedSessionId();
    }

    public String getRequestURI() {
        return this._requestURI;
    }

    public void setRequestURI(String uri) {
        this._requestURI = uri;
    }

    public StringBuffer getRequestURL() {
        HttpServletRequest outerRequest = this.getOuterRequest();
        StringBuffer url = new StringBuffer(outerRequest.getScheme());
        url.append("://").append(outerRequest.getServerName());
        url.append(':').append(outerRequest.getServerPort());
        url.append(this.getRequestURI());
        return url;
    }

    public String getServletPath() {
        return ScopedServletUtils.getRelativeURI(this);
    }

    public HttpSession getSession(boolean createIfNotExist) {
        if (this._useScopedSession) {
            HttpSession realSession;
            if (this._session == null && (realSession = this.getOuterRequest().getSession(createIfNotExist)) != null) {
                String attrName = this._scopedContainer.getScopedName(OUR_SESSION_ATTR_NAME);
                this._session = (ScopedSession)realSession.getAttribute(attrName);
                if (this._session == null && createIfNotExist) {
                    this._session = new ScopedSession(realSession, this._context, this.getScopeKey());
                    realSession.setAttribute(attrName, (Object)this._session);
                }
            }
            if (this._session != null) {
                this._session.setSession(this.getOuterRequest().getSession(), this._context);
            }
            return this._session;
        }
        return super.getSession(createIfNotExist);
    }

    public final HttpSession getSession() {
        return this.getSession(true);
    }

    public String getParameter(String paramName) {
        String retVal = this.getLocalParameter(paramName);
        if (retVal == null) {
            retVal = this.getListenScopeParameter(paramName);
        }
        return retVal;
    }

    public String getLocalParameter(String paramName) {
        ServletRequest request = this.getRequest();
        String retVal = request.getParameter(this._scopedContainer.getScopedName(paramName));
        if (retVal == null && this._isActiveRequest && paramName.startsWith("_autoscope_")) {
            retVal = request.getParameter(paramName);
        }
        return retVal;
    }

    public String getListenScopeParameter(String paramName) {
        String retVal = null;
        if (this._listenScopes != null) {
            int i = 0;
            int len = this._listenScopes.size();
            while (retVal == null && i < len) {
                String key = ScopedServletUtils.getScopedName(paramName, this._listenScopes.get(i));
                retVal = this.getRequest().getParameter(key);
                ++i;
            }
        }
        return retVal;
    }

    public Enumeration getParameterNames() {
        ArrayList<String> paramNames = new ArrayList<String>();
        Enumeration e = this.getRequest().getParameterNames();
        while (e.hasMoreElements()) {
            String scopedParamName = (String)e.nextElement();
            if (this._scopedContainer.isInScope(scopedParamName)) {
                paramNames.add(this._scopedContainer.removeScope(scopedParamName));
                continue;
            }
            if (this._isActiveRequest && scopedParamName.startsWith("_autoscope_")) {
                paramNames.add(scopedParamName);
                continue;
            }
            if (this._listenScopes == null) continue;
            int i = 0;
            int len = this._listenScopes.size();
            while (i < len) {
                Object scope = this._listenScopes.get(i);
                if (ScopedAttributeContainer.isInScope(scopedParamName, scope)) {
                    paramNames.add(ScopedAttributeContainer.removeScope(scopedParamName, scope));
                }
                ++i;
            }
        }
        return Collections.enumeration(paramNames);
    }

    public String[] getParameterValues(String paramName) {
        ServletRequest request = this.getRequest();
        String[] retVals = request.getParameterValues(this._scopedContainer.getScopedName(paramName));
        if (retVals == null && this._isActiveRequest && paramName.startsWith("_autoscope_")) {
            retVals = request.getParameterValues(paramName);
        }
        if (retVals == null && this._listenScopes != null) {
            int i = 0;
            int len = this._listenScopes.size();
            while (retVals == null && i < len) {
                String key = ScopedServletUtils.getScopedName(paramName, this._listenScopes.get(i));
                retVals = request.getParameterValues(key);
                ++i;
            }
        }
        return retVals;
    }

    public Map getParameterMap() {
        HashMap map = new HashMap();
        Iterator i = this.getRequest().getParameterMap().entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String scopedParamName = (String)entry.getKey();
            if (this._scopedContainer.isInScope(scopedParamName)) {
                map.put(this._scopedContainer.removeScope(scopedParamName), entry.getValue());
                continue;
            }
            if (this._isActiveRequest && scopedParamName.startsWith("_autoscope_")) {
                map.put(scopedParamName, entry.getValue());
                continue;
            }
            if (this._listenScopes == null) continue;
            int j = 0;
            int len = this._listenScopes.size();
            while (j < len) {
                if (ScopedAttributeContainer.isInScope(scopedParamName, this._listenScopes.get(j))) {
                    map.put(ScopedAttributeContainer.removeScope(scopedParamName, this._listenScopes.get(j)), entry.getValue());
                }
                ++j;
            }
        }
        return map;
    }

    public void addListenScope(Object scopeKey) {
        if (!$assertionsDisabled && scopeKey == null) {
            throw new AssertionError();
        }
        if (this._listenScopes == null) {
            this._listenScopes = new ArrayList();
        }
        this._listenScopes.add(scopeKey);
    }

    public RequestDispatcher getRequestDispatcher(String uri) {
        return new ScopedRequestDispatcher(uri);
    }

    public void doForward() {
        String forwardURI = this._forwardedURI;
        if (forwardURI != null) {
            if (!forwardURI.startsWith("/")) {
                logger.error((Object)("Invalid forward URI " + forwardURI));
                this._requestURI = forwardURI;
            }
            this._requestURI = this.getOuterRequest().getContextPath() + this.getForwardedURI();
        } else {
            this._requestURI = null;
        }
    }

    public void setForwardedURI(String uri) {
        this._forwardedURI = uri;
    }

    public String getForwardedURI() {
        return this._forwardedURI;
    }

    public boolean didRedirect() {
        return false;
    }

    public void persistAttributes() {
        String attrName = this._useScopedSession ? STORED_ATTRS_ATTR_NAME : this.getScopedName(STORED_ATTRS_ATTR_NAME);
        this.getSession().setAttribute(attrName, (Object)this._scopedContainer.getSerializableAttrs());
    }

    public void restoreAttributes() {
        String attrName = this._useScopedSession ? STORED_ATTRS_ATTR_NAME : this.getScopedName(STORED_ATTRS_ATTR_NAME);
        Map savedAttrs = (Map)this.getSession().getAttribute(attrName);
        Map currentAttrs = this._scopedContainer.getAttrMap();
        if (savedAttrs != null) {
            if (currentAttrs != null) {
                savedAttrs.putAll(currentAttrs);
            }
            this._scopedContainer.setAttrMap(savedAttrs);
        }
    }

    public final HttpServletRequest getOuterRequest() {
        return (HttpServletRequest)this.getRequest();
    }

    public final Object getAttribute(String attrName) {
        if (this._seeThroughAttrs.containsKey(attrName)) {
            return this.getRequest().getAttribute(attrName);
        }
        return this._scopedContainer.getAttribute(attrName);
    }

    public final void setAttribute(String attrName, Object o) {
        if (this._seeThroughAttrs.containsKey(attrName)) {
            this.getRequest().setAttribute(attrName, o);
        } else {
            this._scopedContainer.setAttribute(attrName, o);
        }
    }

    public final Enumeration getAttributeNames() {
        ArrayList<Object> list = new ArrayList<Object>();
        Iterator i = this._seeThroughAttrs.keySet().iterator();
        while (i.hasNext()) {
            list.add(i.next());
        }
        Enumeration e = this._scopedContainer.getAttributeNames();
        while (e.hasMoreElements()) {
            list.add(e.nextElement());
        }
        return Collections.enumeration(list);
    }

    public final void removeAttribute(String attrName) {
        if (this._seeThroughAttrs.containsKey(attrName)) {
            this.getRequest().removeAttribute(attrName);
        }
        this._scopedContainer.removeAttribute(attrName);
    }

    public void registerOuterAttribute(String attrName) {
        this._seeThroughAttrs.put(attrName, null);
    }

    public final Object getScopeKey() {
        return this._scopedContainer.getScopeKey();
    }

    public void renameScope(Object newScopeKey) {
        if (this._useScopedSession) {
            HttpSession realSession = this.getOuterRequest().getSession(false);
            if (realSession != null) {
                String realSessionAttr = this._scopedContainer.getScopedName(OUR_SESSION_ATTR_NAME);
                Object ourSession = realSession.getAttribute(realSessionAttr);
                realSessionAttr = ScopedServletUtils.getScopedName(OUR_SESSION_ATTR_NAME, newScopeKey);
                realSession.setAttribute(realSessionAttr, ourSession);
            }
            if (this._session != null) {
                this._session.renameScope(newScopeKey);
            }
        }
        this._scopedContainer.renameScope(newScopeKey);
    }

    public static void renameSessionScope(Object oldScopeKey, Object newScopeKey, HttpServletRequest outerRequest) {
        HttpSession realSession = outerRequest.getSession(false);
        if (realSession != null) {
            String realSessionAttr = ScopedServletUtils.getScopedName(OUR_SESSION_ATTR_NAME, oldScopeKey);
            Object ourSession = realSession.getAttribute(realSessionAttr);
            realSessionAttr = ScopedServletUtils.getScopedName(OUR_SESSION_ATTR_NAME, newScopeKey);
            realSession.setAttribute(realSessionAttr, ourSession);
        }
    }

    public String getPathInfo() {
        return this._overridePathInfo;
    }

    public void setPathInfo(String pathInfo) {
        this._overridePathInfo = pathInfo;
    }

    public void setActiveRequest() {
        this._isActiveRequest = true;
    }

    public final String getScopedName(String baseName) {
        return this._scopedContainer.getScopedName(baseName);
    }

    public ServletInputStream getInputStream() throws IOException {
        String contentType = this.getContentType();
        if (contentType != null && contentType.startsWith("multipart/form-data")) {
            int boundaryPos = contentType.indexOf(BOUNDARYSTR);
            if (boundaryPos == -1) {
                logger.error((Object)("Could not find multipart boundary in request " + this.getRequestURI()));
                return super.getInputStream();
            }
            String boundary = contentType.substring(boundaryPos + BOUNDARYSTR.length());
            if (boundary.charAt(0) == '\"') {
                boundary = boundary.substring(1, boundary.indexOf(34, 1));
            }
            return new ScopedMultipartInputStream(this.getRequest().getInputStream(), boundary, this.getScopeKey());
        }
        return super.getInputStream();
    }

    public boolean hasListenScopes() {
        return this._listenScopes != null && this._listenScopes.size() > 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$bea$wlw$netui$pageflow$scoping$internal$ScopedRequestImpl == null ? (class$com$bea$wlw$netui$pageflow$scoping$internal$ScopedRequestImpl = ScopedRequestImpl.class$("com.bea.wlw.netui.pageflow.scoping.internal.ScopedRequestImpl")) : class$com$bea$wlw$netui$pageflow$scoping$internal$ScopedRequestImpl).desiredAssertionStatus();
        OUR_SESSION_ATTR_NAME = (class$com$bea$wlw$netui$pageflow$scoping$ScopedRequest == null ? (class$com$bea$wlw$netui$pageflow$scoping$ScopedRequest = ScopedRequestImpl.class$("com.bea.wlw.netui.pageflow.scoping.ScopedRequest")) : class$com$bea$wlw$netui$pageflow$scoping$ScopedRequest).getName() + ".scopedSession";
        STORED_ATTRS_ATTR_NAME = (class$com$bea$wlw$netui$pageflow$scoping$ScopedRequest == null ? (class$com$bea$wlw$netui$pageflow$scoping$ScopedRequest = ScopedRequestImpl.class$("com.bea.wlw.netui.pageflow.scoping.ScopedRequest")) : class$com$bea$wlw$netui$pageflow$scoping$ScopedRequest).getName() + ".storedAttrs";
        logger = Logger.getLogger((Class)(class$com$bea$wlw$netui$pageflow$scoping$internal$ScopedRequestImpl == null ? (class$com$bea$wlw$netui$pageflow$scoping$internal$ScopedRequestImpl = ScopedRequestImpl.class$("com.bea.wlw.netui.pageflow.scoping.internal.ScopedRequestImpl")) : class$com$bea$wlw$netui$pageflow$scoping$internal$ScopedRequestImpl));
    }
}

