/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.pageflow.scoping.internal;

import com.bea.wlw.netui.pageflow.scoping.internal.ScopedAttributeContainer;
import java.io.IOException;
import javax.servlet.ServletInputStream;

public class ScopedMultipartInputStream
extends ServletInputStream {
    private ServletInputStream _base;
    private int _lastByte = -1;
    private String _multipartBoundary;
    private char[] _readAhead = new char[0];
    private int _readAheadPos = 0;
    private int _readAheadLength = -1;
    private Object _scopeKey;
    private boolean _foundBoundary = false;
    private boolean _discardLine = false;
    private static final String MULTIPART_DELIMITER = "--";
    private static final String FORMDATA_NAME_STR = "form-data; name=\"";
    private static final int MAX_HEADER_LINE = 2048;

    protected ScopedMultipartInputStream(ServletInputStream base, String multipartBoundary, Object scopeKey) {
        this._base = base;
        this._multipartBoundary = MULTIPART_DELIMITER + multipartBoundary;
        this._scopeKey = scopeKey;
    }

    public int read() throws IOException {
        boolean hitEOL;
        int c = -1;
        if (this._readAhead == null) {
            return -1;
        }
        if (this._readAheadPos < this._readAheadLength) {
            c = this._readAhead[this._readAheadPos++];
            if (this._readAheadPos != this._readAheadLength) {
                this._lastByte = c;
                return c;
            }
        } else if (this._lastByte != -1) {
            c = this._base.read();
        }
        boolean bl = hitEOL = this._lastByte == 13 && c == 10;
        if (this._discardLine && hitEOL) {
            this._discardLine = false;
        } else {
            if (this._foundBoundary && c != -1 && !this._discardLine && !hitEOL) {
                int namePos;
                String line = this.getSingleLine(c, 2048);
                if (line == null || line.equals("\r\n")) {
                    this._foundBoundary = false;
                } else if (line.startsWith("Content-Disposition:") && (namePos = line.indexOf(FORMDATA_NAME_STR)) != -1) {
                    int quote;
                    String start = line.substring(0, namePos += FORMDATA_NAME_STR.length());
                    String end = line.substring(namePos);
                    String name = end.substring(0, quote = end.indexOf(34));
                    if (ScopedAttributeContainer.isInScope(name, this._scopeKey)) {
                        end = end.substring(quote);
                        this.replaceLine(start + ScopedAttributeContainer.removeScope(name, this._scopeKey) + end);
                    }
                }
                return this.read();
            }
            if (!this._foundBoundary && (hitEOL || this._lastByte == -1)) {
                String line = this.getSingleLine(c, this._multipartBoundary.length());
                if (line != null && line.startsWith(this._multipartBoundary)) {
                    this._foundBoundary = true;
                }
                return this.read();
            }
        }
        this._lastByte = c;
        return c;
    }

    public int readLine(byte[] bytes, int start, int offset) throws IOException {
        return this._base.readLine(bytes, start, offset);
    }

    private String getSingleLine(int initByte, int maxBytes) throws IOException {
        this._readAhead = new char[maxBytes];
        int lastByte = -1;
        int c = -1;
        int count = 0;
        if (initByte != -1) {
            this._readAhead[count++] = (char)initByte;
        }
        while ((c = this._base.read()) != -1) {
            this._readAhead[count++] = (char)c;
            if (c == 10 && lastByte == 13) break;
            lastByte = c;
            if (count < maxBytes) continue;
            if (c == 10) break;
            this._discardLine = true;
            break;
        }
        if (c == -1 && lastByte == -1) {
            this._readAhead = null;
            return null;
        }
        this._readAheadPos = 0;
        this._readAheadLength = count;
        return new String(this._readAhead, 0, this._readAheadLength);
    }

    private final void replaceLine(String line) {
        this._readAhead = line.toCharArray();
        this._readAheadPos = 0;
        this._readAheadLength = this._readAhead.length;
    }
}

