/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.script.el.util;

import com.bea.wlw.netui.script.el.ExpressionParseException;
import com.bea.wlw.netui.script.el.ParsedExpression;
import com.bea.wlw.netui.script.el.VariableResolver;
import com.bea.wlw.netui.script.el.parser.NetUIELParser;
import com.bea.wlw.netui.script.el.parser.ParseException;
import com.bea.wlw.netui.script.el.parser.TokenMgrError;
import com.bea.wlw.netui.util.cache.PropertyCache;
import com.bea.wlw.netui.util.logging.Logger;
import com.bea.wlw.netui.util.type.TypeUtils;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class ParseUtils {
    private static final Logger _logger = Logger.getInstance((Class)(class$com$bea$wlw$netui$script$el$util$ParseUtils == null ? (class$com$bea$wlw$netui$script$el$util$ParseUtils = ParseUtils.class$("com.bea.wlw.netui.script.el.util.ParseUtils")) : class$com$bea$wlw$netui$script$el$util$ParseUtils));
    private static final Map parsedCache = new HashMap();
    static /* synthetic */ Class class$com$bea$wlw$netui$script$el$util$ParseUtils;

    private ParseUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ParsedExpression parse(String exprStr) {
        Object obj = parsedCache.get(exprStr);
        if (obj != null) {
            return (ParsedExpression)obj;
        }
        try {
            StringReader reader = new StringReader(exprStr);
            NetUIELParser learn = new NetUIELParser(reader);
            ParsedExpression expr = learn.parse();
            expr.seal();
            Map map = parsedCache;
            synchronized (map) {
                parsedCache.put(exprStr, expr);
            }
            return expr;
        }
        catch (ParseException e) {
            String msg = "Error occurred parsing expression \"" + exprStr + "\".";
            if (_logger.isErrorEnabled()) {
                _logger.error((Object)msg, (Throwable)e);
            }
            throw new ExpressionParseException(msg, e);
        }
        catch (TokenMgrError tm) {
            String msg = "Error occurred parsing expression \"" + exprStr + "\".";
            if (_logger.isErrorEnabled()) {
                _logger.error((Object)msg, (Throwable)tm);
            }
            throw new ExpressionParseException(msg, tm);
        }
    }

    public static Object evaluate(String exprStr, VariableResolver vr) {
        ParsedExpression expr = ParseUtils.parse(exprStr);
        return expr.evaluate(vr);
    }

    public static void update(String exprStr, Object value, VariableResolver vr) {
        ParsedExpression expr = ParseUtils.parse(exprStr);
        expr.update(value, vr);
    }

    public static Class getPropertyType(Object value, String name, PropertyCache cache) {
        Class<?> type = value.getClass();
        Field f = cache.getField(type, name);
        if (f != null) {
            return f.getType();
        }
        Method m = cache.getPropertySetter(type, name);
        if (m == null) {
            String msg = "Can not find setter method for property \"" + name + "\" on object of type \"" + value.getClass() + "\".";
            if (_logger.isErrorEnabled()) {
                _logger.error((Object)msg);
            }
            throw new RuntimeException(msg);
        }
        return m.getParameterTypes()[0];
    }

    public static Object getProperty(Object value, String name, PropertyCache cache) {
        Class<?> type = value.getClass();
        Field f = cache.getField(type, name);
        if (f != null) {
            try {
                return f.get(value);
            }
            catch (Exception e) {
                String msg = "An error occurred evaluating the field \"" + name + "\" on an object of type \"" + type + "\".";
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)msg, (Throwable)e);
                }
                throw new RuntimeException(msg, e);
            }
        }
        Method m = cache.getPropertyGetter(type, name);
        if (m != null) {
            try {
                return m.invoke(value, null);
            }
            catch (Exception e) {
                String msg = "An error occurred invoking a getter for the property  \"" + name + "\" on an object of type \"" + type + "\".";
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)msg, (Throwable)e);
                }
                throw new RuntimeException(msg, e);
            }
        }
        String msg = "Could not find property or field \"" + name + "\" on object of type \"" + type + "\"";
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)msg);
        }
        throw new RuntimeException(msg);
    }

    public static Object convertType(Object value, Class toType) {
        try {
            if (value != null && !(value instanceof String) && !(value instanceof String[])) {
                return value;
            }
            if (toType.isArray()) {
                if (value == null) {
                    return null;
                }
                Class<?> compType = toType.getComponentType();
                String[] strs = null;
                strs = value.getClass().isArray() ? (String[])value : new String[]{(String)value};
                Object tgt = Array.newInstance(compType, strs.length);
                int i = 0;
                while (i < strs.length) {
                    Object o = null;
                    try {
                        o = TypeUtils.convertToObject((String)strs[i], compType);
                    }
                    catch (IllegalArgumentException e) {
                        String msg = "Can not set Object types via expressions that are not supported by the set of registered type converters.  Cause: " + e;
                        if (_logger.isErrorEnabled()) {
                            _logger.error((Object)msg, (Throwable)e);
                        }
                        throw new RuntimeException(msg, e);
                    }
                    Array.set(tgt, i, o);
                    ++i;
                }
                return tgt;
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("convert value \"" + value + "\" to type: " + toType));
            }
            try {
                return TypeUtils.convertToObject((String)((String)value), (Class)toType);
            }
            catch (IllegalArgumentException e) {
                String msg = "The type \"" + toType.getName() + "\" can not be set through XScript with the update value \"" + value + "\"";
                if (_logger.isErrorEnabled()) {
                    _logger.error((Object)msg, (Throwable)e);
                }
                throw new RuntimeException(msg, e);
            }
        }
        catch (Exception e) {
            String msg = "Unable to convert a value of type \"" + value.getClass() + "\" to the array element type of \"" + toType + "\".  Cause: " + e;
            if (_logger.isErrorEnabled()) {
                _logger.error((Object)msg, (Throwable)e);
            }
            throw new RuntimeException(msg, e);
        }
    }

    public static void printStack(String message, Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.flush();
        pw.close();
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)message, t);
        } else {
            System.err.println(message + "Cause: " + sw.toString());
        }
    }

    public static String getContextString(String[] contexts) {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        if (contexts != null) {
            int i = 0;
            while (i < contexts.length) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(contexts[i]);
                ++i;
            }
        }
        buf.append("]");
        return buf.toString();
    }

    public static Throwable getRootCause(Throwable t) {
        Throwable root = t;
        while (root.getCause() != null) {
            root = root.getCause();
        }
        return root;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

