/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.script.el;

import com.bea.wlw.netui.script.Expression;
import com.bea.wlw.netui.script.el.ParsedExpression;
import com.bea.wlw.netui.script.el.Term;
import com.bea.wlw.netui.script.el.VariableResolver;
import com.bea.wlw.netui.script.el.tokens.ContextToken;
import com.bea.wlw.netui.script.el.tokens.ExpressionToken;
import com.bea.wlw.netui.script.el.util.BindingContext;
import com.bea.wlw.netui.script.el.util.ParseUtils;
import com.bea.wlw.netui.util.logging.Logger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ExpressionTerm
extends Expression
implements Term {
    private static Logger _logger = Logger.getInstance((Class)(class$com$bea$wlw$netui$script$el$ExpressionTerm == null ? (class$com$bea$wlw$netui$script$el$ExpressionTerm = ExpressionTerm.class$("com.bea.wlw.netui.script.el.ExpressionTerm")) : class$com$bea$wlw$netui$script$el$ExpressionTerm));
    private List tokens = new ArrayList();
    private String exprStr = null;
    private ContextToken context = null;
    private ExpressionToken[] tokenArray = null;
    static /* synthetic */ Class class$com$bea$wlw$netui$script$el$ExpressionTerm;

    public void seal() {
        this.context = (ContextToken)this.tokens.get(0);
        this.tokenArray = new ExpressionToken[this.tokens.size()];
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.tokens.size()) {
            buf.append(((ExpressionToken)this.tokens.get(i)).getTokenString());
            this.tokenArray[i] = (ExpressionToken)this.tokens.get(i);
            ++i;
        }
        this.exprStr = buf.toString();
    }

    public String getContext() {
        return this.context.getName();
    }

    public void addToken(ExpressionToken token) {
        this.tokens.add(token);
    }

    public Iterator getExpressionTokens() {
        return this.tokens.iterator();
    }

    public int getTokenCount() {
        return this.tokenArray.length;
    }

    public ExpressionToken getToken(int index) {
        return this.tokenArray[index];
    }

    public String getExpressionString() {
        return this.exprStr;
    }

    public Object evaluate(VariableResolver vr) {
        return this._evaluate(this.tokens.size(), vr);
    }

    public void update(Object newValue, VariableResolver vr) {
        Object branch = this._evaluate(this.tokens.size() - 1, vr);
        ExpressionToken token = this.tokenArray[this.tokens.size() - 1];
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Update leaf token: " + token + " on object: " + branch));
        }
        token.update(branch, newValue);
    }

    public String changeContext(String oldContext, String newContext, Object index) {
        ParsedExpression pe;
        String thisExpr = this.getExpressionString();
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("oldContext: " + oldContext + " newContext: " + newContext + " thisExpr: " + thisExpr));
        }
        if (!(pe = ParseUtils.parse(newContext)).isExpression()) {
            String msg = "The expression can not be qualified into new context because the new context is not atomic.";
            if (_logger.isErrorEnabled()) {
                _logger.error((Object)msg);
            }
            throw new RuntimeException(msg);
        }
        if (!thisExpr.startsWith(oldContext)) {
            return "{" + thisExpr + "}";
        }
        if (index instanceof Integer && (Integer)index > Short.MAX_VALUE) {
            String msg = "Can not create an indexed expression with an array index greater than the Java array limit for the expression \"" + thisExpr + "\"";
            if (_logger.isWarnEnabled()) {
                _logger.warn((Object)msg);
            }
            throw new RuntimeException(msg);
        }
        String ctxStr = pe.getExpressionString();
        ctxStr = ctxStr + "[" + index + "]";
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("thisExpr: " + thisExpr + " ctxStr: " + ctxStr));
        }
        thisExpr = thisExpr.replaceFirst(oldContext, ctxStr);
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        buf.append(thisExpr);
        buf.append("}");
        return buf.toString();
    }

    public String qualify(String contextName) {
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        buf.append(contextName);
        buf.append(".");
        buf.append(this.getExpressionString());
        buf.append("}");
        return buf.toString();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ExpressionTerm:\n");
        int i = 0;
        while (i < this.tokens.size()) {
            buf.append("  " + this.tokens.get(i).toString() + "\n");
            ++i;
        }
        return buf.toString();
    }

    private final Object _evaluate(int index, VariableResolver vr) {
        Object result = null;
        if (this.tokens.size() == 1) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)"found single term expression");
            }
            if ((result = vr.resolveVariable(this.context.getName())) != null && result instanceof BindingContext) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("result is of type BindingContext; return type: " + ((BindingContext)result).unwrap().getClass()));
                }
                return ((BindingContext)result).unwrap();
            }
            return result;
        }
        int i = 0;
        while (i < index) {
            result = i == 0 ? vr.resolveVariable(this.context.getName()) : this.tokenArray[i].evaluate(result);
            ++i;
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

