/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.script.el;

import com.bea.wlw.netui.script.Expression;
import com.bea.wlw.netui.script.ExpressionEngineFactory;
import com.bea.wlw.netui.script.ExpressionEvaluationException;
import com.bea.wlw.netui.script.ExpressionEvaluator;
import com.bea.wlw.netui.script.ExpressionEvaluatorFactory;
import com.bea.wlw.netui.script.ExpressionUpdateException;
import com.bea.wlw.netui.script.IllegalExpressionException;
import com.bea.wlw.netui.script.el.ExpressionParseException;
import com.bea.wlw.netui.script.el.NetUIReadVariableResolver;
import com.bea.wlw.netui.script.el.NetUIUpdateVariableResolver;
import com.bea.wlw.netui.script.el.NetUIVariableResolver;
import com.bea.wlw.netui.script.el.ParsedExpression;
import com.bea.wlw.netui.script.el.util.ParseUtils;
import com.bea.wlw.netui.util.logging.Logger;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;
import org.apache.struts.action.ActionForm;

public class ExpressionEvaluatorImpl
implements ExpressionEvaluator {
    private static Logger _logger = Logger.getInstance((Class)(class$com$bea$wlw$netui$script$el$ExpressionEvaluatorImpl == null ? (class$com$bea$wlw$netui$script$el$ExpressionEvaluatorImpl = ExpressionEvaluatorImpl.class$("com.bea.wlw.netui.script.el.ExpressionEvaluatorImpl")) : class$com$bea$wlw$netui$script$el$ExpressionEvaluatorImpl));
    private static final boolean debugEnabled = _logger.isDebugEnabled();
    private static ExpressionEvaluator xscript;
    static /* synthetic */ Class class$com$bea$wlw$netui$script$el$ExpressionEvaluatorImpl;

    public Object evaluateStrict(String expression, Map contexts) throws ExpressionEvaluationException {
        NetUIVariableResolver vr = null;
        try {
            vr = new NetUIReadVariableResolver((ActionForm)contexts.get("actionForm"), (Tag)contexts.get("currentTag"), (PageContext)contexts.get("pageContext"));
            return ParseUtils.evaluate(expression, vr);
        }
        catch (Exception e) {
            if (debugEnabled) {
                _logger.debug((Object)("Expression evaluation failed in NetUIEL.  Cause: " + e), (Throwable)e);
            }
            Exception act = e;
            if (xscript != null) {
                try {
                    return xscript.evaluateStrict(expression, contexts);
                }
                catch (Exception xscriptE) {
                    act = xscriptE;
                }
            }
            String contextStr = ParseUtils.getContextString(vr.getAvailableVariables());
            String msg = "Caught exception when evaluating expression \"" + expression + "\" with available binding contexts " + contextStr + ". Root cause: " + ParseUtils.getRootCause(act).toString();
            if (_logger.isErrorEnabled()) {
                _logger.error((Object)msg, (Throwable)act);
            }
            ExpressionEvaluationException eee = new ExpressionEvaluationException(msg, expression, act);
            throw eee;
        }
    }

    public void update(String expression, Object value, Map contexts, boolean requestParameter) throws ExpressionUpdateException {
        NetUIVariableResolver vr = null;
        try {
            if (debugEnabled) {
                _logger.debug((Object)("Update expression \"" + expression + "\""));
            }
            vr = new NetUIUpdateVariableResolver((ActionForm)contexts.get("actionForm"), (ServletRequest)contexts.get("request"), (ServletResponse)contexts.get("response"), requestParameter);
            ParseUtils.update(expression, value, vr);
        }
        catch (Exception e) {
            if (debugEnabled) {
                _logger.debug((Object)("Expression update failed in NetUIEL.  Cause: " + e), (Throwable)e);
            }
            Exception act = e;
            if (xscript != null) {
                try {
                    xscript.update(expression, value, contexts, requestParameter);
                    return;
                }
                catch (Exception xscriptE) {
                    act = xscriptE;
                }
            }
            String contextStr = ParseUtils.getContextString(vr.getAvailableVariables());
            String msg = "Exception when attempting to update the expression \"" + expression + "\" with available binding contexts " + contextStr + ". Root cause: " + ParseUtils.getRootCause(act).toString();
            if (_logger.isErrorEnabled()) {
                _logger.error((Object)msg, (Throwable)act);
            }
            ExpressionUpdateException eee = new ExpressionUpdateException(msg, expression, e);
            eee.setLocalizedMessage(msg);
            throw eee;
        }
    }

    public String changeContext(String expression, String oldContext, String newContext, int lookupIndex) throws ExpressionEvaluationException {
        try {
            ParsedExpression pe = ParseUtils.parse(expression);
            return pe.changeContext(oldContext, newContext, new Integer(lookupIndex));
        }
        catch (Exception e) {
            String msg = "Error when trying to replace old context '" + oldContext + "' with new context '" + newContext + "' and index '" + lookupIndex + "': " + ParseUtils.getRootCause(e).toString();
            if (_logger.isErrorEnabled()) {
                _logger.error((Object)msg, (Throwable)e);
            }
            throw new ExpressionEvaluationException(msg, e);
        }
    }

    public String qualify(String contextName, String expression) throws ExpressionEvaluationException {
        try {
            ParsedExpression pe = ParseUtils.parse(expression);
            return pe.qualify(contextName);
        }
        catch (Exception e) {
            String msg = "Error when trying to create an expression in namespace \"" + contextName + "\" with fragment \"" + expression + "\".  Root cause: " + ParseUtils.getRootCause(e).toString();
            throw new ExpressionEvaluationException(msg, e);
        }
    }

    public boolean isExpression(String expression) {
        try {
            ParsedExpression pe = ParseUtils.parse(expression);
            return pe.isExpression();
        }
        catch (Exception e) {
            if (xscript != null) {
                return xscript.isExpression(expression);
            }
            if (_logger.isErrorEnabled()) {
                _logger.error((Object)("Exception parsing expression \"" + expression + "\".  Cause: " + ParseUtils.getRootCause(e).toString()), (Throwable)e);
            }
            if (e instanceof IllegalExpressionException) {
                throw (IllegalExpressionException)e;
            }
            if (e instanceof ExpressionParseException) {
                throw new IllegalExpressionException(e);
            }
            return false;
        }
    }

    public boolean containsExpression(String expression) {
        try {
            ParsedExpression pe = ParseUtils.parse(expression);
            return pe.containsExpression();
        }
        catch (Exception e) {
            if (xscript != null) {
                return xscript.containsExpression(expression);
            }
            if (_logger.isErrorEnabled()) {
                _logger.error((Object)("Exception checking for expressions in \"" + expression + "\""), (Throwable)e);
            }
            return false;
        }
    }

    public Expression parseExpression(String expression) {
        if (this.isExpression(expression)) {
            ParsedExpression pe = ParseUtils.parse(expression);
            return pe.getAtomicExpressionTerm();
        }
        if (xscript != null) {
            return xscript.parseExpression(expression);
        }
        throw new IllegalExpressionException("The expression \"" + expression + "\" can not be parsed as it is not an atomic expression.");
    }

    public void enter() {
    }

    public void exit() {
        if (xscript != null) {
            xscript.exit();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            xscript = ExpressionEvaluatorFactory.getInstance("xscript");
        }
        catch (Exception e) {
            xscript = null;
        }
    }

    public static class NetUIELEngineFactory
    extends ExpressionEngineFactory {
        public ExpressionEvaluator getInstance() {
            return new ExpressionEvaluatorImpl();
        }
    }
}

