/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.script;

import com.bea.wlw.netui.script.ExpressionEngineFactory;
import com.bea.wlw.netui.script.ExpressionEvaluator;
import com.bea.wlw.netui.util.logging.Logger;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ExpressionEvaluatorFactory {
    private static final Logger _logger = Logger.getInstance((Class)(class$com$bea$wlw$netui$script$ExpressionEvaluatorFactory == null ? (class$com$bea$wlw$netui$script$ExpressionEvaluatorFactory = ExpressionEvaluatorFactory.class$("com.bea.wlw.netui.script.ExpressionEvaluatorFactory")) : class$com$bea$wlw$netui$script$ExpressionEvaluatorFactory));
    private static final String DEFAULT_NAME = "default";
    private static final String SCRIPT_PROPERTIES = "com/bea/wlw/netui/script/script.properties";
    private static final Map factoryMap = new HashMap();
    private static final ExpressionEngineFactory defaultEngine = ExpressionEvaluatorFactory.initialize(factoryMap);
    static /* synthetic */ Class class$com$bea$wlw$netui$script$ExpressionEvaluatorFactory;

    public static final ExpressionEvaluator getInstance() {
        return ExpressionEvaluatorFactory.getInstance(null);
    }

    public static final ExpressionEvaluator getInstance(String name) {
        if (name == null) {
            return defaultEngine.getInstance();
        }
        if (factoryMap.containsKey(name)) {
            return ((ExpressionEngineFactory)factoryMap.get(name)).getInstance();
        }
        String msg = "An ExpressionEvaluator named \"" + name + "\" is not available.";
        if (_logger.isErrorEnabled()) {
            _logger.error((Object)msg);
        }
        throw new IllegalArgumentException(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static final ExpressionEngineFactory initialize(Map map) {
        String msg;
        Properties props;
        block27: {
            props = null;
            InputStream is = null;
            is = (class$com$bea$wlw$netui$script$ExpressionEvaluatorFactory == null ? (class$com$bea$wlw$netui$script$ExpressionEvaluatorFactory = ExpressionEvaluatorFactory.class$("com.bea.wlw.netui.script.ExpressionEvaluatorFactory")) : class$com$bea$wlw$netui$script$ExpressionEvaluatorFactory).getClassLoader().getResourceAsStream(SCRIPT_PROPERTIES);
            if (is == null) {
                String msg2 = "Did not find a script.properties file; the expression evaluator configuration is invalid.";
                if (_logger.isErrorEnabled()) {
                    _logger.error((Object)msg2);
                }
                throw new RuntimeException(msg2);
            }
            props = new Properties();
            props.load(is);
            Object var5_7 = null;
            try {
                if (is != null) {
                    is.close();
                }
                break block27;
            }
            catch (Exception ignore) {}
            break block27;
            {
                catch (Exception e) {
                    if (_logger.isErrorEnabled()) {
                        _logger.error((Object)"Error occurred reading the script properties file", (Throwable)e);
                    }
                    var5_7 = null;
                    try {
                        if (is != null) {
                            is.close();
                        }
                        break block27;
                    }
                    catch (Exception ignore) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if (props == null) {
            String msg3 = "Did not find a script.properties file; the expression evaluator configuration is invalid.";
            if (_logger.isErrorEnabled()) {
                _logger.error((Object)msg3);
            }
            throw new RuntimeException(msg3);
        }
        ExpressionEngineFactory factory = null;
        Enumeration<?> enumeration = props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            if (name.equals(DEFAULT_NAME)) continue;
            String className = props.getProperty(name);
            try {
                Class<?> type = Class.forName(className);
                factory = (ExpressionEngineFactory)type.newInstance();
            }
            catch (ClassNotFoundException cnf) {
                if (!_logger.isInfoEnabled()) continue;
                _logger.info((Object)("Could not create an ExpressionEngineFactory for type \"" + className + "\" because the implementation class could not be found."));
                continue;
            }
            catch (Exception e) {
                if (!_logger.isWarnEnabled()) continue;
                _logger.warn((Object)("Could not create an ExpressionEngineFactory for type \"" + className + "\" because an error occurred creating the factory.  Cause: " + e), (Throwable)e);
                continue;
            }
            if (map.containsKey(name)) {
                if (_logger.isWarnEnabled()) {
                    _logger.warn((Object)("Overwriting a previously defined ExpressionEngineFactory named \"" + name + "\" with a new ExpressionEngineFactory of type \"" + className + "\""));
                } else {
                    _logger.info((Object)("Adding an ExpressionEngineFactory named \"" + name + "\" with implementation \"" + className + "\""));
                }
            }
            map.put(name, factory);
        }
        String defaultName = props.getProperty(DEFAULT_NAME);
        if (defaultName != null) {
            if (map.containsKey(defaultName)) {
                return (ExpressionEngineFactory)map.get(defaultName);
            }
            msg = "The default ExpressionEvaluator named \"" + defaultName + "\" was specified, but the ExpressionEngineFactory could not be found.";
            if (_logger.isWarnEnabled()) {
                _logger.warn((Object)msg);
            }
            throw new RuntimeException(msg);
        }
        msg = "There is no default expression engine specified; the properties file \"com/bea/wlw/netui/script/script.properties\" is invalid.";
        if (_logger.isErrorEnabled()) {
            _logger.error((Object)msg);
        }
        throw new RuntimeException(msg);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

