/*
 * Decompiled with CFR 0.152.
 */
package com.bea.wlw.netui.pageflow;

import com.bea.wlw.netui.pageflow.FlowController;
import com.bea.wlw.netui.pageflow.IllegalOutputFormTypeException;
import com.bea.wlw.netui.pageflow.IllegalPageInputException;
import com.bea.wlw.netui.pageflow.IllegalRedirectOutputFormException;
import com.bea.wlw.netui.pageflow.PageFlowUtils;
import com.bea.wlw.netui.pageflow.UnresolvableForwardException;
import com.bea.wlw.netui.pageflow.config.PageFlowActionForward;
import com.bea.wlw.netui.util.debug.Debug;
import com.bea.wlw.netui.util.logging.Logger;
import java.io.File;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.config.ModuleConfig;

public class Forward
extends ActionForward {
    public static final int RETURN_TO_NONE = 0;
    public static final int RETURN_TO_CURRENT_PAGE = 1;
    public static final int RETURN_TO_PREVIOUS_PAGE = 2;
    public static final int RETURN_TO_PREVIOUS_ACTION = 3;
    public static final int RETURN_TO_PAGE = -1;
    public static final int RETURN_TO_ACTION = -2;
    private static final Debug debug;
    private static final Logger logger;
    private static final int JPF_EXTENSION_LEN;
    private static final String RETURN_TO_CURRENT_PAGE_STR = "currentPage";
    private static final String RETURN_TO_PREVIOUS_PAGE_STR = "previousPage";
    private static final String RETURN_TO_PAGE_LEGACY_STR = "page";
    private static final String RETURN_TO_PREVIOUS_ACTION_STR = "previousAction";
    private static final String RETURN_TO_ACTION_LEGACY_STR = "action";
    private List _outputForms;
    private String _path;
    private boolean _isNestedReturn = false;
    private boolean _init = false;
    private ActionMapping _mapping = null;
    private StringBuffer _queryString;
    private boolean _explicitPath = false;
    private FlowController _flowController = null;
    private String _returnFormType = null;
    private boolean _userSetRedirect = false;
    private Map _pageInputs = null;
    private int _returnToType;
    private boolean _hasExplicitRedirectValue = false;
    private ModuleConfig _altModuleConfig;
    static /* synthetic */ Class class$com$bea$wlw$netui$pageflow$Forward;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$apache$struts$action$ActionForm;

    public Forward(String forwardName) {
        this.setName(forwardName);
    }

    public Forward(String forwardName, ActionForm outputForm) {
        this(forwardName);
        if (outputForm != null) {
            this.addOutputForm(outputForm);
        }
    }

    public Forward(String forwardName, String pageInputName, Object pageInputValue) {
        this(forwardName);
        this.addPageInput(pageInputName, pageInputValue);
    }

    public Forward(URI path) {
        this(path, false);
    }

    public Forward(URI path, boolean redirect) {
        this.setPath(path.toString());
        super.setRedirect(redirect || path.isAbsolute());
        this.setContextRelative(path.getPath().startsWith("/"));
        this._explicitPath = true;
    }

    public Forward(URL path) {
        this.setPath(path.toString());
        super.setRedirect(true);
        this._explicitPath = true;
    }

    Forward(ActionForward initFwd) {
        this.setName(initFwd.getName());
        this.initFrom(initFwd);
    }

    public void setRedirect(boolean redirect) {
        super.setRedirect(redirect);
        this._userSetRedirect = true;
    }

    public boolean isRedirect() {
        return super.getRedirect();
    }

    public final void addOutputForm(ActionForm form) {
        if (!$assertionsDisabled && form == null) {
            throw new AssertionError();
        }
        if (this._outputForms == null) {
            this._outputForms = new ArrayList();
        }
        if (this._init && this.getRedirect()) {
            String actionPath = this._mapping != null ? this._mapping.getPath() : "";
            String descrip = this.getName() != null ? this.getName() : this.getPath();
            throw new IllegalRedirectOutputFormException(descrip, actionPath, this._flowController, form.getClass().getName());
        }
        this._outputForms.add(form);
    }

    public final ActionForm[] getOutputForms() {
        if (this._outputForms == null) {
            return new ActionForm[0];
        }
        return this._outputForms.toArray(new ActionForm[0]);
    }

    final ActionForm getFirstOutputForm() {
        if (this._outputForms == null || this._outputForms.size() == 0) {
            if (this._returnFormType != null) {
                try {
                    if (debug.isOn()) {
                        debug.out("Creating ActionForm of type " + this._returnFormType);
                    }
                    return (ActionForm)Class.forName(this._returnFormType).newInstance();
                }
                catch (Exception e) {
                    logger.error((Object)("Could not create instance of " + this._returnFormType), (Throwable)e);
                }
            }
            return null;
        }
        return (ActionForm)this._outputForms.get(0);
    }

    public boolean doesResolve() {
        if (this._explicitPath) {
            return true;
        }
        if (!$assertionsDisabled && this._mapping == null && this._altModuleConfig == null) {
            throw new AssertionError((Object)"PageFlow.Forward.doesResolve() called outside of request");
        }
        return this.findForward(this.getName()) != null;
    }

    protected ActionForward findForward(String forwardName) {
        ActionForward fwd;
        ActionForward actionForward = fwd = this._mapping != null ? this._mapping.findForward(forwardName) : null;
        if (fwd != null) {
            return fwd;
        }
        if (this._altModuleConfig != null) {
            return (ActionForward)this._altModuleConfig.findForwardConfig(forwardName);
        }
        return null;
    }

    void setAltModuleConfig(ModuleConfig mc) {
        this._altModuleConfig = mc;
    }

    private final void init() {
        if (!this._init) {
            if (this._mapping == null && this._altModuleConfig == null) {
                throw new IllegalStateException("Forward is not initialized.  Use initialize().");
            }
            ActionForward fwd = this.findForward(this.getName());
            if (fwd == null) {
                throw new UnresolvableForwardException(this.getName(), this._mapping.getPath(), this._flowController);
            }
            this.initFrom(fwd);
            if (this.getRedirect()) {
                if (this._pageInputs != null && !this._pageInputs.isEmpty()) {
                    throw new IllegalPageInputException(this.getName(), this._mapping.getPath(), this._flowController, (String)this._pageInputs.keySet().iterator().next());
                }
                if (this._outputForms != null && !this._outputForms.isEmpty()) {
                    throw new IllegalRedirectOutputFormException(this.getName(), this._mapping.getPath(), this._flowController, this._outputForms.get(0).getClass().getName());
                }
            }
        }
    }

    private void initFrom(ActionForward fwd) {
        this._path = fwd.getPath();
        if (!this._userSetRedirect) {
            this.setRedirect(fwd.getRedirect());
        }
        this.setContextRelative(fwd.getContextRelative());
        if (this._queryString != null) {
            this._path = this._path + this._queryString.toString();
        }
        if (fwd instanceof PageFlowActionForward) {
            Class<?> returnFormClass;
            block31: {
                String retFormMember;
                PageFlowActionForward fc;
                block30: {
                    fc = (PageFlowActionForward)fwd;
                    this._isNestedReturn = fc.isNestedReturn();
                    this._returnFormType = fc.getReturnFormType();
                    this._hasExplicitRedirectValue = fc.hasExplicitRedirectValue();
                    returnFormClass = null;
                    if (this._returnFormType != null) {
                        try {
                            returnFormClass = Class.forName(this._returnFormType);
                        }
                        catch (ClassNotFoundException e) {
                            if ($assertionsDisabled) break block30;
                            throw new AssertionError((Object)e);
                        }
                    }
                }
                if (fc.isReturnToPage() || fc.isReturnToAction()) {
                    String path = fc.getPath();
                    if (path.equals(RETURN_TO_PREVIOUS_PAGE_STR)) {
                        this._returnToType = 2;
                    } else if (path.equals(RETURN_TO_CURRENT_PAGE_STR)) {
                        this._returnToType = 1;
                    } else if (path.equals(RETURN_TO_PAGE_LEGACY_STR)) {
                        this._returnToType = -1;
                    } else if (path.equals(RETURN_TO_PREVIOUS_ACTION_STR)) {
                        this._returnToType = 3;
                    } else if (path.equals(RETURN_TO_ACTION_LEGACY_STR)) {
                        this._returnToType = -2;
                    } else {
                        if (!$assertionsDisabled) {
                            throw new AssertionError((Object)("invalid return-to type for forward " + fc.getName() + ": " + path));
                        }
                        this._returnToType = 1;
                    }
                }
                if ((retFormMember = fc.getReturnFormMember()) != null) {
                    try {
                        if (!$assertionsDisabled && this._flowController == null) {
                            throw new AssertionError();
                        }
                        Field field = this._flowController.getClass().getDeclaredField(retFormMember);
                        if (!$assertionsDisabled && !(class$org$apache$struts$action$ActionForm == null ? (class$org$apache$struts$action$ActionForm = Forward.class$("org.apache.struts.action.ActionForm")) : class$org$apache$struts$action$ActionForm).isAssignableFrom(field.getType())) {
                            throw new AssertionError(field.getType());
                        }
                        returnFormClass = field.getType();
                        field.setAccessible(true);
                        ActionForm form = (ActionForm)field.get(this._flowController);
                        if (form != null) {
                            if (debug.isOn()) {
                                debug.out("using member " + retFormMember + " for Forward " + this.getName());
                            }
                            this.addOutputForm(form);
                        } else {
                            if (debug.isOn()) {
                                debug.out("returnFormMember " + retFormMember + " was null.");
                            }
                            logger.info((Object)("return-form member " + retFormMember + " was null."));
                        }
                    }
                    catch (NoSuchFieldException e) {
                        if (!$assertionsDisabled) {
                            throw new AssertionError((Object)("could not find field " + retFormMember));
                        }
                    }
                    catch (IllegalAccessException e) {
                        if ($assertionsDisabled) break block31;
                        throw new AssertionError();
                    }
                }
            }
            if (returnFormClass != null && this._outputForms != null && this._outputForms.size() > 0 && !returnFormClass.isInstance(this._outputForms.get(0))) {
                throw new IllegalOutputFormTypeException(this.getName(), this._mapping.getPath(), this._flowController, this._outputForms.get(0).getClass().getName(), returnFormClass.getName());
            }
        }
        this._init = true;
    }

    public void initialize(ActionMapping mapping, FlowController flowController) {
        this._mapping = mapping;
        this._flowController = flowController;
    }

    public void setPath(String path) {
        this._path = path;
        this._init = true;
    }

    boolean isExplicitPath() {
        return this._explicitPath;
    }

    boolean hasExplicitRedirectValue() {
        return this._hasExplicitRedirectValue;
    }

    public String getPath() {
        this.init();
        return this._path;
    }

    public boolean isNestedReturn() {
        this.init();
        return this._isNestedReturn;
    }

    public boolean isReturnToPage() {
        this.init();
        return this._returnToType == 2 || this._returnToType == 1 || this._returnToType == -1;
    }

    public boolean isReturnToAction() {
        this.init();
        return this._returnToType == 3 || this._returnToType == -2;
    }

    boolean shouldPopPageFlow() {
        this.init();
        return this._isNestedReturn;
    }

    public boolean forwardsToPageFlow() {
        return PageFlowUtils.osSensitiveEndsWith(this.getPath(), ".jpf");
    }

    String getPageFlowClassName(HttpServletRequest request) {
        if (!$assertionsDisabled && !this.forwardsToPageFlow()) {
            throw new AssertionError();
        }
        String relUrl = PageFlowUtils.getRelativeURI(request, this.getPath(), null);
        if (relUrl.charAt(0) == '/' || relUrl.charAt(0) == File.separatorChar) {
            relUrl = relUrl.substring(1);
        }
        relUrl = relUrl.replace('/', '.').replace(File.separatorChar, '.');
        return relUrl.substring(0, relUrl.length() - JPF_EXTENSION_LEN);
    }

    public void setQueryString(String queryString) {
        this._queryString = queryString == null ? null : (queryString.startsWith("?") ? new StringBuffer(queryString) : new StringBuffer("?").append(queryString));
    }

    public String getQueryString() {
        return this._queryString != null ? this._queryString.toString() : null;
    }

    public void addQueryParam(String name, String value) {
        if (this._queryString == null) {
            this._queryString = new StringBuffer("?");
        } else {
            this._queryString.append('&');
        }
        this._queryString.append(name);
        if (value != null) {
            this._queryString.append('=').append(value);
        }
    }

    public final void addQueryParam(String name) {
        this.addQueryParam(name, null);
    }

    public void addPageInput(String name, Object value) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("A page input name may not be null or empty.");
        }
        if (this._pageInputs == null) {
            this._pageInputs = new HashMap();
        }
        if (this._init && this.getRedirect()) {
            String actionPath = this._mapping != null ? this._mapping.getPath() : "";
            String descrip = this.getName() != null ? this.getName() : this.getPath();
            throw new IllegalPageInputException(descrip, actionPath, this._flowController, name);
        }
        this._pageInputs.put(name, value);
    }

    public Map getPageInputs() {
        return this._pageInputs;
    }

    public int getReturnToType() {
        return this._returnToType;
    }

    public String getReturnToTypeAsString() {
        switch (this._returnToType) {
            case 1: {
                return RETURN_TO_CURRENT_PAGE_STR;
            }
            case 2: {
                return RETURN_TO_PREVIOUS_PAGE_STR;
            }
            case -1: {
                return RETURN_TO_PAGE_LEGACY_STR;
            }
            case 3: {
                return RETURN_TO_PREVIOUS_ACTION_STR;
            }
            case -2: {
                return RETURN_TO_ACTION_LEGACY_STR;
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$bea$wlw$netui$pageflow$Forward == null ? (class$com$bea$wlw$netui$pageflow$Forward = Forward.class$("com.bea.wlw.netui.pageflow.Forward")) : class$com$bea$wlw$netui$pageflow$Forward).desiredAssertionStatus();
        debug = Debug.getInstance((Class)(class$com$bea$wlw$netui$pageflow$Forward == null ? (class$com$bea$wlw$netui$pageflow$Forward = Forward.class$("com.bea.wlw.netui.pageflow.Forward")) : class$com$bea$wlw$netui$pageflow$Forward));
        logger = Logger.getInstance((Class)(class$com$bea$wlw$netui$pageflow$Forward == null ? (class$com$bea$wlw$netui$pageflow$Forward = Forward.class$("com.bea.wlw.netui.pageflow.Forward")) : class$com$bea$wlw$netui$pageflow$Forward));
        JPF_EXTENSION_LEN = ".jpf".length();
    }
}

