/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import org.apache.xerces.util.SecuritySupport;

public class ObjectFactory {
    private static final String DEFAULT_PROPERTIES_FILENAME = "xerces.properties";
    private static final boolean DEBUG = false;
    private static Properties fXercesProperties = null;
    private static long fLastModified = -1L;
    static /* synthetic */ Class class$org$apache$xerces$util$ObjectFactory;

    public static Object createObject(String factoryId, String fallbackClassName) throws ConfigurationError {
        return ObjectFactory.createObject(factoryId, null, fallbackClassName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object createObject(String factoryId, String propertiesFilename, String fallbackClassName) throws ConfigurationError {
        ObjectFactory.debugPrintln("debug is on");
        SecuritySupport ss = SecuritySupport.getInstance();
        ClassLoader cl = ObjectFactory.findClassLoader();
        try {
            String systemProp = ss.getSystemProperty(factoryId);
            if (systemProp != null) {
                ObjectFactory.debugPrintln("found system property, value=" + systemProp);
                return ObjectFactory.newInstance(systemProp, cl, true);
            }
        }
        catch (SecurityException se) {
            // empty catch block
        }
        String factoryClassName = null;
        if (propertiesFilename == null) {
            String javah = ss.getSystemProperty("java.home");
            propertiesFilename = javah + File.separator + "lib" + File.separator + DEFAULT_PROPERTIES_FILENAME;
            File propertiesFile = new File(propertiesFilename);
            boolean propertiesFileExists = ss.getFileExists(propertiesFile);
            Class clazz = class$org$apache$xerces$util$ObjectFactory == null ? (class$org$apache$xerces$util$ObjectFactory = ObjectFactory.class$("org.apache.xerces.util.ObjectFactory")) : class$org$apache$xerces$util$ObjectFactory;
            synchronized (clazz) {
                boolean loadProperties = false;
                if (fLastModified >= 0L) {
                    if (propertiesFileExists && fLastModified < (fLastModified = ss.getLastModified(propertiesFile))) {
                        loadProperties = true;
                    } else if (!propertiesFileExists) {
                        fLastModified = -1L;
                        fXercesProperties = null;
                    }
                } else if (propertiesFileExists) {
                    loadProperties = true;
                    fLastModified = ss.getLastModified(propertiesFile);
                }
                if (loadProperties) {
                    try {
                        fXercesProperties = new Properties();
                        FileInputStream fis = ss.getFileInputStream(propertiesFile);
                        fXercesProperties.load(fis);
                        fis.close();
                    }
                    catch (Exception x) {
                        fXercesProperties = null;
                        fLastModified = -1L;
                    }
                }
            }
            if (fXercesProperties != null) {
                factoryClassName = fXercesProperties.getProperty(factoryId);
            }
        } else {
            try {
                FileInputStream fis = ss.getFileInputStream(new File(propertiesFilename));
                Properties props = new Properties();
                props.load(fis);
                fis.close();
                factoryClassName = props.getProperty(factoryId);
            }
            catch (Exception x) {
                // empty catch block
            }
        }
        if (factoryClassName != null) {
            ObjectFactory.debugPrintln("found in " + propertiesFilename + ", value=" + factoryClassName);
            return ObjectFactory.newInstance(factoryClassName, cl, true);
        }
        Object provider = ObjectFactory.findJarServiceProvider(factoryId);
        if (provider != null) {
            return provider;
        }
        if (fallbackClassName == null) {
            throw new ConfigurationError("Provider for " + factoryId + " cannot be found", null);
        }
        ObjectFactory.debugPrintln("using fallback, value=" + fallbackClassName);
        return ObjectFactory.newInstance(fallbackClassName, cl, true);
    }

    private static void debugPrintln(String msg) {
    }

    public static ClassLoader findClassLoader() throws ConfigurationError {
        SecuritySupport ss = SecuritySupport.getInstance();
        ClassLoader cl = ss.getContextClassLoader();
        if (cl == null) {
            cl = (class$org$apache$xerces$util$ObjectFactory == null ? (class$org$apache$xerces$util$ObjectFactory = ObjectFactory.class$("org.apache.xerces.util.ObjectFactory")) : class$org$apache$xerces$util$ObjectFactory).getClassLoader();
        }
        return cl;
    }

    public static Object newInstance(String className, ClassLoader cl, boolean doFallback) throws ConfigurationError {
        try {
            Class providerClass = ObjectFactory.findProviderClass(className, cl, doFallback);
            Object instance = providerClass.newInstance();
            ObjectFactory.debugPrintln("created new instance of " + providerClass + " using ClassLoader: " + cl);
            return instance;
        }
        catch (ClassNotFoundException x) {
            throw new ConfigurationError("Provider " + className + " not found", x);
        }
        catch (Exception x) {
            throw new ConfigurationError("Provider " + className + " could not be instantiated: " + x, x);
        }
    }

    public static Class findProviderClass(String className, ClassLoader cl, boolean doFallback) throws ClassNotFoundException, ConfigurationError {
        Class<?> providerClass;
        if (cl == null) {
            providerClass = Class.forName(className);
        } else {
            try {
                providerClass = cl.loadClass(className);
            }
            catch (ClassNotFoundException x) {
                if (doFallback) {
                    cl = (class$org$apache$xerces$util$ObjectFactory == null ? (class$org$apache$xerces$util$ObjectFactory = ObjectFactory.class$("org.apache.xerces.util.ObjectFactory")) : class$org$apache$xerces$util$ObjectFactory).getClassLoader();
                    providerClass = cl.loadClass(className);
                }
                throw x;
            }
        }
        return providerClass;
    }

    private static Object findJarServiceProvider(String factoryId) throws ConfigurationError {
        BufferedReader rd;
        SecuritySupport ss = SecuritySupport.getInstance();
        String serviceId = "META-INF/services/" + factoryId;
        InputStream is = null;
        ClassLoader cl = ss.getContextClassLoader();
        if (cl != null) {
            is = ss.getResourceAsStream(cl, serviceId);
            if (is == null) {
                cl = (class$org$apache$xerces$util$ObjectFactory == null ? (class$org$apache$xerces$util$ObjectFactory = ObjectFactory.class$("org.apache.xerces.util.ObjectFactory")) : class$org$apache$xerces$util$ObjectFactory).getClassLoader();
                is = ss.getResourceAsStream(cl, serviceId);
            }
        } else {
            cl = (class$org$apache$xerces$util$ObjectFactory == null ? (class$org$apache$xerces$util$ObjectFactory = ObjectFactory.class$("org.apache.xerces.util.ObjectFactory")) : class$org$apache$xerces$util$ObjectFactory).getClassLoader();
            is = ss.getResourceAsStream(cl, serviceId);
        }
        if (is == null) {
            return null;
        }
        ObjectFactory.debugPrintln("found jar resource=" + serviceId + " using ClassLoader: " + cl);
        try {
            rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            rd = new BufferedReader(new InputStreamReader(is));
        }
        String factoryClassName = null;
        try {
            factoryClassName = rd.readLine();
            rd.close();
        }
        catch (IOException x) {
            return null;
        }
        if (factoryClassName != null && !"".equals(factoryClassName)) {
            ObjectFactory.debugPrintln("found in resource, value=" + factoryClassName);
            return ObjectFactory.newInstance(factoryClassName, cl, false);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class ConfigurationError
    extends Error {
        private Exception exception;

        public ConfigurationError(String msg, Exception x) {
            super(msg);
            this.exception = x;
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

