/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.util;

public final class HexBin {
    private static final int BASELENGTH = 255;
    private static final int LOOKUPLENGTH = 16;
    private static final byte[] hexNumberTable = new byte[255];
    private static final char[] lookUpHexAlphabet = new char[16];

    public static String encode(byte[] binaryData) {
        if (binaryData == null) {
            return null;
        }
        int lengthData = binaryData.length;
        int lengthEncode = lengthData * 2;
        char[] encodedData = new char[lengthEncode];
        int i = 0;
        while (i < lengthData) {
            int temp = binaryData[i];
            if (temp < 0) {
                temp += 256;
            }
            encodedData[i * 2] = lookUpHexAlphabet[temp >> 4];
            encodedData[i * 2 + 1] = lookUpHexAlphabet[temp & 0xF];
            ++i;
        }
        return new String(encodedData);
    }

    public static byte[] decode(String encoded) {
        if (encoded == null) {
            return null;
        }
        int lengthData = encoded.length();
        if (lengthData % 2 != 0) {
            return null;
        }
        char[] binaryData = encoded.toCharArray();
        int lengthDecode = lengthData / 2;
        byte[] decodedData = new byte[lengthDecode];
        int i = 0;
        while (i < lengthDecode) {
            byte temp1 = hexNumberTable[binaryData[i * 2]];
            if (temp1 == -1) {
                return null;
            }
            byte temp2 = hexNumberTable[binaryData[i * 2 + 1]];
            if (temp2 == -1) {
                return null;
            }
            decodedData[i] = (byte)(temp1 << 4 | temp2);
            ++i;
        }
        return decodedData;
    }

    static {
        int i = 0;
        while (i < 255) {
            HexBin.hexNumberTable[i] = -1;
            ++i;
        }
        int i2 = 57;
        while (i2 >= 48) {
            HexBin.hexNumberTable[i2] = (byte)(i2 - 48);
            --i2;
        }
        int i3 = 70;
        while (i3 >= 65) {
            HexBin.hexNumberTable[i3] = (byte)(i3 - 65 + 10);
            --i3;
        }
        int i4 = 102;
        while (i4 >= 97) {
            HexBin.hexNumberTable[i4] = (byte)(i4 - 97 + 10);
            --i4;
        }
        int i5 = 0;
        while (i5 < 10) {
            HexBin.lookUpHexAlphabet[i5] = (char)(48 + i5);
            ++i5;
        }
        int i6 = 10;
        while (i6 <= 15) {
            HexBin.lookUpHexAlphabet[i6] = (char)(65 + i6 - 10);
            ++i6;
        }
    }
}

