/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.util.Vector;
import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.AttributeMap;
import org.apache.xerces.dom.CoreDOMImplementationImpl;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.DOMConfigurationImpl;
import org.apache.xerces.dom.DOMErrorImpl;
import org.apache.xerces.dom.DOMLocatorImpl;
import org.apache.xerces.dom.DocumentTypeImpl;
import org.apache.xerces.dom.ElementImpl;
import org.apache.xerces.dom.EntityReferenceImpl;
import org.apache.xerces.dom.PSVIAttrNSImpl;
import org.apache.xerces.dom.PSVIElementNSImpl;
import org.apache.xerces.dom.TextImpl;
import org.apache.xerces.dom3.DOMError;
import org.apache.xerces.dom3.DOMErrorHandler;
import org.apache.xerces.impl.RevalidationHandler;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.xs.psvi.XSTypeDefinition;
import org.apache.xerces.util.AugmentationsImpl;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLSymbols;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLDocumentSource;
import org.apache.xerces.xni.psvi.AttributePSVI;
import org.apache.xerces.xni.psvi.ElementPSVI;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class DOMNormalizer
implements XMLDocumentHandler {
    protected static final boolean DEBUG_ND = false;
    protected static final boolean DEBUG = false;
    protected static final boolean DEBUG_EVENTS = false;
    protected static final String PREFIX = "NS";
    protected DOMConfigurationImpl fConfiguration = null;
    protected CoreDocumentImpl fDocument = null;
    protected final XMLAttributesProxy fAttrProxy = new XMLAttributesProxy();
    protected final QName fQName = new QName();
    protected RevalidationHandler fValidationHandler;
    protected SymbolTable fSymbolTable;
    protected DOMErrorHandler fErrorHandler;
    protected int fNamespaceCounter = 1;
    protected boolean fNamespaceValidation = false;
    protected boolean fPSVI = false;
    protected final NamespaceContext fNamespaceContext = new NamespaceSupport();
    protected final NamespaceContext fLocalNSBinder = new NamespaceSupport();
    protected final Vector fAttributeList = new Vector(5, 10);
    protected final DOMErrorImpl fDOMError = new DOMErrorImpl();
    protected final DOMLocatorImpl fLocator = new DOMLocatorImpl();
    protected Node fCurrentNode = null;
    private QName fAttrQName = new QName();
    final XMLString fNormalizedValue = new XMLString(new char[16], 0, 0);

    protected void normalizeDocument(CoreDocumentImpl document, DOMConfigurationImpl config) {
        this.fDocument = document;
        this.fConfiguration = config;
        this.fSymbolTable = (SymbolTable)this.fConfiguration.getProperty("http://apache.org/xml/properties/internal/symbol-table");
        this.fNamespaceContext.reset();
        this.fNamespaceContext.declarePrefix(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
        this.fNamespaceCounter = 1;
        if ((this.fConfiguration.features & 0x40) != 0) {
            this.fValidationHandler = CoreDOMImplementationImpl.singleton.getValidator("http://www.w3.org/2001/XMLSchema");
            this.fConfiguration.setFeature("http://xml.org/sax/features/validation", true);
            this.fConfiguration.setFeature("http://apache.org/xml/features/validation/schema", true);
            this.fNamespaceValidation = true;
            this.fPSVI = (this.fConfiguration.features & 0x80) != 0;
            this.fDocument.clearIdentifiers();
            ((XMLComponent)((Object)this.fValidationHandler)).reset(this.fConfiguration);
        }
        this.fErrorHandler = (DOMErrorHandler)this.fConfiguration.getParameter("error-handler");
        if (this.fValidationHandler != null) {
            this.fValidationHandler.setBaseURI(this.fDocument.fDocumentURI);
            this.fValidationHandler.setDocumentHandler(this);
            this.fValidationHandler.startDocument(null, this.fDocument.encoding, this.fNamespaceContext, null);
        }
        try {
            Node kid = this.fDocument.getFirstChild();
            while (kid != null) {
                Node next = kid.getNextSibling();
                if ((kid = this.normalizeNode(kid)) != null) {
                    next = kid;
                }
                kid = next;
            }
            if (this.fValidationHandler != null) {
                this.fValidationHandler.endDocument(null);
                CoreDOMImplementationImpl.singleton.releaseValidator("http://www.w3.org/2001/XMLSchema", this.fValidationHandler);
                this.fValidationHandler = null;
            }
        }
        catch (RuntimeException e) {
            this.modifyDOMError("Runtime exception: " + e.getMessage(), (short)2, null);
            this.fErrorHandler.handleError(this.fDOMError);
            e.printStackTrace();
        }
    }

    protected Node normalizeNode(Node node) {
        short type = node.getNodeType();
        switch (type) {
            case 10: {
                if ((this.fConfiguration.features & 4) != 0) break;
                ((DocumentTypeImpl)node).entities.removeAll();
                break;
            }
            case 1: {
                AttributeMap attributes;
                this.fNamespaceContext.pushContext();
                ElementImpl elem = (ElementImpl)node;
                if (elem.needsSyncChildren()) {
                    elem.synchronizeChildren();
                }
                AttributeMap attributeMap = attributes = elem.hasAttributes() ? (AttributeMap)elem.getAttributes() : null;
                if ((this.fConfiguration.features & 1) != 0) {
                    this.namespaceFixUp(elem, attributes);
                } else if (attributes != null) {
                    int i = 0;
                    while (i < attributes.getLength()) {
                        Attr attr = (Attr)attributes.item(i);
                        attr.normalize();
                        ++i;
                    }
                }
                if (this.fValidationHandler != null) {
                    this.fAttrProxy.setAttributes(attributes, this.fDocument, elem);
                    this.updateQName(elem, this.fQName);
                    this.fConfiguration.fErrorHandlerWrapper.fCurrentNode = node;
                    this.fCurrentNode = node;
                    this.fValidationHandler.startElement(this.fQName, this.fAttrProxy, null);
                }
                Node kid = elem.getFirstChild();
                while (kid != null) {
                    Node next = kid.getNextSibling();
                    if ((kid = this.normalizeNode(kid)) != null) {
                        next = kid;
                    }
                    kid = next;
                }
                if (this.fValidationHandler != null) {
                    this.updateQName(elem, this.fQName);
                    this.fConfiguration.fErrorHandlerWrapper.fCurrentNode = node;
                    this.fCurrentNode = node;
                    this.fValidationHandler.endElement(this.fQName, null);
                }
                this.fNamespaceContext.popContext();
                break;
            }
            case 8: {
                Node nextSibling;
                if ((this.fConfiguration.features & 0x20) != 0) break;
                Node prevSibling = node.getPreviousSibling();
                Node parent = node.getParentNode();
                parent.removeChild(node);
                if (prevSibling == null || prevSibling.getNodeType() != 3 || (nextSibling = prevSibling.getNextSibling()) == null || nextSibling.getNodeType() != 3) break;
                ((TextImpl)nextSibling).insertData(0, prevSibling.getNodeValue());
                parent.removeChild(prevSibling);
                return nextSibling;
            }
            case 5: {
                Node next;
                if ((this.fConfiguration.features & 4) != 0) break;
                Node prevSibling = node.getPreviousSibling();
                Node parent = node.getParentNode();
                ((EntityReferenceImpl)node).setReadOnly(false, true);
                this.expandEntityRef(node, parent, node);
                parent.removeChild(node);
                Node node2 = next = prevSibling != null ? prevSibling.getNextSibling() : parent.getFirstChild();
                if (prevSibling != null && prevSibling.getNodeType() == 3 && next.getNodeType() == 3) {
                    return prevSibling;
                }
                return next;
            }
            case 4: {
                if ((this.fConfiguration.features & 8) == 0) {
                    Text text = this.fDocument.createTextNode(node.getNodeValue());
                    Node parent = node.getParentNode();
                    Node prevSibling = node.getPreviousSibling();
                    node = parent.replaceChild(text, node);
                    if (prevSibling != null && prevSibling.getNodeType() == 3) {
                        text.insertData(0, prevSibling.getNodeValue());
                        parent.removeChild(prevSibling);
                    }
                    return text;
                }
                if (this.fValidationHandler != null) {
                    this.fConfiguration.fErrorHandlerWrapper.fCurrentNode = node;
                    this.fCurrentNode = node;
                    this.fValidationHandler.startCDATA(null);
                    this.fValidationHandler.characterData(node.getNodeValue(), null);
                    this.fValidationHandler.endCDATA(null);
                }
                if ((this.fConfiguration.features & 0x10) == 0) break;
                String value = node.getNodeValue();
                int index = value.indexOf("]]>");
                if (index >= 0) {
                    // empty if block
                }
                Node parent = node.getParentNode();
                while (index >= 0) {
                    node.setNodeValue(value.substring(0, index + 2));
                    value = value.substring(index + 2);
                    node = this.fDocument.createCDATASection(value);
                    parent.insertBefore(node, node.getNextSibling());
                    index = value.indexOf("]]>");
                }
                break;
            }
            case 3: {
                int nextType;
                Node next = node.getNextSibling();
                if (next != null && next.getNodeType() == 3) {
                    ((Text)node).appendData(next.getNodeValue());
                    node.getParentNode().removeChild(next);
                    return node;
                }
                if (node.getNodeValue().length() == 0) {
                    node.getParentNode().removeChild(node);
                    break;
                }
                if (this.fValidationHandler == null) break;
                int n = nextType = next != null ? (int)next.getNodeType() : -1;
                if ((this.fConfiguration.features & 4) == 0 && nextType == 6 || (this.fConfiguration.features & 0x20) == 0 && nextType == 8 || (this.fConfiguration.features & 8) == 0 && nextType == 4) break;
                this.fConfiguration.fErrorHandlerWrapper.fCurrentNode = node;
                this.fCurrentNode = node;
                this.fValidationHandler.characterData(node.getNodeValue(), null);
                break;
            }
        }
        return null;
    }

    protected final void expandEntityRef(Node node, Node parent, Node reference) {
        Node kid = node.getFirstChild();
        while (kid != null) {
            Node next = kid.getNextSibling();
            if (node.getNodeType() == 3) {
                this.expandEntityRef(kid, parent, reference);
            } else {
                parent.insertBefore(kid, reference);
            }
            kid = next;
        }
    }

    protected final void namespaceFixUp(ElementImpl element, AttributeMap attributes) {
        String prefix;
        boolean continueProcess;
        String value;
        String uri;
        Attr attr;
        if (attributes != null) {
            int k = 0;
            while (k < attributes.getLength()) {
                attr = (Attr)attributes.getItem(k);
                uri = attr.getNamespaceURI();
                if (uri != null && uri.equals(NamespaceContext.XMLNS_URI)) {
                    value = attr.getNodeValue();
                    if (value == null) {
                        value = XMLSymbols.EMPTY_STRING;
                    }
                    if (value.equals(NamespaceContext.XMLNS_URI)) {
                        if (this.fErrorHandler != null) {
                            this.modifyDOMError("No prefix other than 'xmlns' can be bound to 'http://www.w3.org/2000/xmlns/' namespace name", (short)1, attr);
                            continueProcess = this.fErrorHandler.handleError(this.fDOMError);
                            if (!continueProcess) {
                                throw new RuntimeException("Stopped at user request");
                            }
                        }
                    } else {
                        prefix = attr.getPrefix();
                        prefix = prefix == null || prefix.length() == 0 ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(prefix);
                        String localpart = this.fSymbolTable.addSymbol(attr.getLocalName());
                        if (prefix == XMLSymbols.PREFIX_XMLNS) {
                            if ((value = this.fSymbolTable.addSymbol(value)).length() != 0) {
                                this.fNamespaceContext.declarePrefix(localpart, value);
                                this.fLocalNSBinder.declarePrefix(localpart, value);
                            }
                        } else {
                            value = this.fSymbolTable.addSymbol(value);
                            this.fLocalNSBinder.declarePrefix(XMLSymbols.EMPTY_STRING, value);
                            this.fNamespaceContext.declarePrefix(XMLSymbols.EMPTY_STRING, value);
                        }
                    }
                }
                ++k;
            }
        }
        uri = element.getNamespaceURI();
        prefix = element.getPrefix();
        if (uri != null) {
            uri = this.fSymbolTable.addSymbol(uri);
            String string = prefix = prefix == null || prefix.length() == 0 ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(prefix);
            if (this.fNamespaceContext.getURI(prefix) != uri) {
                this.addNamespaceDecl(prefix, uri, element);
                this.fLocalNSBinder.declarePrefix(prefix, uri);
                this.fNamespaceContext.declarePrefix(prefix, uri);
            }
        } else {
            String tagName = element.getNodeName();
            int colon = tagName.indexOf(58);
            if (colon > -1) {
                continueProcess = true;
                if (this.fErrorHandler != null) {
                    if (this.fNamespaceValidation) {
                        this.modifyDOMError("DOM Level 1 node: " + tagName, (short)2, element);
                        this.fErrorHandler.handleError(this.fDOMError);
                    } else {
                        this.modifyDOMError("DOM Level 1 node: " + tagName, (short)1, element);
                        continueProcess = this.fErrorHandler.handleError(this.fDOMError);
                    }
                }
                if (this.fNamespaceValidation || !continueProcess) {
                    throw new RuntimeException("DOM Level 1 node: " + tagName);
                }
            } else {
                uri = this.fNamespaceContext.getURI(XMLSymbols.EMPTY_STRING);
                if (uri != null && uri.length() > 0) {
                    this.addNamespaceDecl(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING, element);
                    this.fLocalNSBinder.declarePrefix(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
                    this.fNamespaceContext.declarePrefix(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
                }
            }
        }
        if (attributes != null) {
            attributes.cloneMap(this.fAttributeList);
            int i = 0;
            while (i < this.fAttributeList.size()) {
                attr = (Attr)this.fAttributeList.elementAt(i);
                attr.normalize();
                value = attr.getValue();
                String name = attr.getNodeName();
                uri = attr.getNamespaceURI();
                if (value == null) {
                    value = XMLSymbols.EMPTY_STRING;
                }
                if (uri != null) {
                    prefix = attr.getPrefix();
                    prefix = prefix == null || prefix.length() == 0 ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(prefix);
                    String localpart = this.fSymbolTable.addSymbol(attr.getLocalName());
                    if (uri == null || !uri.equals(NamespaceContext.XMLNS_URI)) {
                        ((AttrImpl)attr).setIdAttribute(false);
                        uri = this.fSymbolTable.addSymbol(uri);
                        String declaredURI = this.fNamespaceContext.getURI(prefix);
                        if (prefix == XMLSymbols.EMPTY_STRING || declaredURI != uri) {
                            name = attr.getNodeName();
                            String declaredPrefix = this.fNamespaceContext.getPrefix(uri);
                            if (declaredPrefix != null && declaredPrefix != XMLSymbols.EMPTY_STRING) {
                                prefix = declaredPrefix;
                            } else {
                                if (prefix == XMLSymbols.EMPTY_STRING || this.fLocalNSBinder.getURI(prefix) != null) {
                                    prefix = this.fSymbolTable.addSymbol(PREFIX + this.fNamespaceCounter++);
                                    while (this.fLocalNSBinder.getURI(prefix) != null) {
                                        prefix = this.fSymbolTable.addSymbol(PREFIX + this.fNamespaceCounter++);
                                    }
                                }
                                this.addNamespaceDecl(prefix, uri, element);
                                value = this.fSymbolTable.addSymbol(value);
                                this.fLocalNSBinder.declarePrefix(prefix, value);
                                this.fNamespaceContext.declarePrefix(prefix, uri);
                            }
                            attr.setPrefix(prefix);
                        }
                    }
                } else {
                    int colon = name.indexOf(58);
                    ((AttrImpl)attr).setIdAttribute(false);
                    if (colon > -1) {
                        boolean continueProcess2 = true;
                        if (this.fErrorHandler != null) {
                            if (this.fNamespaceValidation) {
                                this.modifyDOMError("DOM Level 1 node: " + name, (short)2, attr);
                                this.fErrorHandler.handleError(this.fDOMError);
                            } else {
                                this.modifyDOMError("DOM Level 1 node: " + name, (short)1, attr);
                                continueProcess2 = this.fErrorHandler.handleError(this.fDOMError);
                            }
                        }
                        if (this.fNamespaceValidation || !continueProcess2) {
                            throw new RuntimeException("DOM Level 1 node");
                        }
                    }
                }
                ++i;
            }
        }
    }

    protected final void addNamespaceDecl(String prefix, String uri, ElementImpl element) {
        if (prefix == XMLSymbols.EMPTY_STRING) {
            element.setAttributeNS(NamespaceContext.XMLNS_URI, XMLSymbols.PREFIX_XMLNS, uri);
        } else {
            element.setAttributeNS(NamespaceContext.XMLNS_URI, "xmlns:" + prefix, uri);
        }
    }

    protected final DOMError modifyDOMError(String message, short severity, Node node) {
        this.fDOMError.reset();
        this.fDOMError.fMessage = message;
        this.fDOMError.fSeverity = severity;
        this.fDOMError.fLocator = this.fLocator;
        this.fLocator.fErrorNode = node;
        return this.fDOMError;
    }

    protected final void updateQName(Node node, QName qname) {
        String prefix = node.getPrefix();
        String namespace = node.getNamespaceURI();
        String localName = node.getLocalName();
        qname.prefix = prefix != null && prefix.length() != 0 ? this.fSymbolTable.addSymbol(prefix) : null;
        qname.localpart = localName != null ? this.fSymbolTable.addSymbol(localName) : null;
        qname.rawname = this.fSymbolTable.addSymbol(node.getNodeName());
        qname.uri = namespace != null ? this.fSymbolTable.addSymbol(namespace) : null;
    }

    final String normalizeAttributeValue(String value, Attr attr) {
        if (!attr.getSpecified()) {
            return value;
        }
        int end = value.length();
        if (this.fNormalizedValue.ch.length < end) {
            this.fNormalizedValue.ch = new char[end];
        }
        this.fNormalizedValue.length = 0;
        boolean normalized = false;
        int i = 0;
        while (i < end) {
            char c = value.charAt(i);
            if (c == '\t' || c == '\n') {
                this.fNormalizedValue.ch[this.fNormalizedValue.length++] = 32;
                normalized = true;
            } else if (c == '\r') {
                normalized = true;
                this.fNormalizedValue.ch[this.fNormalizedValue.length++] = 32;
                int next = i + 1;
                if (next < end && value.charAt(next) == '\n') {
                    i = next;
                }
            } else {
                this.fNormalizedValue.ch[this.fNormalizedValue.length++] = c;
            }
            ++i;
        }
        if (normalized) {
            value = this.fNormalizedValue.toString();
            attr.setValue(value);
        }
        return value;
    }

    public void startDocument(XMLLocator locator, String encoding, NamespaceContext namespaceContext, Augmentations augs) throws XNIException {
    }

    public void xmlDecl(String version, String encoding, String standalone, Augmentations augs) throws XNIException {
    }

    public void doctypeDecl(String rootElement, String publicId, String systemId, Augmentations augs) throws XNIException {
    }

    public void comment(XMLString text, Augmentations augs) throws XNIException {
    }

    public void processingInstruction(String target, XMLString data, Augmentations augs) throws XNIException {
    }

    public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        Element currentElement = (Element)this.fCurrentNode;
        int attrCount = attributes.getLength();
        int i = 0;
        while (i < attrCount) {
            attributes.getName(i, this.fAttrQName);
            Attr attr = null;
            attr = currentElement.getAttributeNodeNS(this.fAttrQName.uri, this.fAttrQName.localpart);
            AttributePSVI attrPSVI = (AttributePSVI)attributes.getAugmentations(i).getItem("ATTRIBUTE_PSVI");
            if (attrPSVI != null) {
                XSTypeDefinition decl = attrPSVI.getMemberTypeDefinition();
                boolean id = false;
                if (decl != null) {
                    id = ((XSSimpleType)decl).isIDType();
                } else {
                    decl = attrPSVI.getTypeDefinition();
                    if (decl != null) {
                        id = ((XSSimpleType)decl).isIDType();
                    }
                }
                if (id) {
                    ((ElementImpl)currentElement).setIdAttributeNode(attr, true);
                }
                if (this.fPSVI) {
                    ((PSVIAttrNSImpl)attr).setPSVI(attrPSVI);
                }
                if ((this.fConfiguration.features & 2) != 0) {
                    boolean specified = attr.getSpecified();
                    attr.setValue(attrPSVI.getSchemaNormalizedValue());
                    if (!specified) {
                        ((AttrImpl)attr).setSpecified(specified);
                    }
                }
            }
            ++i;
        }
    }

    public void emptyElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        this.startElement(element, attributes, augs);
        this.endElement(element, augs);
    }

    public void startGeneralEntity(String name, XMLResourceIdentifier identifier, String encoding, Augmentations augs) throws XNIException {
    }

    public void textDecl(String version, String encoding, Augmentations augs) throws XNIException {
    }

    public void endGeneralEntity(String name, Augmentations augs) throws XNIException {
    }

    public void characters(XMLString text, Augmentations augs) throws XNIException {
    }

    public void ignorableWhitespace(XMLString text, Augmentations augs) throws XNIException {
    }

    public void endElement(QName element, Augmentations augs) throws XNIException {
        ElementPSVI elementPSVI = (ElementPSVI)augs.getItem("ELEMENT_PSVI");
        if (elementPSVI != null) {
            ElementImpl elementNode = (ElementImpl)this.fCurrentNode;
            if (this.fPSVI) {
                ((PSVIElementNSImpl)this.fCurrentNode).setPSVI(elementPSVI);
            }
            String normalizedValue = elementPSVI.getSchemaNormalizedValue();
            if ((this.fConfiguration.features & 2) != 0) {
                elementNode.setTextContent(normalizedValue);
            } else {
                String text = elementNode.getTextContent();
                if (text.length() == 0) {
                    elementNode.setTextContent(normalizedValue);
                }
            }
        }
    }

    public void startCDATA(Augmentations augs) throws XNIException {
    }

    public void endCDATA(Augmentations augs) throws XNIException {
    }

    public void endDocument(Augmentations augs) throws XNIException {
    }

    public void setDocumentSource(XMLDocumentSource source) {
    }

    public XMLDocumentSource getDocumentSource() {
        return null;
    }

    protected final class XMLAttributesProxy
    implements XMLAttributes {
        protected AttributeMap fAttributes;
        protected CoreDocumentImpl fDocument;
        protected ElementImpl fElement;
        protected final Vector fAugmentations = new Vector(5);

        protected XMLAttributesProxy() {
        }

        public void setAttributes(AttributeMap attributes, CoreDocumentImpl doc, ElementImpl elem) {
            this.fDocument = doc;
            this.fAttributes = attributes;
            this.fElement = elem;
            if (attributes != null) {
                int length = attributes.getLength();
                this.fAugmentations.setSize(length);
                int i = 0;
                while (i < length) {
                    this.fAugmentations.setElementAt(new AugmentationsImpl(), i);
                    ++i;
                }
            } else {
                this.fAugmentations.setSize(0);
            }
        }

        public int addAttribute(QName qname, String attrType, String attrValue) {
            int index = this.fElement.getXercesAttribute(qname.uri, qname.localpart);
            if (index < 0) {
                AttrImpl attr = (AttrImpl)((CoreDocumentImpl)this.fElement.getOwnerDocument()).createAttributeNS(qname.uri, qname.rawname, qname.localpart);
                index = this.fElement.setXercesAttributeNode(attr);
                attr.setNodeValue(attrValue);
                this.fAugmentations.insertElementAt(new AugmentationsImpl(), index);
                attr.setSpecified(false);
            }
            return index;
        }

        public void removeAllAttributes() {
        }

        public void removeAttributeAt(int attrIndex) {
        }

        public int getLength() {
            return this.fAttributes != null ? this.fAttributes.getLength() : 0;
        }

        public int getIndex(String qName) {
            return -1;
        }

        public int getIndex(String uri, String localPart) {
            return -1;
        }

        public void setName(int attrIndex, QName attrName) {
        }

        public void getName(int attrIndex, QName attrName) {
            if (this.fAttributes != null) {
                DOMNormalizer.this.updateQName((Node)this.fAttributes.getItem(attrIndex), attrName);
            }
        }

        public String getPrefix(int index) {
            return null;
        }

        public String getURI(int index) {
            return null;
        }

        public String getLocalName(int index) {
            return null;
        }

        public String getQName(int index) {
            return null;
        }

        public void setType(int attrIndex, String attrType) {
        }

        public String getType(int index) {
            return "CDATA";
        }

        public String getType(String qName) {
            return "CDATA";
        }

        public String getType(String uri, String localName) {
            return "CDATA";
        }

        public void setValue(int attrIndex, String attrValue) {
            if (this.fAttributes != null) {
                AttrImpl attr = (AttrImpl)this.fAttributes.getItem(attrIndex);
                boolean specified = attr.getSpecified();
                attr.setValue(attrValue);
                attr.setSpecified(specified);
            }
        }

        public String getValue(int index) {
            return this.fAttributes != null ? this.fAttributes.item(index).getNodeValue() : "";
        }

        public String getValue(String qName) {
            return null;
        }

        public String getValue(String uri, String localName) {
            if (this.fAttributes != null) {
                Node node = this.fAttributes.getNamedItemNS(uri, localName);
                return node != null ? node.getNodeValue() : null;
            }
            return null;
        }

        public void setNonNormalizedValue(int attrIndex, String attrValue) {
        }

        public String getNonNormalizedValue(int attrIndex) {
            return null;
        }

        public void setSpecified(int attrIndex, boolean specified) {
            AttrImpl attr = (AttrImpl)this.fAttributes.getItem(attrIndex);
            attr.setSpecified(specified);
        }

        public boolean isSpecified(int attrIndex) {
            return ((Attr)this.fAttributes.getItem(attrIndex)).getSpecified();
        }

        public Augmentations getAugmentations(int attributeIndex) {
            return (Augmentations)this.fAugmentations.elementAt(attributeIndex);
        }

        public Augmentations getAugmentations(String uri, String localPart) {
            return null;
        }

        public Augmentations getAugmentations(String qName) {
            return null;
        }

        public void setAugmentations(int attrIndex, Augmentations augs) {
            this.fAugmentations.setElementAt(augs, attrIndex);
        }
    }
}

